<?php 
  $expert_adventure_guide_tours = get_theme_mod('expert_adventure_guide_tours_setting','1');
  $expert_adventure_guide_tours_button = get_theme_mod('expert_adventure_guide_tours_button_setting','1');
  
  if($expert_adventure_guide_tours == '1') {
?>
<section id="travel-offer" class="py-5">
  <div class="container">
    <div class="row">
      <?php
          $expert_adventure_guide_btn_text = get_theme_mod( 'expert_adventure_guide_btn_text' );
          $expert_adventure_guide_btn_link = get_theme_mod( 'expert_adventure_guide_btn_link' );
        ?>
      <div class="col-lg-10 col-md-9 col-12 align-self-center">
        <?php if( get_theme_mod('expert_adventure_guide_offer_section_short_title') != ''){ ?>
          <strong><?php echo esc_html(get_theme_mod('expert_adventure_guide_offer_section_short_title','')); ?></strong>
        <?php }?>
        <?php if( get_theme_mod('expert_adventure_guide_offer_section_tittle') != ''){ ?>
          <h2 class="my-3"><?php echo esc_html(get_theme_mod('expert_adventure_guide_offer_section_tittle','')); ?></h2>
        <?php }?>
        <?php if( get_theme_mod('expert_adventure_guide_offer_section_text') != ''){ ?>
          <p><?php echo esc_html(get_theme_mod('expert_adventure_guide_offer_section_text','')); ?></p>
        <?php }?>
      </div>
      <div class="col-lg-2 col-md-3 text-md-end col-12 mt-md-0 mt-3 align-self-center">
        <?php if( $expert_adventure_guide_btn_link != '' && $expert_adventure_guide_btn_text != ''){?>
          <a class="tour-btn" href="<?php echo $expert_adventure_guide_btn_link ?>" class="sec-btn"><?php echo $expert_adventure_guide_btn_text ?></a>
        <?php }?>
      </div>
    </div>
    <div class="row mt-4">
      <?php
        $expert_adventure_guide_post_category = get_theme_mod('expert_adventure_guide_offer_section_category','uncategorized');
        if($expert_adventure_guide_post_category){
          $expert_adventure_guide_page_query = new WP_Query(array( 'category_name' => esc_html( $expert_adventure_guide_post_category ,'expert-adventure-guide')));?>
          <?php while( $expert_adventure_guide_page_query->have_posts() ) : $expert_adventure_guide_page_query->the_post(); ?>
            <div class="col-lg-4 col-md-6 col-sm-6 wow fadeInUp" data-wow-delay="0.5s">
              <div class="cat-inner-box mb-4">
                <?php if ( has_post_thumbnail() ) : ?>
                    <img src="<?php the_post_thumbnail_url('full'); ?>"/>
                <?php else : ?>
                    <div class="tour-color"></div>
                <?php endif; ?>

                <h4>
                  <?php 
                    $trip_amount = get_post_meta($post->ID, 'expert_adventure_guide_trip_amount', true);
                    echo esc_html($trip_amount ? $trip_amount : '$399'); 
                  ?>
                </h4>
                <div class="offer-box p-3">
                  <h3><?php the_title(); ?></h3>
                  <span>
                    <i class="far fa-clock me-2"></i>
                    <?php 
                      $trip_days = get_post_meta($post->ID, 'expert_adventure_guide_trip_days', true);
                      echo esc_html($trip_days ? $trip_days : '7 days 6 nights'); 
                    ?>
                  </span>
                  <p><?php echo wp_trim_words( get_the_content(),12 );?></p>
                  <?php if($expert_adventure_guide_tours_button == '1') { ?>
                    <div class="mt-4 text-end">
                      <a href="<?php the_permalink(); ?>"><?php esc_html_e('Learn More','expert-adventure-guide'); ?></a>
                    </div>
                  <?php } ?>
                </div>
              </div>
            </div>
          <?php endwhile;
          wp_reset_postdata();
        }?>
    </div>
  </div>
</section>
<?php }?>