<?php 
  $expert_adventure_guide_slider = get_theme_mod('expert_adventure_guide_slider_enable_setting', '1');
  $expert_adventure_guide_slider_button = get_theme_mod('expert_adventure_guide_slider_button_setting', '1');
  
  if($expert_adventure_guide_slider == '1') {
?>
<section id="slider-section" class="slider-area home-slider">
  <!-- start of hero -->
  <div id="carouselExampleInterval" class="carousel slide" data-bs-ride="carousel">
    <?php

      $expert_adventure_guide_pages = array();
        for ($expert_adventure_guide_count = 1; $expert_adventure_guide_count <= 3; $expert_adventure_guide_count++) {
            $expert_adventure_guide_mod = intval(get_theme_mod('expert_adventure_guide_slider' . $expert_adventure_guide_count));
        
            // Check that the value is valid and not the placeholder value 'page-none-selected'
            if ('page-none-selected' !== $expert_adventure_guide_mod && $expert_adventure_guide_mod > 0) {
                $expert_adventure_guide_pages[] = $expert_adventure_guide_mod;
            }
        }

      if (!empty($expert_adventure_guide_pages)) :
        $args = array(
          'post_type' => 'page',
          'post__in' => $expert_adventure_guide_pages,
          'orderby' => 'post__in'
        );
        $query = new WP_Query($args);
        if ($query->have_posts()) :
          $i = 1;
    ?>
    <div class="carousel-inner" role="listbox">
      <?php while ($query->have_posts()) : $query->the_post(); ?>
        <div <?php if($i == 1) { echo 'class="carousel-item active"'; } else { echo 'class="carousel-item"'; } ?>>
          <?php if (has_post_thumbnail()) { ?>
            <img src="<?php the_post_thumbnail_url('full'); ?>" alt="<?php the_title_attribute(); ?>" />
          <?php } else { ?>
            <div class="slider-color-box"></div>
          <?php } ?>
          <div class="carousel-caption">
            <div class="inner_carousel wow fadeInUp" data-wow-delay="0.5s">
              <?php     
                $expert_adventure_guide_slider_text = get_theme_mod('expert_adventure_guide_slider_text');
                $expert_adventure_guide_button_link_slider2 = get_theme_mod('expert_adventure_guide_button_link_slider2');
                $expert_adventure_guide_button_text2 = get_theme_mod('expert_adventure_guide_button_text2', 'DISCOVER MORE');
              ?>
              <?php if ($expert_adventure_guide_slider_text != '') { ?>
                <p class="mb-3 slider-top-text"><?php echo esc_html($expert_adventure_guide_slider_text); ?></p>
              <?php } ?>
              <h2><a href="<?php echo esc_url(get_permalink()); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
              <p><?php echo esc_html(wp_trim_words(get_the_content(), 25)); ?></p>
              <?php if ($expert_adventure_guide_slider_button == '1') { ?>
                <div class="read-btn mt-4">
                  <a href="<?php the_permalink(); ?>" class="mb-2 me-3"><?php echo esc_html('VIEW TOURS', 'expert-adventure-guide'); ?></a>
                  <?php if ($expert_adventure_guide_button_text2 != '' 
                  || $expert_adventure_guide_button_link_slider2) { ?>
                    <a href="<?php echo esc_url($expert_adventure_guide_button_link_slider2); ?>" class="mb-2"><?php echo esc_html($expert_adventure_guide_button_text2, 'DISCOVER MORE'); ?></a>
                  <?php } ?>
                </div>
              <?php } ?>
            </div>
          </div>
        </div>
      <?php $i++; endwhile; 
      wp_reset_postdata(); ?>
    </div>
    <?php else : ?>
      <div class="no-postfound"></div>
    <?php endif; endif; ?>
    <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleInterval" id="prev" data-bs-slide="prev">
      <i class="fas fa-angle-left"></i>
      <span class="screen-reader-text"><?php echo esc_html('Previous', 'expert-adventure-guide'); ?></span>
    </button>
    <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleInterval" data-bs-slide="next" id="next">
      <i class="fas fa-angle-right"></i>
      <span class="screen-reader-text"><?php echo esc_html('Next', 'expert-adventure-guide'); ?></span>
    </button>
  </div>
  <!-- end of hero slider -->
</section>
<?php } ?>
