<?php

// Load the JS and CSS.
add_action( 'customize_controls_enqueue_scripts', function() {

	$version = wp_get_theme()->get( 'Version' );

	wp_enqueue_script(
		'expert-adventure-guide-customize-section-button',
		get_theme_file_uri( 'assets/js/customize-controls.js' ),
		[ 'customize-controls' ],
		$version,
		true
	);
	wp_localize_script(
		'expert-adventure-guide-customize-section-button',
		'expert_adventure_guide_customizer_params',
		array(
			'ajaxurl' =>	admin_url( 'admin-ajax.php' )
		)
	);

	wp_enqueue_style(
		'expert-adventure-guide-customize-section-button',
		get_theme_file_uri( 'assets/css/customize-controls.css' ),
		[ 'customize-controls' ],
 		$version
	);

} );

 /**
 * Enqueue scripts and styles.
 */
function expert_adventure_guide_scripts() {
	
	// Styles	 

	wp_enqueue_style('all-min',get_template_directory_uri().'/assets/css/all.min.css');

	wp_enqueue_style('bootstrap-min',get_template_directory_uri().'/assets/css/bootstrap.min.css');
	
	wp_enqueue_style('owl-carousel-min',get_template_directory_uri().'/assets/css/owl.carousel.min.css');
	
	wp_enqueue_style('font-awesome',get_template_directory_uri().'/assets/css/fonts/font-awesome/css/font-awesome.min.css');
	
	wp_enqueue_style('expert-adventure-guide-editor-style',get_template_directory_uri().'/assets/css/editor-style.css');

	wp_enqueue_style('expert-adventure-guide-main', get_template_directory_uri() . '/assets/css/main.css');

	wp_enqueue_style('expert-adventure-guide-woo', get_template_directory_uri() . '/assets/css/woo.css');
	
	wp_enqueue_style( 'expert-adventure-guide-style', get_stylesheet_uri() );

    wp_enqueue_style('expert-adventure-guide-main', get_stylesheet_uri(), array() );
		wp_style_add_data('expert-adventure-guide-main', 'rtl', 'replace');
	
	// Scripts

	wp_enqueue_script('bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.bundle.min.js', array('jquery'), false, true);

	wp_enqueue_script('expert-adventure-guide-sliderscript', get_template_directory_uri().'/assets/js/sliderscript.js', array('jquery'), '1.1', true);

	wp_enqueue_script('owl-carousel', get_template_directory_uri() . '/assets/js/owl.carousel.min.js', array('jquery'), false, true);

	wp_enqueue_script('expert-adventure-guide-theme-js', get_template_directory_uri() . '/assets/js/theme.js', array('jquery'), false, true);

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

    // Animations
    if ( get_theme_mod( 'expert_adventure_guide_animation_enabled', true ) ) {
        wp_enqueue_script('wow-js', get_theme_file_uri('/assets/js/wow.js'), array('jquery'), null, true);
        wp_enqueue_style('animate-css', get_template_directory_uri() . '/assets/css/animate.css');
    }
}
add_action( 'wp_enqueue_scripts', 'expert_adventure_guide_scripts' );

// Function to enqueue custom CSS
function expert_adventure_guide_enqueue_custom_css() {
    // Define a unique handle for your inline stylesheet
    $handle = 'expert-adventure-guide-style';
    
    // Get the generated custom CSS
    $expert_adventure_guide_custom_css = "";

    $expert_adventure_guide_blog_layouts = get_theme_mod('expert_adventure_guide_blog_layout_option_setting', 'Default');
    if ($expert_adventure_guide_blog_layouts == 'Default') {
        $expert_adventure_guide_custom_css .= '.blog-item{';
        $expert_adventure_guide_custom_css .= 'text-align:center;';
        $expert_adventure_guide_custom_css .= '}';
    } elseif ($expert_adventure_guide_blog_layouts == 'Left') {
        $expert_adventure_guide_custom_css .= '.blog-item{';
        $expert_adventure_guide_custom_css .= 'text-align:Left;';
        $expert_adventure_guide_custom_css .= '}';
    } elseif ($expert_adventure_guide_blog_layouts == 'Right') {
        $expert_adventure_guide_custom_css .= '.blog-item{';
        $expert_adventure_guide_custom_css .= 'text-align:Right;';
        $expert_adventure_guide_custom_css .= '}';
    }

    // Enqueue the inline stylesheet
    wp_add_inline_style($handle, $expert_adventure_guide_custom_css);

    // Add inline style for Scroll to Top
    $expert_adventure_guide_scroll_top_bg_color = get_theme_mod('expert_adventure_guide_scroll_top_bg_color', '#d4635e');
    $expert_adventure_guide_scroll_top_color = get_theme_mod('expert_adventure_guide_scroll_top_color', '#fff');

    // Use global if still default
    if ( $expert_adventure_guide_scroll_top_bg_color === '#d4635e' ) {
        $expert_adventure_guide_scroll_top_bg_color = get_theme_mod('expert_adventure_guide_dynamic_color_one');
    }

    $expert_adventure_guide_scroll_custom_css = "
        #scrolltop {
            background-color: {$expert_adventure_guide_scroll_top_bg_color};
        }
        #scrolltop span {
            color: {$expert_adventure_guide_scroll_top_color};
        }
    ";
    wp_add_inline_style('expert-adventure-guide-style', $expert_adventure_guide_scroll_custom_css);

    // Add inline style for Preloader
    $expert_adventure_guide_preloader_bg_color = get_theme_mod('expert_adventure_guide_preloader_bg_color', '#ffffff');
    $expert_adventure_guide_preloader_color = get_theme_mod('expert_adventure_guide_preloader_color', '#d4635e');

    // Use global if still default
    if ( $expert_adventure_guide_preloader_color === '#d4635e' ) {
        $expert_adventure_guide_preloader_color = get_theme_mod('expert_adventure_guide_dynamic_color_one');
    }

    $expert_adventure_guide_preloader_custom_css = "
        .loading {
            background-color: {$expert_adventure_guide_preloader_bg_color};
        }
        .loader {
            border-color: {$expert_adventure_guide_preloader_color};
            color: {$expert_adventure_guide_preloader_color};
            text-shadow: 0 0 10px {$expert_adventure_guide_preloader_color};
        }
        .loader::before {
            border-top-color: {$expert_adventure_guide_preloader_color};
            border-right-color: {$expert_adventure_guide_preloader_color};
        }
        .loader span::before {
            background: {$expert_adventure_guide_preloader_color};
            box-shadow: 0 0 10px {$expert_adventure_guide_preloader_color};
        }
    ";
    wp_add_inline_style('expert-adventure-guide-style', $expert_adventure_guide_preloader_custom_css);
}

// Hook the function to the 'wp_enqueue_scripts' action
add_action('wp_enqueue_scripts', 'expert_adventure_guide_enqueue_custom_css');