<?php
/**
 * Customizer: Sanitization Callbacks
 *
 * This file demonstrates how to define sanitization callback functions for various data types.
 * 
 * @package   Expert Adventure Guide
 * @copyright Copyright (c) 2015, WordPress Theme Review Team
 * @license   http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU General Public License, v2 (or newer)
 */

function expert_adventure_guide_sanitize_checkbox( $expert_adventure_guide_checked ) {
	return ( ( isset( $expert_adventure_guide_checked ) && true == $expert_adventure_guide_checked ) ? true : false );
}

function expert_adventure_guide_switch_sanitization( $expert_adventure_guide_input ) {
    if ( true === $expert_adventure_guide_input ) {
        return 1;
    } else {
        return 0;
    }
}

function expert_adventure_guide_sanitize_choices( $expert_adventure_guide_input, $expert_adventure_guide_setting ) {
    global $wp_customize; 
    $expert_adventure_guide_control = $wp_customize->get_control( $expert_adventure_guide_setting->id ); 
    if ( array_key_exists( $expert_adventure_guide_input, $expert_adventure_guide_control->choices ) ) {
        return $expert_adventure_guide_input;
    } else {
        return $expert_adventure_guide_setting->default;
    }
}

function expert_adventure_guide_sanitize_float( $expert_adventure_guide_input ) {
    return filter_var($expert_adventure_guide_input, FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
}

function expert_adventure_guide_sanitize_html( $expert_adventure_guide_html ) {
	return wp_kses_post( force_balance_tags( $expert_adventure_guide_html ) );
}

/* Sanitization Text*/
function expert_adventure_guide_sanitize_text( $expert_adventure_guide_text ) {
	return wp_filter_post_kses( $expert_adventure_guide_text );
}

function expert_adventure_guide_sanitize_phone_number( $expert_adventure_guide_phone ) {
    return preg_replace( '/[^\d+]/', '', $expert_adventure_guide_phone );
}

// Sanitization callback function for numeric input
function expert_adventure_guide_sanitize_numeric_input($expert_adventure_guide_input) {
    // Remove any non-numeric characters
    return preg_replace('/[^0-9]/', '', $expert_adventure_guide_input);
}

// Sanitization callback function for logo width
function expert_adventure_guide_sanitize_logo_width($expert_adventure_guide_input) {
    $expert_adventure_guide_input = absint($expert_adventure_guide_input); // Convert to integer
    // Ensure the value is between 1 and 150
    return ($expert_adventure_guide_input >= 1 && $expert_adventure_guide_input <= 300) ? $expert_adventure_guide_input : 150; // Default to 270 if out of range
}

// Sanitize the input
function expert_adventure_sanitize_sidebar_position( $expert_adventure_guide_input ) {
    $expert_adventure_guide_valid = array( 'right', 'left' );

    if ( in_array( $expert_adventure_guide_input, $expert_adventure_guide_valid ) ) {
        return $expert_adventure_guide_input;
    } else {
        return 'right';
    }
}

function expert_adventure_guide_sanitize_copyright_position( $expert_adventure_guide_input ) {
    $expert_adventure_guide_valid = array( 'right', 'left', 'center' );

    if ( in_array( $expert_adventure_guide_input, $expert_adventure_guide_valid, true ) ) {
        return $expert_adventure_guide_input;
    } else {
        return 'right';
    }
}