<?php
function expert_adventure_guide_sidebar_setting( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
		'expert_adventure_guide_sidebar', array(
			'priority' => 31,
			'title' => esc_html__( 'Sidebar Options', 'expert-adventure-guide' ),
		)
	);

	/*=========================================
	Sidebar Option  Section
	=========================================*/
	$wp_customize->add_section(
		'expert_adventure_guide_sidebar_settings', array(
			'title' => esc_html__( 'Sidebar Options', 'expert-adventure-guide' ),
			'priority' => 1,
			'panel' => 'expert_adventure_guide_general',
		)
	);
	

	// Archive Sidebar Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_archive_sidebar_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_archive_sidebar_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Archive Sidebar', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_sidebar_settings',
			'settings'    => 'expert_adventure_guide_archive_sidebar_setting',
			'type'        => 'checkbox'
		) 
	);

	// Index Sidebar Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_index_sidebar_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_index_sidebar_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Index Sidebar', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_sidebar_settings',
			'settings'    => 'expert_adventure_guide_index_sidebar_setting',
			'type'        => 'checkbox'
		) 
	);

	// Pages Sidebar Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_paged_sidebar_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_paged_sidebar_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Pages Sidebar', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_sidebar_settings',
			'settings'    => 'expert_adventure_guide_paged_sidebar_setting',
			'type'        => 'checkbox'
		) 
	);

	// Search Result Sidebar Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_search_result_sidebar_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_search_result_sidebar_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Search Result Sidebar', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_sidebar_settings',
			'settings'    => 'expert_adventure_guide_search_result_sidebar_setting',
			'type'        => 'checkbox'
		) 
	);

	// Single Post Sidebar Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_single_post_sidebar_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_single_post_sidebar_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Single Post Sidebar', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_sidebar_settings',
			'settings'    => 'expert_adventure_guide_single_post_sidebar_setting',
			'type'        => 'checkbox'
		) 
	);

	// Sidebar Page Sidebar Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_single_page_sidebar_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_single_page_sidebar_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Page Width Sidebar', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_sidebar_settings',
			'settings'    => 'expert_adventure_guide_single_page_sidebar_setting',
			'type'        => 'checkbox'
		) 
	);

	$wp_customize->add_setting( 'expert_adventure_sidebar_position', array(
        'default'   => 'right',
        'sanitize_callback' => 'expert_adventure_guide_sanitize_sidebar_position',
    ));

    $wp_customize->add_control( 'expert_adventure_sidebar_position', array(
        'label'    => __( 'Sidebar Position', 'expert-adventure-guide' ),
        'section'  => 'expert_adventure_guide_sidebar_settings',
        'settings' => 'expert_adventure_sidebar_position',
        'type'     => 'radio',
        'choices'  => array(
            'right' => __( 'Right Sidebar', 'expert-adventure-guide' ),
            'left'  => __( 'Left Sidebar', 'expert-adventure-guide' ),
        ),
    ));

	 $wp_customize->add_setting( 'expert_adventure_guide_upgrade_page_settings_15',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Adventure_Guide_Control_Upgrade(
        $wp_customize, 'expert_adventure_guide_upgrade_page_settings_15',
            array(
                'priority'      => 200,
                'section'       => 'expert_adventure_guide_sidebar_settings',
                'settings'      => 'expert_adventure_guide_upgrade_page_settings_15',
                'label'         => __( 'Expert Adventure Guide Pro comes with additional features.', 'expert-adventure-guide' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-adventure-guide' ), __( 'One-Click Demo Import', 'expert-adventure-guide' ), __( 'WooCommerce Integrated', 'expert-adventure-guide' ), __( 'Drag & Drop Section Reordering', 'expert-adventure-guide' ),__( 'Advanced Typography Control', 'expert-adventure-guide' ),__( 'Intuitive Customization Options', 'expert-adventure-guide' ),__( '24/7 Support', 'expert-adventure-guide' ), )
            )
        )
    ); 
}

add_action( 'customize_register', 'expert_adventure_guide_sidebar_setting' );