<?php
function expert_adventure_guide_post_setting( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
		'expert_adventure_guide_post', array(
			'priority' => 31,
			'title' => esc_html__( 'Post Options', 'expert-adventure-guide' ),
		)
	);

	/*=========================================
	Archive Post  Section
	=========================================*/
	$wp_customize->add_section(
		'expert_adventure_guide_archive_post_setting', array(
			'title' => esc_html__( 'Archive Post', 'expert-adventure-guide' ),
			'priority' => 1,
			'panel' => 'expert_adventure_guide_post',
		)
	);

	// Layouts Post
	$wp_customize->add_setting('expert_adventure_guide_blog_layout_option_setting',array(
	  'default' => 'Default',
	  'sanitize_callback' => 'expert_adventure_guide_sanitize_choices'
	));
	$wp_customize->add_control(new Expert_Adventure_Guide_Image_Radio_Control($wp_customize, 'expert_adventure_guide_blog_layout_option_setting', array(
	  'type' => 'select',
	  'label' => __('Blog Post Layouts','expert-adventure-guide'),
	  'section' => 'expert_adventure_guide_archive_post_setting',
	  'choices' => array(
		'Default' => esc_url(get_template_directory_uri()).'/assets/images/layout-1.png',
		'Left' => esc_url(get_template_directory_uri()).'/assets/images/layout-2.png',
		'Right' => esc_url(get_template_directory_uri()).'/assets/images/layout-3.png',
	))));
		
	// Post Heading Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_post_heading_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
		'expert_adventure_guide_post_heading_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Heading', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_archive_post_setting',
			'settings'    => 'expert_adventure_guide_post_heading_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Content Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_post_content_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_post_content_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Content', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_archive_post_setting',
			'settings'    => 'expert_adventure_guide_post_content_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Featured Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_post_featured_image_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_post_featured_image_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Feature Image', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_archive_post_setting',
			'settings'    => 'expert_adventure_guide_post_featured_image_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_post_date_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_post_date_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Date', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_archive_post_setting',
			'settings'    => 'expert_adventure_guide_post_date_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_post_comments_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_post_comments_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Comment', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_archive_post_setting',
			'settings'    => 'expert_adventure_guide_post_comments_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_post_author_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_post_author_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Author', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_archive_post_setting',
			'settings'    => 'expert_adventure_guide_post_author_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Timing Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_post_timing_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_post_timing_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Timings', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_archive_post_setting',
			'settings'    => 'expert_adventure_guide_post_timing_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Tags Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_post_tags_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_post_tags_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Tags', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_archive_post_setting',
			'settings'    => 'expert_adventure_guide_post_tags_settings',
			'type'        => 'checkbox'
		) 
	);

	$wp_customize->add_setting('expert_adventure_guide_excerpt_limit', array(
        'default'           => 50,
        'sanitize_callback' => 'absint',
    ));

    $wp_customize->add_control('expert_adventure_guide_excerpt_limit', array(
        'label'   => __('Excerpt Word Limit', 'expert-adventure-guide'),
        'section' => 'expert_adventure_guide_archive_post_setting',
        'type'    => 'number',
    ));

	$wp_customize->add_setting( 'expert_adventure_guide_upgrade_page_settings_133',
	array(
		'sanitize_callback' => 'sanitize_text_field'
		)
	);
	$wp_customize->add_control( new Expert_Adventure_Guide_Control_Upgrade(
		$wp_customize, 'expert_adventure_guide_upgrade_page_settings_133',
			array(
				'priority'      => 200,
				'section'       => 'expert_adventure_guide_archive_post_setting',
				'settings'      => 'expert_adventure_guide_upgrade_page_settings_133',
				'label'         => __( 'Expert Adventure Guide Pro comes with additional features.', 'expert-adventure-guide' ),
				'choices'       => array( __( '15+ Ready-Made Sections', 'expert-adventure-guide' ), __( 'One-Click Demo Import', 'expert-adventure-guide' ), __( 'WooCommerce Integrated', 'expert-adventure-guide' ), __( 'Drag & Drop Section Reordering', 'expert-adventure-guide' ),__( 'Advanced Typography Control', 'expert-adventure-guide' ),__( 'Intuitive Customization Options', 'expert-adventure-guide' ),__( '24/7 Support', 'expert-adventure-guide' ), )
			)
		)
	); 

	/*=========================================
	Single Post  Section
	=========================================*/
	$wp_customize->add_section(
		'expert_adventure_guide_single_post', array(
			'title' => esc_html__( 'Single Post', 'expert-adventure-guide' ),
			'priority' => 3,
			'panel' => 'expert_adventure_guide_post',
		)
	);
	
	// Post Heading Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_single_post_heading_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_single_post_heading_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Heading', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_single_post',
			'settings'    => 'expert_adventure_guide_single_post_heading_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Content Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_single_post_content_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_single_post_content_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Content', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_single_post',
			'settings'    => 'expert_adventure_guide_single_post_content_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Featured Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_single_post_featured_image_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_single_post_featured_image_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Feature Image', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_single_post',
			'settings'    => 'expert_adventure_guide_single_post_featured_image_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_single_post_date_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_single_post_date_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Date', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_single_post',
			'settings'    => 'expert_adventure_guide_single_post_date_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_single_post_comments_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_single_post_comments_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Comment', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_single_post',
			'settings'    => 'expert_adventure_guide_single_post_comments_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_single_post_author_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_single_post_author_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Author', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_single_post',
			'settings'    => 'expert_adventure_guide_single_post_author_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_single_post_timing_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_single_post_timing_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Timings', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_single_post',
			'settings'    => 'expert_adventure_guide_single_post_timing_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Tags Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_single_post_tags_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_single_post_tags_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Tags', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_single_post',
			'settings'    => 'expert_adventure_guide_single_post_tags_settings',
			'type'        => 'checkbox'
		) 
	);
	
	// Related Posts Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_show_hide_related_post' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_show_hide_related_post', 
		array(
			'label'	      => esc_html__( 'Hide / Show Related Posts', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_single_post',
			'settings'    => 'expert_adventure_guide_show_hide_related_post',
			'type'        => 'checkbox'
		) 
	);

	$wp_customize->add_setting( 
    	'expert_adventure_guide_related_posts_heading',
    	array(
			'default' => 'Related Posts',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'expert_adventure_guide_related_posts_heading',
		array(
		    'label'   		=> __('Related Post Heading','expert-adventure-guide'),
		    'section'		=> 'expert_adventure_guide_single_post',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)
	);

	$wp_customize->add_setting('expert_adventure_guide_related_post_counts', array(
        'default'           => 3,
        'sanitize_callback' => 'absint',
    ));

    $wp_customize->add_control('expert_adventure_guide_related_post_counts', array(
        'label'   => __('Number Of Related Posts To Show', 'expert-adventure-guide'),
        'section' => 'expert_adventure_guide_single_post',
        'type'    => 'number',
    ));

	$wp_customize->add_setting( 'expert_adventure_guide_upgrade_page_settings_58',
	array(
		'sanitize_callback' => 'sanitize_text_field'
	)
	);
	$wp_customize->add_control( new Expert_Adventure_Guide_Control_Upgrade(
		$wp_customize, 'expert_adventure_guide_upgrade_page_settings_58',
			array(
				'priority'      => 200,
				'section'       => 'expert_adventure_guide_single_post',
				'settings'      => 'expert_adventure_guide_upgrade_page_settings_58',
				'label'         => __( 'Expert Adventure Guide Pro comes with additional features.', 'expert-adventure-guide' ),
				'choices'       => array( __( '15+ Ready-Made Sections', 'expert-adventure-guide' ), __( 'One-Click Demo Import', 'expert-adventure-guide' ), __( 'WooCommerce Integrated', 'expert-adventure-guide' ), __( 'Drag & Drop Section Reordering', 'expert-adventure-guide' ),__( 'Advanced Typography Control', 'expert-adventure-guide' ),__( 'Intuitive Customization Options', 'expert-adventure-guide' ),__( '24/7 Support', 'expert-adventure-guide' ), )
			)
		)
	); 
}

add_action( 'customize_register', 'expert_adventure_guide_post_setting' );