<?php
function expert_adventure_guide_header_settings( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';

    // Site Title Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_site_title_setting' , 
			array(
			'default' => '0',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_site_title_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Site Title', 'expert-adventure-guide' ),
			'section'     => 'title_tagline',
			'settings'    => 'expert_adventure_guide_site_title_setting',
			'type'        => 'checkbox'
		) 
	);

	// Tagline Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_tagline_setting' , 
			array(
			'default' => '',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_tagline_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Tagline', 'expert-adventure-guide' ),
			'section'     => 'title_tagline',
			'settings'    => 'expert_adventure_guide_tagline_setting',
			'type'        => 'checkbox'
		) 
	);

	// Add the setting for logo width
	$wp_customize->add_setting(
		'expert_adventure_guide_logo_width',
		array(
			'sanitize_callback' => 'expert_adventure_guide_sanitize_logo_width',
			'priority'          => 2,
		)
	);

	// Add control for logo width
	$wp_customize->add_control( 
		'expert_adventure_guide_logo_width',
		array(
			'label'     => __('Logo Width', 'expert-adventure-guide'),
			'section'   => 'title_tagline',
			'type'      => 'number',
			'input_attrs' => array(
				'min'   => 1,
				'max'   => 150,
				'step'  => 1,
			),
			'transport' => $selective_refresh,
		)  
	);

	$wp_customize->add_setting( 'expert_adventure_guide_upgrade_page_settings_10a',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Adventure_Guide_Control_Upgrade(
        $wp_customize, 'expert_adventure_guide_upgrade_page_settings_10a',
            array(
                'priority'      => 200,
                'section'       => 'title_tagline',
                'settings'      => 'expert_adventure_guide_upgrade_page_settings_10a',
                'label'         => __( 'Adventure Guide Pro comes with additional features.', 'expert-adventure-guide' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-adventure-guide' ), __( 'One-Click Demo Import', 'expert-adventure-guide' ), __( 'WooCommerce Integrated', 'expert-adventure-guide' ), __( 'Drag & Drop Section Reordering', 'expert-adventure-guide' ),__( 'Advanced Typography Control', 'expert-adventure-guide' ),__( 'Intuitive Customization Options', 'expert-adventure-guide' ),__( '24/7 Support', 'expert-adventure-guide' ), )
            )
        )
    ); 


	/*=========================================
	Expert Adventure Guide Site Identity
	=========================================*/
	$wp_customize->add_section(
        'title_tagline',
        array(
        	'priority'      => 1,
            'title' 		=> __('Site Identity','expert-adventure-guide'),
			'panel'  		=> 'expert_adventure_guide_frontpage_sections',
		)
    );    

	/*=========================================
	Top header
	=========================================*/
	$wp_customize->add_section(
        'top_header',
        array(
        	'priority'      => 2,
            'title' 		=> __('Header Section','expert-adventure-guide'),
			'panel'  		=> 'expert_adventure_guide_frontpage_sections',
		)
    );

	// general setting

   	$wp_customize->add_setting(
    	'expert_adventure_guide_topheader_address',
    	array(
			'default' => '777 FRANKLIN ST, SAN FRANCISCO',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);	
	$wp_customize->add_control( 
		'expert_adventure_guide_topheader_address',
		array(
		    'label'   		=> __('Location','expert-adventure-guide'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

   	$wp_customize->add_setting(
    	'expert_adventure_guide_topheader_timing',
    	array(
			'default' => '10.00AM - 06.00PM MONDAY TO FRIDAY',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);	
	$wp_customize->add_control( 
		'expert_adventure_guide_topheader_timing',
		array(
		    'label'   		=> __('Timing','expert-adventure-guide'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	$wp_customize->add_setting(
    	'expert_adventure_guide_topheader_email_text',
    	array(
			'default' => 'DROP US A EMAIL:.',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);	
	$wp_customize->add_control( 
		'expert_adventure_guide_topheader_email_text',
		array(
		    'label'   		=> __('Email Text','expert-adventure-guide'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	$wp_customize->add_setting(
    	'expert_adventure_guide_topheader_email_address',
    	array(
			'default' => 'compayname@example.com',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);	
	$wp_customize->add_control( 
		'expert_adventure_guide_topheader_email_address',
		array(
		    'label'   		=> __('Email Address','expert-adventure-guide'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);


	$wp_customize->add_setting(
    	'expert_adventure_guide_topheader_phone_text',
    	array(
			'default' => 'ANY QUESTIONS? CALL US:',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);	
	$wp_customize->add_control( 
		'expert_adventure_guide_topheader_phone_text',
		array(
		    'label'   		=> __('Phone Text','expert-adventure-guide'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	$wp_customize->add_setting(
    	'expert_adventure_guide_topheader_phone_number',
    	array(
			'default' => '+91 123-456-780/+00 987-654-321',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);	
	$wp_customize->add_control( 
		'expert_adventure_guide_topheader_phone_number',
		array(
		    'label'   		=> __('Phone Number','expert-adventure-guide'),
		    'section'		=> 'top_header',
			'type' 			=> 'number',
			'transport'         => $selective_refresh,
		)  
	);

$wp_customize->add_setting( 'expert_adventure_guide_upgrade_page_settings_11',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Adventure_Guide_Control_Upgrade(
        $wp_customize, 'expert_adventure_guide_upgrade_page_settings_11',
            array(
                'priority'      => 200,
                'section'       => 'top_header',
                'settings'      => 'expert_adventure_guide_upgrade_page_settings_11',
                'label'         => __( 'Adventure Guide Pro comes with additional features.', 'expert-adventure-guide' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-adventure-guide' ), __( 'One-Click Demo Import', 'expert-adventure-guide' ), __( 'WooCommerce Integrated', 'expert-adventure-guide' ), __( 'Drag & Drop Section Reordering', 'expert-adventure-guide' ),__( 'Advanced Typography Control', 'expert-adventure-guide' ),__( 'Intuitive Customization Options', 'expert-adventure-guide' ),__( '24/7 Support', 'expert-adventure-guide' ), )
            )
        )
    ); 



	/*=========================================
	Social Media
	=========================================*/
	$wp_customize->add_section(
        'social_media_url',
        array(
            'title' 		=> __('Social Media','expert-adventure-guide'),
			'panel'  		=> 'expert_adventure_guide_frontpage_sections',
		)
    );

	$wp_customize->add_setting(
    	'expert_adventure_guide_topheader_pintrest',
    	array(
			'default' => '#',
			'sanitize_callback' => 'esc_url_raw',
		)
	);	
	$wp_customize->add_control( 
		'expert_adventure_guide_topheader_pintrest',
		array(
		    'label'   		=> __('Pintrest url','expert-adventure-guide'),
		    'section'		=> 'social_media_url',
			'type' 			=> 'url',
			'transport'         => $selective_refresh,
		)  
	);

	$wp_customize->add_setting(
    	'expert_adventure_guide_topheader_facebook',
    	array(
			'default' => '#',
			'sanitize_callback' => 'esc_url_raw',
		)
	);	
	$wp_customize->add_control( 
		'expert_adventure_guide_topheader_facebook',
		array(
		    'label'   		=> __('Facebook url','expert-adventure-guide'),
		    'section'		=> 'social_media_url',
			'type' 			=> 'url',
			'transport'         => $selective_refresh,
		)
	);

	$wp_customize->add_setting(
    	'expert_adventure_guide_topheader_twitter',
    	array(
			'default' => '#',
			'sanitize_callback' => 'esc_url_raw',
		)
	);	
	$wp_customize->add_control( 
		'expert_adventure_guide_topheader_twitter',
		array(
		    'label'   		=> __('Twitter url','expert-adventure-guide'),
		    'section'		=> 'social_media_url',
			'type' 			=> 'url',
			'transport'         => $selective_refresh,
		)
	);

	$wp_customize->add_setting(
    	'expert_adventure_guide_topheader_linkdin',
    	array(
			'default' => '#',
			'sanitize_callback' => 'esc_url_raw',
		)
	);	
	$wp_customize->add_control( 
		'expert_adventure_guide_topheader_linkdin',
		array(
		    'label'   		=> __('Linkdin url','expert-adventure-guide'),
		    'section'		=> 'social_media_url',
			'type' 			=> 'url',
			'transport'         => $selective_refresh,
		)
	);

	$wp_customize->add_setting( 'expert_adventure_guide_upgrade_page_settings_12',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Adventure_Guide_Control_Upgrade(
        $wp_customize, 'expert_adventure_guide_upgrade_page_settings_12',
            array(
                'priority'      => 200,
                'section'       => 'social_media_url',
                'settings'      => 'expert_adventure_guide_upgrade_page_settings_12',
                'label'         => __( 'Adventure Guide Pro comes with additional features.', 'expert-adventure-guide' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-adventure-guide' ), __( 'One-Click Demo Import', 'expert-adventure-guide' ), __( 'WooCommerce Integrated', 'expert-adventure-guide' ), __( 'Drag & Drop Section Reordering', 'expert-adventure-guide' ),__( 'Advanced Typography Control', 'expert-adventure-guide' ),__( 'Intuitive Customization Options', 'expert-adventure-guide' ),__( '24/7 Support', 'expert-adventure-guide' ), )
            )
        )
    ); 

	$wp_customize->register_panel_type( 'expert_adventure_guide_WP_Customize_Panel' );
	$wp_customize->register_section_type( 'expert_adventure_guide_WP_Customize_Section' );

}
add_action( 'customize_register', 'expert_adventure_guide_header_settings' );


if ( class_exists( 'WP_Customize_Panel' ) ) {
  	class expert_adventure_guide_WP_Customize_Panel extends WP_Customize_Panel {
	   public $panel;
	   public $type = 'expert_adventure_guide_panel';
	   public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'type', 'panel', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;
	      return $array;
    	}
  	}
}

if ( class_exists( 'WP_Customize_Section' ) ) {
  	class expert_adventure_guide_WP_Customize_Section extends WP_Customize_Section {
	   public $section;
	   public $type = 'expert_adventure_guide_section';
	   public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'panel', 'type', 'description_hidden', 'section', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;

	      if ( $this->panel ) {
	        $array['customizeAction'] = sprintf( 'Customizing &#9656; %s', esc_html( $this->manager->get_panel( $this->panel )->title ) );
	      } else {
	        $array['customizeAction'] = 'Customizing';
	      }
	      return $array;
    	}
  	}
}