<?php
function expert_adventure_guide_general_setting( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
		'expert_adventure_guide_general', array(
			'priority' => 2,
			'title' => esc_html__( 'General Options', 'expert-adventure-guide' ),
		)
	);

	/*=========================================
	Breadcrumb  Section
	=========================================*/
	$wp_customize->add_section(
		'expert_adventure_guide_breadcrumb_setting', array(
			'title' => esc_html__( 'Breadcrumb Options', 'expert-adventure-guide' ),
			'priority' => 1,
			'panel' => 'expert_adventure_guide_general',
		)
	);
	
	// Settings 
	$wp_customize->add_setting(
		'expert_adventure_guide_breadcrumb_settings'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_text',
			'priority' => 1,
		)
	);

	$wp_customize->add_control(
	'expert_adventure_guide_breadcrumb_settings',
		array(
			'type' => 'hidden',
			'label' => __('Settings','expert-adventure-guide'),
			'section' => 'expert_adventure_guide_breadcrumb_setting',
		)
	);
	
	// Breadcrumb Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_hs_breadcrumb' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_hs_breadcrumb', 
		array(
			'label'	      => esc_html__( 'Hide / Show Section', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_breadcrumb_setting',
			'settings'    => 'expert_adventure_guide_hs_breadcrumb',
			'type'        => 'checkbox'
		) 
	);

	$wp_customize->add_setting(
    	'expert_adventure_guide_breadcrumb_seprator',
    	array(
			'default' => '/',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'expert_adventure_guide_breadcrumb_seprator',
		array(
		    'label'   		=> __('Breadcrumb separator','expert-adventure-guide'),
		    'section'		=> 'expert_adventure_guide_breadcrumb_setting',
			'type' 			=> 'text',
		)  
	);

	$wp_customize->add_setting( 'expert_adventure_guide_upgrade_page_settings_5',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Adventure_Guide_Control_Upgrade(
        $wp_customize, 'expert_adventure_guide_upgrade_page_settings_5',
            array(
                'priority'      => 200,
                'section'       => 'expert_adventure_guide_breadcrumb_setting',
                'settings'      => 'expert_adventure_guide_upgrade_page_settings_5',
                'label'         => __( 'Expert Adventure Guide Pro comes with additional features.', 'expert-adventure-guide' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-adventure-guide' ), __( 'One-Click Demo Import', 'expert-adventure-guide' ), __( 'WooCommerce Integrated', 'expert-adventure-guide' ), __( 'Drag & Drop Section Reordering', 'expert-adventure-guide' ),__( 'Advanced Typography Control', 'expert-adventure-guide' ),__( 'Intuitive Customization Options', 'expert-adventure-guide' ),__( '24/7 Support', 'expert-adventure-guide' ), )
            )
        )
    ); 

	/*=========================================
	Preloader Section
	=========================================*/
	$wp_customize->add_section(
		'expert_adventure_guide_preloader_section_setting', array(
			'title' => esc_html__( 'Preloader Options', 'expert-adventure-guide' ),
			'priority' => 3,
			'panel' => 'expert_adventure_guide_general',
		)
	);

	// Preloader Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_preloader_setting' , 
			array(
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_preloader_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Preloader', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_preloader_section_setting',
			'settings'    => 'expert_adventure_guide_preloader_setting',
			'type'        => 'checkbox'
		) 
	);

	
	$wp_customize->add_setting(
    	'expert_adventure_guide_preloader_text',
    	array(
			'default' => 'Loading',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'expert_adventure_guide_preloader_text',
		array(
		    'label'   		=> __('Preloader Text','expert-adventure-guide'),
		    'section'		=> 'expert_adventure_guide_preloader_section_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)
	);

	// Preloader Background Color Setting
	$wp_customize->add_setting(
		'expert_adventure_guide_preloader_bg_color',
		array(
			'default' => '#ffffff',
			'sanitize_callback' => 'sanitize_hex_color',
			'capability' => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'expert_adventure_guide_preloader_bg_color',
			array(
				'label' => esc_html__('Preloader Background Color', 'expert-adventure-guide'),
				'section' => 'expert_adventure_guide_preloader_section_setting', // Adjust section if needed
				'settings' => 'expert_adventure_guide_preloader_bg_color',
			)
		)
	);

	// Preloader Color Setting
	$wp_customize->add_setting(
		'expert_adventure_guide_preloader_color',
		array(
			'default' => '#d4635e',
			'sanitize_callback' => 'sanitize_hex_color',
			'capability' => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'expert_adventure_guide_preloader_color',
			array(
				'label' => esc_html__('Preloader Color', 'expert-adventure-guide'),
				'section' => 'expert_adventure_guide_preloader_section_setting', // Adjust section if needed
				'settings' => 'expert_adventure_guide_preloader_color',
			)
		)
	);

	$wp_customize->add_setting( 'expert_adventure_guide_upgrade_page_settings_6',
		array(
			'sanitize_callback' => 'sanitize_text_field'
		)
	);
	$wp_customize->add_control( new Expert_Adventure_Guide_Control_Upgrade(
		$wp_customize, 'expert_adventure_guide_upgrade_page_settings_6',
			array(
				'priority'      => 200,
				'section'       => 'expert_adventure_guide_preloader_section_setting',
				'settings'      => 'expert_adventure_guide_upgrade_page_settings_6',
				'label'         => __( 'Expert Adventure Guide Pro comes with additional features.', 'expert-adventure-guide' ),
				'choices'       => array( __( '15+ Ready-Made Sections', 'expert-adventure-guide' ), __( 'One-Click Demo Import', 'expert-adventure-guide' ), __( 'WooCommerce Integrated', 'expert-adventure-guide' ), __( 'Drag & Drop Section Reordering', 'expert-adventure-guide' ),__( 'Advanced Typography Control', 'expert-adventure-guide' ),__( 'Intuitive Customization Options', 'expert-adventure-guide' ),__( '24/7 Support', 'expert-adventure-guide' ), )
			)
		)
	); 


	/*=========================================
	Scroll To Top Section
	=========================================*/
	$wp_customize->add_section(
		'expert_adventure_guide_scroll_to_top_section_setting', array(
			'title' => esc_html__( 'Scroll To Top Options', 'expert-adventure-guide' ),
			'priority' => 3,
			'panel' => 'expert_adventure_guide_footer_section',
		)
	);

	// Scroll To Top Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_scroll_top_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_scroll_top_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Scroll To Top', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_scroll_to_top_section_setting',
			'settings'    => 'expert_adventure_guide_scroll_top_setting',
			'type'        => 'checkbox'
		) 
	);

	// Scroll To Top Color Setting
	$wp_customize->add_setting(
		'expert_adventure_guide_scroll_top_color',
		array(
			'default'           => '#fff',
			'sanitize_callback' => 'sanitize_hex_color',
			'capability'        => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'expert_adventure_guide_scroll_top_color',
			array(
				'label'    => esc_html__( 'Scroll To Top Color', 'expert-adventure-guide' ),
				'section'  => 'expert_adventure_guide_scroll_to_top_section_setting',
				'settings' => 'expert_adventure_guide_scroll_top_color',
			)
		)
	);

	// Scroll To Top Background Color Setting
	$wp_customize->add_setting(
		'expert_adventure_guide_scroll_top_bg_color',
		array(
			'default'           => '#d4635e',
			'sanitize_callback' => 'sanitize_hex_color',
			'capability'        => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'expert_adventure_guide_scroll_top_bg_color',
			array(
				'label'    => esc_html__( 'Scroll To Top Background Color', 'expert-adventure-guide' ),
				'section'  => 'expert_adventure_guide_scroll_to_top_section_setting',
				'settings' => 'expert_adventure_guide_scroll_top_bg_color',
			)
		)
	);

	 $wp_customize->add_setting( 'expert_adventure_guide_upgrade_page_settings_7',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Adventure_Guide_Control_Upgrade(
        $wp_customize, 'expert_adventure_guide_upgrade_page_settings_7',
            array(
                'priority'      => 200,
                'section'       => 'expert_adventure_guide_scroll_to_top_section_setting',
                'settings'      => 'expert_adventure_guide_upgrade_page_settings_7',
                'label'         => __( 'Expert Adventure Guide Pro comes with additional features.', 'expert-adventure-guide' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-adventure-guide' ), __( 'One-Click Demo Import', 'expert-adventure-guide' ), __( 'WooCommerce Integrated', 'expert-adventure-guide' ), __( 'Drag & Drop Section Reordering', 'expert-adventure-guide' ),__( 'Advanced Typography Control', 'expert-adventure-guide' ),__( 'Intuitive Customization Options', 'expert-adventure-guide' ),__( '24/7 Support', 'expert-adventure-guide' ), )
            )
        )
    ); 


	/*=========================================
	Woocommerce Section
	=========================================*/
	$wp_customize->add_section(
		'expert_adventure_guide_woocommerce_section_setting', array(
			'title' => esc_html__( 'Woocommerce Settings', 'expert-adventure-guide' ),
			'priority' => 3,
			'panel' => 'woocommerce',
		)
	);

	$wp_customize->add_setting(
    	'expert_adventure_guide_custom_shop_per_columns',
    	array(
			'default' => '3',
			'sanitize_callback' => 'absint',
		)
	);	
	$wp_customize->add_control( 
		'expert_adventure_guide_custom_shop_per_columns',
		array(
		    'label'   		=> __('Product Per Columns','expert-adventure-guide'),
		    'section'		=> 'expert_adventure_guide_woocommerce_section_setting',
			'type' 			=> 'number',
			'transport'         => $selective_refresh,
		)  
	);

	$wp_customize->add_setting(
    	'expert_adventure_guide_custom_shop_product_per_page',
    	array(
			'default' => '9',
			'sanitize_callback' => 'absint',
		)
	);	
	$wp_customize->add_control( 
		'expert_adventure_guide_custom_shop_product_per_page',
		array(
		    'label'   		=> __('Product Per Page','expert-adventure-guide'),
		    'section'		=> 'expert_adventure_guide_woocommerce_section_setting',
			'type' 			=> 'number',
			'transport'         => $selective_refresh,
		)  
	);

	// Woocommerce Sidebar Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_wocommerce_sidebar_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_wocommerce_sidebar_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Woocommerce Sidebar', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_woocommerce_section_setting',
			'settings'    => 'expert_adventure_guide_wocommerce_sidebar_setting',
			'type'        => 'checkbox'
		)
	);

	$wp_customize->add_setting( 'expert_adventure_guide_upgrade_page_settings_22',
	array(
		'sanitize_callback' => 'sanitize_text_field'
		)
	);
	$wp_customize->add_control( new Expert_Adventure_Guide_Control_Upgrade(
		$wp_customize, 'expert_adventure_guide_upgrade_page_settings_22',
			array(
				'priority'      => 200,
				'section'       => 'expert_adventure_guide_woocommerce_section_setting',
				'settings'      => 'expert_adventure_guide_upgrade_page_settings_22',
				'label'         => __( 'Expert Adventure Guide Pro comes with additional features.', 'expert-adventure-guide' ),
				'choices'       => array( __( '15+ Ready-Made Sections', 'expert-adventure-guide' ), __( 'One-Click Demo Import', 'expert-adventure-guide' ), __( 'WooCommerce Integrated', 'expert-adventure-guide' ), __( 'Drag & Drop Section Reordering', 'expert-adventure-guide' ),__( 'Advanced Typography Control', 'expert-adventure-guide' ),__( 'Intuitive Customization Options', 'expert-adventure-guide' ),__( '24/7 Support', 'expert-adventure-guide' ), )
			)
		)
	); 

	/*=========================================
	Sticky Header Section
	=========================================*/
	$wp_customize->add_section(
		'sticky_header_section_setting', array(
			'title' => esc_html__( 'Sticky Header Options', 'expert-adventure-guide' ),
			'priority' => 3,
			'panel' => 'expert_adventure_guide_general',
		)
	);

	// Sticky Header Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_sticky_header' , 
			array(
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_sticky_header', 
		array(
			'label'	      => esc_html__( 'Hide / Show Sticky Header', 'expert-adventure-guide' ),
			'section'     => 'sticky_header_section_setting',
			'settings'    => 'expert_adventure_guide_sticky_header',
			'type'        => 'checkbox'
		) 
	);

	 $wp_customize->add_setting( 'expert_adventure_guide_upgrade_page_settings_9',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Adventure_Guide_Control_Upgrade(
        $wp_customize, 'expert_adventure_guide_upgrade_page_settings_9',
            array(
                'priority'      => 200,
                'section'       => 'sticky_header_section_setting',
                'settings'      => 'expert_adventure_guide_upgrade_page_settings_9',
                'label'         => __( 'Expert Adventure Guide Pro comes with additional features.', 'expert-adventure-guide' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-adventure-guide' ), __( 'One-Click Demo Import', 'expert-adventure-guide' ), __( 'WooCommerce Integrated', 'expert-adventure-guide' ), __( 'Drag & Drop Section Reordering', 'expert-adventure-guide' ),__( 'Advanced Typography Control', 'expert-adventure-guide' ),__( 'Intuitive Customization Options', 'expert-adventure-guide' ),__( '24/7 Support', 'expert-adventure-guide' ), )
            )
        )
    ); 

	/*=========================================
	404 Page Options
	=========================================*/
	$wp_customize->add_section(
		'expert_adventure_guide_404_section', array(
			'title' => esc_html__( '404 Page Options', 'expert-adventure-guide' ),
			'priority' => 1,
			'panel' => 'expert_adventure_guide_general',
		)
	);

	$wp_customize->add_setting(
    	'expert_adventure_guide_404_title',
    	array(
			'default' => '404',
			'sanitize_callback' => 'sanitize_text_field',
			'priority' => 2,
		)
	);	
	$wp_customize->add_control( 
		'expert_adventure_guide_404_title',
		array(
		    'label'   		=> __('404 Heading','expert-adventure-guide'),
		    'section'		=> 'expert_adventure_guide_404_section',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	$wp_customize->add_setting(
    	'expert_adventure_guide_404_Text',
    	array(
			'default' => 'Page Not Found',
			'sanitize_callback' => 'sanitize_text_field',
			'priority' => 2,
		)
	);	
	$wp_customize->add_control( 
		'expert_adventure_guide_404_Text',
		array(
		    'label'   		=> __('404 Title','expert-adventure-guide'),
		    'section'		=> 'expert_adventure_guide_404_section',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	$wp_customize->add_setting(
    	'expert_adventure_guide_404_content',
    	array(
			'default' => 'The page you were looking for could not be found.',
			'sanitize_callback' => 'sanitize_text_field',
			'priority' => 2,
		)
	);	
	$wp_customize->add_control( 
		'expert_adventure_guide_404_content',
		array(
		    'label'   		=> __('404 Content','expert-adventure-guide'),
		    'section'		=> 'expert_adventure_guide_404_section',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	 $wp_customize->add_setting( 'expert_adventure_guide_upgrade_page_settings_10',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Adventure_Guide_Control_Upgrade(
        $wp_customize, 'expert_adventure_guide_upgrade_page_settings_10',
            array(
                'priority'      => 200,
                'section'       => 'expert_adventure_guide_404_section',
                'settings'      => 'expert_adventure_guide_upgrade_page_settings_10',
                'label'         => __( 'Expert Adventure Guide Pro comes with additional features.', 'expert-adventure-guide' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-adventure-guide' ), __( 'One-Click Demo Import', 'expert-adventure-guide' ), __( 'WooCommerce Integrated', 'expert-adventure-guide' ), __( 'Drag & Drop Section Reordering', 'expert-adventure-guide' ),__( 'Advanced Typography Control', 'expert-adventure-guide' ),__( 'Intuitive Customization Options', 'expert-adventure-guide' ),__( '24/7 Support', 'expert-adventure-guide' ), )
            )
        )
    ); 

	/*=========================================
	Animation Section
	=========================================*/
	$wp_customize->add_section(
		'expert_adventure_guide_animations_section_setting', array(
			'title' => esc_html__( 'Animation Options', 'expert-adventure-guide' ),
			'priority' => 3,
			'panel' => 'expert_adventure_guide_general',
		)
	);

	// Animations Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_animation_enabled' , 
			array(
			'default' => true,
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_animation_enabled', 
		array(
			'label'	      => esc_html__( 'Hide / Show Animations', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_animations_section_setting',
			'settings'    => 'expert_adventure_guide_animation_enabled',
			'type'        => 'checkbox'
		) 
	);

	$wp_customize->add_setting( 'expert_adventure_guide_upgrade_page_settings_956',
		array(
			'sanitize_callback' => 'sanitize_text_field'
		)
	);
	$wp_customize->add_control( new Expert_Adventure_Guide_Control_Upgrade(
		$wp_customize, 'expert_adventure_guide_upgrade_page_settings_956',
			array(
				'priority'      => 200,
				'section'       => 'expert_adventure_guide_animations_section_setting',
				'settings'      => 'expert_adventure_guide_upgrade_page_settings_956',
				'label'         => __( 'Expert Adventure Guide Pro comes with additional features.', 'expert-adventure-guide' ),
				'choices'       => array( __( '15+ Ready-Made Sections', 'expert-adventure-guide' ), __( 'One-Click Demo Import', 'expert-adventure-guide' ), __( 'WooCommerce Integrated', 'expert-adventure-guide' ), __( 'Drag & Drop Section Reordering', 'expert-adventure-guide' ),__( 'Advanced Typography Control', 'expert-adventure-guide' ),__( 'Intuitive Customization Options', 'expert-adventure-guide' ),__( '24/7 Support', 'expert-adventure-guide' ), )
			)
		)
	); 

}

add_action( 'customize_register', 'expert_adventure_guide_general_setting' );