<?php
function expert_adventure_guide_blog_setting( $wp_customize ) {

$wp_customize->register_control_type( 'Expert_Adventure_Guide_Control_Upgrade' );

$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
			'expert_adventure_guide_frontpage_sections', array(
				'priority' => 1,
				'title' => esc_html__( 'Frontpage Sections', 'expert-adventure-guide' ),
			)
		);
	
	/*=========================================
	Slider Section
	=========================================*/
	$wp_customize->add_section(
		'expert_adventure_guide_slider_setting', array(
			'title' => esc_html__( 'Slider Section', 'expert-adventure-guide' ),
			'priority' => 13,
			'panel' => 'expert_adventure_guide_frontpage_sections',
		)
	);

	// Slider Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_slider_enable_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_slider_enable_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Section', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_slider_setting',
			'settings'    => 'expert_adventure_guide_slider_enable_setting',
			'type'        => 'checkbox'
		) 
	);

	// Slider Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_slider_button_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_slider_button_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Button', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_slider_setting',
			'settings'    => 'expert_adventure_guide_slider_button_setting',
			'type'        => 'checkbox'
		) 
	);

	// Slider Text
	$wp_customize->add_setting( 
    	'expert_adventure_guide_slider_text',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'expert_adventure_guide_slider_text',
		array(
		    'label'   		=> __('Slider Text','expert-adventure-guide'),
		    'section'		=> 'expert_adventure_guide_slider_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)
	);
	
	// Slider 1
	$wp_customize->add_setting( 
    	'expert_adventure_guide_slider1',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);

	$wp_customize->add_control( 
		'expert_adventure_guide_slider1',
		array(
		    'label'   		=> __('Slider 1','expert-adventure-guide'),
		    'section'		=> 'expert_adventure_guide_slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);		

	// Slider 2
	$wp_customize->add_setting(
    	'expert_adventure_guide_slider2',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 2,
		)
	);	

	$wp_customize->add_control( 
		'expert_adventure_guide_slider2',
		array(
		    'label'   		=> __('Slider 2','expert-adventure-guide'),
		    'section'		=> 'expert_adventure_guide_slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// Slider 3
	$wp_customize->add_setting(
    	'expert_adventure_guide_slider3',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'expert_adventure_guide_slider3',
		array(
		    'label'   		=> __('Slider 3','expert-adventure-guide'),
		    'section'		=> 'expert_adventure_guide_slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	$wp_customize->add_setting('expert_adventure_guide_button_text2',array(
		'default' => 'DISCOVER MORE',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'expert_adventure_guide_button_text2', array(
	   'settings' => 'expert_adventure_guide_button_text2',
	   'section'   => 'expert_adventure_guide_slider_setting',
	   'label' => __('Add Button Text', 'expert-adventure-guide'),
	   'type'      => 'text'
	));

	$wp_customize->add_setting('expert_adventure_guide_button_link_slider2',array(
        'default'=> '',
        'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control('expert_adventure_guide_button_link_slider2',array(
        'label' => esc_html__('Add Button Link url','expert-adventure-guide'),
        'section'=> 'expert_adventure_guide_slider_setting',
        'type'=> 'url'
    ));

    $wp_customize->add_setting( 'expert_adventure_guide_upgrade_page_settings_3',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Adventure_Guide_Control_Upgrade(
        $wp_customize, 'expert_adventure_guide_upgrade_page_settings_3',
            array(
                'priority'      => 200,
                'section'       => 'expert_adventure_guide_slider_setting',
                'settings'      => 'expert_adventure_guide_upgrade_page_settings_3',
                'label'         => __( 'Adventure Guide Pro comes with additional features.', 'expert-adventure-guide' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-adventure-guide' ), __( 'One-Click Demo Import', 'expert-adventure-guide' ), __( 'WooCommerce Integrated', 'expert-adventure-guide' ), __( 'Drag & Drop Section Reordering', 'expert-adventure-guide' ),__( 'Advanced Typography Control', 'expert-adventure-guide' ),__( 'Intuitive Customization Options', 'expert-adventure-guide' ),__( '24/7 Support', 'expert-adventure-guide' ), )
            )
        )
    ); 

	/*=========================================
	Adventure Sports Section
	=========================================*/

	$wp_customize->add_section( 
		'expert_adventure_guide_trip_offer_section' , 
		array(
	        'title'      => __( 'Latest Offer Settings', 'expert-adventure-guide' ),
	        'panel' => 'expert_adventure_guide_frontpage_sections',
    	) 
    );

    // Adventure Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_tours_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_tours_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Section', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_trip_offer_section',
			'settings'    => 'expert_adventure_guide_tours_setting',
			'type'        => 'checkbox'
		) 
	);

	// Adventure Button Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_tours_button_setting', 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_tours_button_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Button', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_trip_offer_section',
			'settings'    => 'expert_adventure_guide_tours_button_setting',
			'type'        => 'checkbox'
		) 
	);

    $wp_customize->add_setting(
    	'expert_adventure_guide_offer_section_short_title',
    	array(
	        'default'   => '',
	        'sanitize_callback' => 'sanitize_text_field'
    	)
    );
    $wp_customize->add_control(
    	'expert_adventure_guide_offer_section_short_title',
    	array(
	        'label' => __('Short Title','expert-adventure-guide'),
	        'section'   => 'expert_adventure_guide_trip_offer_section',
	        'type'      => 'text'
    	)
    );

    $wp_customize->selective_refresh->add_partial( 
    	'expert_adventure_guide_offer_section_short_title', 
    	array(
	        'selector' => '#travel-offer h2',
	        'render_callback' => 'expert_adventure_guide_customize_partial_expert_adventure_guide_offer_section_short_title',
    	) 
    );
    $wp_customize->add_setting(
    	'expert_adventure_guide_offer_section_tittle',
    	array(
	        'default'   => '',
	        'sanitize_callback' => 'sanitize_text_field'
    	)
    );

    $wp_customize->add_control(
    	'expert_adventure_guide_offer_section_tittle',
    	array(
	        'label' => __('Section Title','expert-adventure-guide'),
	        'section'   => 'expert_adventure_guide_trip_offer_section',
	        'type'      => 'text'
    	)
    );

    $wp_customize->add_setting(
    	'expert_adventure_guide_offer_section_text',
    	array(
	        'default'   => '',
	        'sanitize_callback' => 'sanitize_text_field'
    	)
    );
    $wp_customize->add_control(
    	'expert_adventure_guide_offer_section_text',
    	array(
	        'label' => __('Section Description','expert-adventure-guide'),
	        'section'   => 'expert_adventure_guide_trip_offer_section',
	        'type'      => 'text'
    	)
    );

    $wp_customize->add_setting(
    	'expert_adventure_guide_btn_text',
    	array(
			'default' => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);	
	$wp_customize->add_control( 
		'expert_adventure_guide_btn_text',
		array(
		    'label'   		=> __('Btn Text','expert-adventure-guide'),
		    'section'		=> 'expert_adventure_guide_trip_offer_section',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)
	);

	$wp_customize->add_setting(
    	'expert_adventure_guide_btn_link',
    	array(
			'default' => '',
			'sanitize_callback' => 'esc_url_raw',
		)
	);	
	$wp_customize->add_control( 
		'expert_adventure_guide_btn_link',
		array(
		    'label'   		=> __('Btn Url','expert-adventure-guide'),
		    'section'		=> 'expert_adventure_guide_trip_offer_section',
			'type' 			=> 'url',
			'transport'         => $selective_refresh,
		)
	);

    $expert_adventure_guide_categories = get_categories();
    $expert_adventure_guide_cats = array();
    $expert_adventure_guide_i = 0;
    $expert_adventure_guide_offer_cat[]= 'select';
    foreach($expert_adventure_guide_categories as $expert_adventure_guide_category){
        if($expert_adventure_guide_i==0){
            $expert_adventure_guide_default = $expert_adventure_guide_category->slug;
            $expert_adventure_guide_i++;
        }
        $expert_adventure_guide_offer_cat[$expert_adventure_guide_category->slug] = $expert_adventure_guide_category->name;
    }

    $wp_customize->add_setting(
    	'expert_adventure_guide_offer_section_category',
    	array(
	        'default'   => 'uncategorized',
	        'sanitize_callback' => 'expert_adventure_guide_sanitize_choices',
    	)
    );
    $wp_customize->add_control(
    	'expert_adventure_guide_offer_section_category',
    	array(
	        'type'    => 'select',
	        'choices' => $expert_adventure_guide_offer_cat,
	        'label' => __('Select Category','expert-adventure-guide'),
	        'section' => 'expert_adventure_guide_trip_offer_section',
    	)
    );

    $wp_customize->add_setting( 'expert_adventure_guide_upgrade_page_settings_4',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Adventure_Guide_Control_Upgrade(
        $wp_customize, 'expert_adventure_guide_upgrade_page_settings_4',
            array(
                'priority'      => 200,
                'section'       => 'expert_adventure_guide_trip_offer_section',
                'settings'      => 'expert_adventure_guide_upgrade_page_settings_4',
                'label'         => __( 'Adventure Guide Pro comes with additional features.', 'expert-adventure-guide' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-adventure-guide' ), __( 'One-Click Demo Import', 'expert-adventure-guide' ), __( 'WooCommerce Integrated', 'expert-adventure-guide' ), __( 'Drag & Drop Section Reordering', 'expert-adventure-guide' ),__( 'Advanced Typography Control', 'expert-adventure-guide' ),__( 'Intuitive Customization Options', 'expert-adventure-guide' ),__( '24/7 Support', 'expert-adventure-guide' ), )
            )
        )
    ); 
}

add_action( 'customize_register', 'expert_adventure_guide_blog_setting' );

// service selective refresh
function expert_adventure_guide_blog_section_partials( $wp_customize ){	
	// blog_title
	$wp_customize->selective_refresh->add_partial( 'blog_title', array(
		'selector'            => '.home-blog .title h6',
		'settings'            => 'blog_title',
		'render_callback'  => 'expert_adventure_guide_blog_title_render_callback',
	
	) );
	
	// blog_subtitle
	$wp_customize->selective_refresh->add_partial( 'blog_subtitle', array(
		'selector'            => '.home-blog .title h2',
		'settings'            => 'blog_subtitle',
		'render_callback'  => 'expert_adventure_guide_blog_subtitle_render_callback',
	
	) );
	
	// blog_description
	$wp_customize->selective_refresh->add_partial( 'blog_description', array(
		'selector'            => '.home-blog .title p',
		'settings'            => 'blog_description',
		'render_callback'  => 'expert_adventure_guide_blog_description_render_callback',
	
	) );	
	}

add_action( 'customize_register', 'expert_adventure_guide_blog_section_partials' );

// blog_title
function expert_adventure_guide_blog_title_render_callback() {
	return get_theme_mod( 'blog_title' );
}

// blog_subtitle
function expert_adventure_guide_blog_subtitle_render_callback() {
	return get_theme_mod( 'blog_subtitle' );
}

// service description
function expert_adventure_guide_blog_description_render_callback() {
	return get_theme_mod( 'blog_description' );
}