<?php

function expert_adventure_guide_footer( $wp_customize ) {
	$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	// Footer Panel // 
	$wp_customize->add_panel( 
		'expert_adventure_guide_footer_section', 
		array(
			'priority'      => 34,
			'capability'    => 'edit_theme_options',
			'title'			=> __('Footer Options', 'expert-adventure-guide'),
		) 
	);

	// Footer Widgets // 
	$wp_customize->add_section(
        'expert_adventure_guide_footer_top',
        array(
            'title' 		=> __('Footer Widgets','expert-adventure-guide'),
			'panel'  		=> 'expert_adventure_guide_footer_section',
			'priority'      => 3,
		)
    );

    // Footer Widgets Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_footer_widgets_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_footer_widgets_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Footer Widgets', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_footer_top',
			'settings'    => 'expert_adventure_guide_footer_widgets_setting',
			'type'        => 'checkbox'
		) 
	);

	// Footer Background Image Setting
	$wp_customize->add_setting('expert_adventure_guide_footer_bg_image',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'expert_adventure_guide_footer_bg_image',array(
	'label' => __('Footer Background Image','expert-adventure-guide'),
	'section' => 'expert_adventure_guide_footer_top'
	)));

	// Footer Background Image Opacity
	$wp_customize->add_setting('expert_adventure_guide_footer_bg_image_opacity', array(
		'default'           => 50,
		'sanitize_callback' => 'absint',
		'capability'        => 'edit_theme_options',
	));

	$wp_customize->add_control('expert_adventure_guide_footer_bg_image_opacity', array(
		'label'    => __('Footer Background Image Opacity (%)', 'expert-adventure-guide'),
		'section'  => 'expert_adventure_guide_footer_top',
		'type'     => 'range',
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 100,
			'step' => 1,
		),
	));

	// Footer Background Color Setting
    $wp_customize->add_setting('expert_adventure_guide_footer_bg_color',array(
		'default' => '#000000',
		'sanitize_callback' => 'sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'expert_adventure_guide_footer_bg_color',array(
		'label' => esc_html__('Footer Background Color', 'expert-adventure-guide'),
		'section' => 'expert_adventure_guide_footer_top', // Adjust section if needed
		'settings' => 'expert_adventure_guide_footer_bg_color',
	)));

	$wp_customize->add_setting( 'expert_adventure_guide_upgrade_page_settings_1',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Adventure_Guide_Control_Upgrade(
        $wp_customize, 'expert_adventure_guide_upgrade_page_settings_1',
            array(
                'priority'      => 200,
                'section'       => 'expert_adventure_guide_footer_top',
                'settings'      => 'expert_adventure_guide_upgrade_page_settings_1',
                'label'         => __( 'Adventure Guide Pro comes with additional features.', 'expert-adventure-guide' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-adventure-guide' ), __( 'One-Click Demo Import', 'expert-adventure-guide' ), __( 'WooCommerce Integrated', 'expert-adventure-guide' ), __( 'Drag & Drop Section Reordering', 'expert-adventure-guide' ),__( 'Advanced Typography Control', 'expert-adventure-guide' ),__( 'Intuitive Customization Options', 'expert-adventure-guide' ),__( '24/7 Support', 'expert-adventure-guide' ), )
            )
        )
    ); 

	// Footer Bottom // 
	$wp_customize->add_section(
        'expert_adventure_guide_footer_bottom',
        array(
            'title' 		=> __('Footer Bottom','expert-adventure-guide'),
			'panel'  		=> 'expert_adventure_guide_footer_section',
			'priority'      => 3,
		)
    );
	
	// Footer Copyright Head
	$wp_customize->add_setting(
		'footer_btm_copy_head'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_text',
			'priority'  => 3,
		)
	);

	// Site Title Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_adventure_guide_footer_copyright_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_adventure_guide_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'expert_adventure_guide_footer_copyright_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Footer Copyright', 'expert-adventure-guide' ),
			'section'     => 'expert_adventure_guide_footer_bottom',
			'settings'    => 'expert_adventure_guide_footer_copyright_setting',
			'type'        => 'checkbox'
		) 
	);
	
	// Footer Copyright 
	$wp_customize->add_setting(
    	'expert_adventure_guide_footer_copyright',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);

	$wp_customize->add_control( 
		'expert_adventure_guide_footer_copyright',
		array(
		    'label'   		=> __('Edit Copyright Text','expert-adventure-guide'),
		    'section'		=> 'expert_adventure_guide_footer_bottom',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	$wp_customize->add_setting( 'expert_adventure_guide_copyright_alignment', array(
        'default'   => 'center',
        'sanitize_callback' => 'expert_adventure_guide_sanitize_copyright_position',
    ));

    $wp_customize->add_control( 'expert_adventure_guide_copyright_alignment', array(
        'label'    => __( 'Copyright Position', 'expert-adventure-guide' ),
        'section'  => 'expert_adventure_guide_footer_bottom',
        'settings' => 'expert_adventure_guide_copyright_alignment',
        'type'     => 'radio',
        'choices'  => array(
            'right' => __( 'Right Align', 'expert-adventure-guide' ),
            'left'  => __( 'Left Align', 'expert-adventure-guide' ),
            'center'  => __( 'Center Align', 'expert-adventure-guide' ),
        ),
    ));

	$wp_customize->add_setting( 'expert_adventure_guide_upgrade_page_settings_2',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Adventure_Guide_Control_Upgrade(
        $wp_customize, 'expert_adventure_guide_upgrade_page_settings_2',
            array(
                'priority'      => 200,
                'section'       => 'expert_adventure_guide_footer_bottom',
                'settings'      => 'expert_adventure_guide_upgrade_page_settings_2',
                'label'         => __( 'Adventure Guide Pro comes with additional features.', 'expert-adventure-guide' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-adventure-guide' ), __( 'One-Click Demo Import', 'expert-adventure-guide' ), __( 'WooCommerce Integrated', 'expert-adventure-guide' ), __( 'Drag & Drop Section Reordering', 'expert-adventure-guide' ),__( 'Advanced Typography Control', 'expert-adventure-guide' ),__( 'Intuitive Customization Options', 'expert-adventure-guide' ),__( '24/7 Support', 'expert-adventure-guide' ), )
            )
        )
    ); 
}
add_action( 'customize_register', 'expert_adventure_guide_footer' );

// Footer selective refresh
function expert_adventure_guide_footer_partials( $wp_customize ){
	// footer_copyright
	$wp_customize->selective_refresh->add_partial( 'footer_copyright', array(
		'selector'            => '.copy-right .copyright-text',
		'settings'            => 'footer_copyright',
		'render_callback'  => 'expert_adventure_guide_footer_copyright_render_callback',
	) );
}
add_action( 'customize_register', 'expert_adventure_guide_footer_partials' );

// copyright_content
function expert_adventure_guide_footer_copyright_render_callback() {
	return get_theme_mod( 'footer_copyright' );
}