<?php
if ( ! function_exists( 'expert_adventure_guide_setup' ) ) :
function expert_adventure_guide_setup() {

// Root path/URI.
define( 'EXPERT_ADVENTURE_GUIDE_PARENT_DIR', get_template_directory() );
define( 'EXPERT_ADVENTURE_GUIDE_PARENT_URI', get_template_directory_uri() );

// Root path/URI.
define( 'EXPERT_ADVENTURE_GUIDE_PARENT_INC_DIR', EXPERT_ADVENTURE_GUIDE_PARENT_DIR . '/inc');
define( 'EXPERT_ADVENTURE_GUIDE_PARENT_INC_URI', EXPERT_ADVENTURE_GUIDE_PARENT_URI . '/inc');

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'wc-product-gallery-zoom' );
	add_theme_support( 'wc-product-gallery-slider' );

	/*
	 * Let WordPress manage the document title.
	 */
	add_theme_support( 'title-tag' );

	add_theme_support( 'responsive-embeds' );
	
	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 */
	add_theme_support( 'post-thumbnails' );
	
	//Add selective refresh for sidebar widget
	add_theme_support( 'customize-selective-refresh-widgets' );
	
	/*
	 * Make theme available for translation.
	 */
	load_theme_textdomain( 'expert-adventure-guide', get_template_directory() . '/languages' );
		
	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary'  => esc_html__( 'Primary Menu', 'expert-adventure-guide' ),
		
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );
	
	
	add_theme_support('custom-logo');

	/*
	 * WooCommerce Plugin Support
	 */
	add_theme_support( 'woocommerce' );
	
	// Gutenberg wide images.
	add_theme_support( 'align-wide' );
	
	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, icons, and column width.
	 */
	add_editor_style( array( 'assets/css/editor-style.css', expert_adventure_guide_google_font() ) );
	
	//Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'expert_adventure_guide_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );

	add_theme_support( 'custom-header', apply_filters( 'expert_adventure_guide_custom_header_args', array(
		'default-image'          => get_template_directory_uri() . '/assets/custom-header.png',
		'default-text-color'     => 'ffffff',
		'width'                  => 2000, 
		'height'                 => 200,
		'flex-width'    		 => true,
		'flex-height'    		 => true,
        'uploads'            => true,
	)));


    /*
    * Enable support for Post Formats.
    *
    * See: https://codex.wordpress.org/Post_Formats
    */
    add_theme_support( 'post-formats', array('image','video','gallery','audio',) );


    //  --------------------------------------------- ENQUEUE ----------------------------------------------------- //

    /**
     * Implement the Custom Header feature.
     */
    require_once get_template_directory() . '/inc/custom-header.php';

    /**
     * Demo Import
     */
    require get_parent_theme_file_path( '/demo-import/demo-import-settings.php' );

    if ( ! defined( 'EXPERT_ADVENTURE_GUIDE_FREE_THEME_URL' ) ) {
        define( 'EXPERT_ADVENTURE_GUIDE_FREE_THEME_URL', 'https://www.seothemesexpert.com/products/free-adventure-wordpress-theme' );
    }
    if ( ! defined( 'EXPERT_ADVENTURE_GUIDE_PRO_THEME_URL' ) ) {
        define( 'EXPERT_ADVENTURE_GUIDE_PRO_THEME_URL', 'https://www.seothemesexpert.com/products/adventure-guide-website-template' );
    }
    if ( ! defined( 'EXPERT_ADVENTURE_GUIDE_DEMO_THEME_URL' ) ) {
        define( 'EXPERT_ADVENTURE_GUIDE_DEMO_THEME_URL', 'https://demo.seothemesexpert.com/expert-adventure-guide/' );
    }
    if ( ! defined( 'EXPERT_ADVENTURE_GUIDE_FREE_DOCS_THEME_URL' ) ) {
        define( 'EXPERT_ADVENTURE_GUIDE_FREE_DOCS_THEME_URL', 'https://demo.seothemesexpert.com/documentation/expert-adventure-guide/' );
    }
    if ( ! defined( 'EXPERT_ADVENTURE_GUIDE_RATE_THEME_URL' ) ) {
        define( 'EXPERT_ADVENTURE_GUIDE_RATE_THEME_URL', 'https://wordpress.org/support/theme/expert-adventure-guide/reviews/#new-post' );
    }
    if ( ! defined( 'EXPERT_ADVENTURE_GUIDE_SUPPORT_THEME_URL' ) ) {
        define( 'EXPERT_ADVENTURE_GUIDE_SUPPORT_THEME_URL', 'https://wordpress.org/support/theme/expert-adventure-guide/' );
    }
    if ( ! defined( 'EXPERT_ADVENTURE_GUIDE_THEME_BUNDLE_URL' ) ) {
        define( 'EXPERT_ADVENTURE_GUIDE_THEME_BUNDLE_URL', 'https://www.seothemesexpert.com/products/wordpress-theme-bundle' );
    }
}
endif;
add_action( 'after_setup_theme', 'expert_adventure_guide_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function expert_adventure_guide_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'expert_adventure_guide_content_width', 1170 );
}
add_action( 'after_setup_theme', 'expert_adventure_guide_content_width', 0 );


/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */

function expert_adventure_guide_widgets_init() {
	
	register_sidebar( array(
		'name' => __( 'Sidebar Widget Area', 'expert-adventure-guide' ),
		'id' => 'expert-adventure-guide-sidebar-primary',
		'description' => __( 'The Primary Widget Area', 'expert-adventure-guide' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s wow fadeInUp">',
		'after_widget' => '</aside>',
		'before_title' => '<h4 class="widget-title">',
		'after_title' => '</h4><div class="title"><span class="shap"></span></div>',
	) );
	
	register_sidebar( array(
		'name' => __( 'Footer Widget Area', 'expert-adventure-guide' ),
		'id' => 'expert-adventure-guide-footer-widget-area',
		'description' => __( 'The Footer Widget Area', 'expert-adventure-guide' ),
		'before_widget' => '<div class="footer-widget col-lg-3 col-sm-6 wow fadeIn" data-wow-delay="0.5s"><aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside></div>',
		'before_title' => '<h5 class="widget-title w-title">',
		'after_title' => '</h5><span class="shap"></span>',
	) );
}
add_action( 'widgets_init', 'expert_adventure_guide_widgets_init' );

/**
 * All Styles & Scripts.
 */

require_once get_template_directory() . '/inc/enqueue.php';

/**
 * Nav Walker fo Bootstrap Dropdown Menu.
 */

require_once get_template_directory() . '/inc/class-wp-bootstrap-navwalker.php';

/**
 * Custom template tags for this theme.
 */
require_once get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require_once get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require_once get_template_directory() . '/inc/customizer.php';

require_once get_template_directory() . '/inc/fonts.php';

require_once get_template_directory() . '/wptt-webfont-loader.php';


/* Excerpt Limit Begin */
function expert_adventure_guide_string_limit_words($expert_adventure_guide_string, $expert_adventure_guide_word_limit) {
    $expert_adventure_guide_words = explode(' ', $expert_adventure_guide_string, ($expert_adventure_guide_word_limit + 1));
    if(count($expert_adventure_guide_words) > $expert_adventure_guide_word_limit)
    array_pop($expert_adventure_guide_words);
    return implode(' ', $expert_adventure_guide_words);
}

// Sanitize the input
function expert_adventure_guide_sanitize_sidebar_position( $expert_adventure_guide_input ) {
    $expert_adventure_guide_valid = array( 'right', 'left' );

    if ( in_array( $expert_adventure_guide_input, $expert_adventure_guide_valid ) ) {
        return $expert_adventure_guide_input;
    } else {
        return 'right';
    }
}

add_filter( 'nav_menu_link_attributes', 'expert_adventure_guide_dropdown_data_attribute', 20, 3 );
/**
 * Use namespaced data attribute for Bootstrap's dropdown toggles.
 *
 * @param array    $atts HTML attributes applied to the item's `<a>` element.
 * @param WP_Post  $item The current menu item.
 * @param stdClass $args An object of wp_nav_menu() arguments.
 * @return array
 */
function expert_adventure_guide_dropdown_data_attribute( $atts, $item, $args ) {
    if ( is_a( $args->walker, 'WP_Bootstrap_Navwalker' ) ) {
        if ( array_key_exists( 'data-toggle', $atts ) ) {
            unset( $atts['data-toggle'] );
            $atts['data-bs-toggle'] = 'dropdown';
        }
    }
    return $atts;
}

function expert_adventure_guide_custom_controls() {
	load_template( trailingslashit( get_template_directory() ) . '/inc/customizer/customizer-custom-controls.php' );
}
add_action( 'customize_register', 'expert_adventure_guide_custom_controls' );

function remove_theme_customizer_setting($wp_customize) {
    // Remove the setting
    $wp_customize->remove_setting('display_header_text');
    // Remove the control
    $wp_customize->remove_control('display_header_text');
}
add_action('customize_register', 'remove_theme_customizer_setting', 20); 
// Use a priority greater than the one used for adding the setting

// Set the number of products per row to 3 on the shop page
add_filter('loop_shop_columns', 'expert_adventure_guide_custom_shop_loop_columns');

if (!function_exists('expert_adventure_guide_custom_shop_loop_columns')) {
    function expert_adventure_guide_custom_shop_loop_columns() {
        // Retrieve the number of columns from theme customizer setting (default: 3)
        $expert_adventure_guide_columns = get_theme_mod('expert_adventure_guide_custom_shop_per_columns', 3);
        return $expert_adventure_guide_columns;
    }
}

// Set the number of products per page on the shop page
add_filter('loop_shop_per_page', 'expert_adventure_guide_custom_shop_per_page', 20);

if (!function_exists('expert_adventure_guide_custom_shop_per_page')) {
    function expert_adventure_guide_custom_shop_per_page($expert_adventure_guide_products_per_page) {
        // Retrieve the number of products per page from theme customizer setting (default: 9)
        $expert_adventure_guide_products_per_page = get_theme_mod('expert_adventure_guide_custom_shop_product_per_page', 9);
        return $expert_adventure_guide_products_per_page;
    }
}

/**
 * Enqueue theme copyright alignment style.
 */
function expert_adventure_guide_copyright_alignment_option() {
    // Get the alignment setting from the theme customizer.
    $expert_adventure_guide_copyright_alignment = get_theme_mod('expert_adventure_guide_copyright_alignment', 'center');

    // Start building the CSS string for the alignment.
    $expert_adventure_guide_copyright_alignment_css = '
        .copyright-text, .footer-copyright, .footer-copyright a, p.copyright-text {
            text-align: ' . esc_attr($expert_adventure_guide_copyright_alignment) . ';
        }
    ';

    // Add the inline style to the theme's main stylesheet.
    wp_add_inline_style('expert-adventure-guide-style', $expert_adventure_guide_copyright_alignment_css);
}

add_action('wp_enqueue_scripts', 'expert_adventure_guide_copyright_alignment_option');

function expert_adventure_guide_fonts_scripts() {
	$expert_adventure_guide_headings_font = esc_html(get_theme_mod('expert_adventure_guide_headings_text'));
	$expert_adventure_guide_body_font = esc_html(get_theme_mod('expert_adventure_guide_body_text'));

	if( $expert_adventure_guide_headings_font ) {
		wp_enqueue_style( 'expert-adventure-guide-headings-fonts', '//fonts.googleapis.com/css?family='. $expert_adventure_guide_headings_font );
	} else {
		wp_enqueue_style( 'expert-adventure-guide-source-sans', '//fonts.googleapis.com/css?family=Lato:400,700,400italic,700italic');
	}
	if( $expert_adventure_guide_body_font ) {
		wp_enqueue_style( 'expert-adventure-guide-body-fonts', '//fonts.googleapis.com/css?family='. $expert_adventure_guide_body_font );
	} else {
		wp_enqueue_style( 'expert-adventure-guide-source-body', '//fonts.googleapis.com/css?family=Source+Sans+Pro:400,300,400italic,700,600');
	}
}
add_action( 'wp_enqueue_scripts', 'expert_adventure_guide_fonts_scripts' );

function expert_adventure_guide_customize_css() {
    $expert_adventure_guide_dynamic_color = get_theme_mod( 'expert_adventure_guide_dynamic_color_one', '#d4635e' );
    $expert_adventure_guide_custom_css = ":root { --color-primary1: {$expert_adventure_guide_dynamic_color}; }";
    wp_add_inline_style( 'expert-adventure-guide-style', $expert_adventure_guide_custom_css );
}
add_action( 'wp_enqueue_scripts', 'expert_adventure_guide_customize_css' );

// Helper function to get page ID by slug
function get_page_id_by_slug($expert_adventure_guide_slug) {
    $expert_adventure_guide_page = get_page_by_path($expert_adventure_guide_slug); // Get the page by slug
    return $expert_adventure_guide_page ? $expert_adventure_guide_page->ID : 0;   // Return the page ID or 0 if not found
}

// Show Admin Notice
function expert_adventure_guide_promo_notice() {
    if (get_option('expert_adventure_guide_notice_dismissed')) {
        return;
    }

    if (isset($_GET['page']) && $_GET['page'] === 'expertadventureguide-wizard') {
        return;
    }

    $expert_adventure_guide_theme = wp_get_theme();
    $expert_adventure_guide_theme_title = $expert_adventure_guide_theme->get( 'Name' );
    $expert_adventure_guide_theme_version = $expert_adventure_guide_theme->get( 'Version' );

    ?>
    <div class="notice expert-adventure-guide-notice is-dismissible">
        <div>
            <h3>
                <span><?php echo esc_html( '(Version: ' . $expert_adventure_guide_theme_version . ')' ); ?></span><br>
                <?php esc_html_e( 'Thank you for choosing,', 'expert-adventure-guide'); ?>
                <?php echo esc_html( $expert_adventure_guide_theme_title ); ?> <?php esc_html_e( '!!!', 'expert-adventure-guide'); ?>
            </h3>
            <p><?php esc_html_e( 'Welcome! You can now easily start building your website using our beautiful and user-friendly themes. No need to worry about setup — with our one-click demo importer, your site can look just like the demo in minutes. All the tools and information you need to get started are right here!', 'expert-adventure-guide'); ?></p>
            <a class="button button-primary expert-adventure-guide-buy-now" href="<?php echo esc_url(admin_url('themes.php?page=expertadventureguide-wizard')); ?>" target="_blank">
                <?php esc_html_e( 'One Click Demo Import', 'expert-adventure-guide') ?>
            </a>
            <a class="button button-primary expert-adventure-guide-bundle-button" target="_blank" href="<?php echo esc_url( EXPERT_ADVENTURE_GUIDE_THEME_BUNDLE_URL ); ?>">
                <?php echo esc_html__( 'Get All 50+ Themes @ $79', 'expert-adventure-guide' ); ?>
            </a>
        </div>
        <div class="expert-adventure-guide-image-wrap">
            <img src="<?php echo esc_url(get_stylesheet_directory_uri() . '/screenshot.png'); ?>">
        </div>
        <canvas id="expert-adventure-guide-notice-confetti"></canvas>
    </div>
    <?php
}
add_action('admin_notices', 'expert_adventure_guide_promo_notice');

add_action('wp_ajax_expert_adventure_guide_dismiss_notice', 'expert_adventure_guide_dismiss_notice');
function expert_adventure_guide_dismiss_notice() {
    update_option('expert_adventure_guide_notice_dismissed', true);
    wp_send_json_success();
}

add_action('after_switch_theme', 'expert_adventure_guide_reset_notice_on_activation');
function expert_adventure_guide_reset_notice_on_activation() {
    delete_option('expert_adventure_guide_notice_dismissed');
}

function expert_adventure_guide_enqueue_admin_assets() {
    wp_enqueue_script(
        'expert-adventure-guide-confetti',
        get_template_directory_uri() . '/demo-import/assets/js/confetti/confetti.min.js',
        ['jquery'],
        null,
        true
    );

    wp_enqueue_script(
        'expert-adventure-guide-notice-confetti-js',
        get_template_directory_uri() . '/demo-import/assets/js/plugin-update-notice.js',
        ['expert-adventure-guide-confetti'],
        null,
        true
    );

    wp_enqueue_script(
        'expert-adventure-guide-notice-dismiss',
        get_template_directory_uri() . '/demo-import/assets/js/notice-dismiss.js',
        ['jquery'],
        null,
        true
    );
}
add_action('admin_enqueue_scripts', 'expert_adventure_guide_enqueue_admin_assets');