<?php
global $post;
$post_id = $post->ID;

$related_posts_text = get_theme_mod( 'related_posts_text', __( 'You May Also Like', 'eximious-magazine' ) );
$orderby            = esc_attr( get_theme_mod( 'related_posts_orderby', 'date' ) );

// Covert id to ID to make it work with query
if ( 'id' == $orderby ) {
	$orderby = 'ID';
}

$category_ids = array();
$categories   = get_the_category( $post_id );

if ( ! empty( $categories ) ) :
	foreach ( $categories as $cat ) :
		$category_ids[] = $cat->term_id;
	endforeach;
endif;

if ( ! empty( $category_ids ) ) :

	$related_posts_args = array(
		'category__in'        => $category_ids,
		'post_type'           => 'post',
		'post__not_in'        => array( $post_id ),
		'posts_per_page'      => absint( get_theme_mod( 'no_of_related_posts', 3 ) ),
		'ignore_sticky_posts' => 1,
		'orderby'             => $orderby,
		'order'               => esc_attr( get_theme_mod( 'related_posts_order', 'desc' ) ),
	);

	$related_posts_query = new WP_Query( $related_posts_args );

	if ( $related_posts_query->have_posts() ) :
		?>
		<div class="eximious-magazine-related-posts-wrapper eximious-magazine-post-extras-grid-block wide-max-width">
			<?php
			if ( $related_posts_text ) :
				$title_style = get_theme_mod( 'related_posts_title_style', 'style_1' );
				$title_align = 'has-text-align-' . get_theme_mod( 'related_posts_title_align', 'left' );
				?>
				<div class="saga-section-title">
					<h2 class="saga-element-header <?php echo esc_attr( $title_style . ' ' . $title_align ); ?>">
						<span><?php echo esc_html( $related_posts_text ); ?></span>
					</h2>
				</div>
			<?php endif; ?>
			<div class="section-posts">
				<?php
				$title_limit = get_theme_mod( 'related_posts_title_limit' );
				while ( $related_posts_query->have_posts() ) :
					$related_posts_query->the_post();
					?>
					<div class="saga-block-post-card img-animate-zoom eximious-magazine-card-box">
						<div class="saga-block-item-w-overlay">
							<div class="saga-block-image-w-overlay">
								<a href="<?php the_permalink(); ?>">
									<?php
									if ( get_theme_mod( 'show_related_posts_post_format_icon' ) ) {
										eximious_magazine_post_format_icon('center');
									}
									?>
									<?php the_post_thumbnail( 'eximious-magazine-medium-img' ); ?>
								</a>
							</div>
						</div>
						<div class="saga-block-card-content">
							<h3 class="saga-block-card-title">
								<a href="<?php the_permalink(); ?>" class="text-decoration-none color-accent-hover eximious-magazine-limit-lines <?php echo esc_attr( $title_limit ); ?>">
									<?php the_title(); ?>
								</a>
							</h3>
							<div class="post-date">
								<?php echo esc_html( get_the_date() ); ?>
							</div>
						</div>
					</div>
					<?php
				endwhile;
				wp_reset_postdata();
				?>
			</div>
		</div>
		<?php
	endif;
endif;
