<?php
$trending_post_cat      = get_theme_mod( 'trending_post_cat', 1 );
$trending_posts_orderby = get_theme_mod( 'trending_posts_orderby', 'date' );

// Covert id to ID to make it work with query
if ( 'id' == $trending_posts_orderby ) {
	$trending_posts_orderby = 'ID';
}

if ( ! empty( $trending_post_cat ) ) :
	$post_args = array(
		'post_type'      => 'post',
		'posts_per_page' => absint( get_theme_mod( 'no_of_trending_posts', 5 ) ),
		'post_status'    => 'publish',
		'orderby'        => esc_attr( $trending_posts_orderby ),
		'order'          => esc_attr( get_theme_mod( 'trending_posts_order', 'desc' ) ),
		'tax_query'      => array(
			array(
				'taxonomy' => 'category',
				'field'    => 'term_id',
				'terms'    => $trending_post_cat,
			),
		),

	);
	$trending_post = new WP_Query( $post_args );
	if ( $trending_post->have_posts() ) :

		$wrapper_class = '';

		$trending_post_meta = get_theme_mod( 'trending_post_meta', array( 'date' ) );
		$trending_post_text = get_theme_mod( 'trending_post_text' );

		$trending_posts_text_uppercase = get_theme_mod( 'trending_posts_text_uppercase', true );
		if ( $trending_posts_text_uppercase ) {
			$wrapper_class .= ' em-uppercase-text';
		}
		?>
		<section class="eximious-magazine-section-block section-trending <?php echo esc_attr( $wrapper_class ); ?>">
			<div class="wide-max-width">
				<div class="eximious-trending-posts-wrapper">
					<div class="eximious-trending-posts-text">
						<strong>
							<?php
							if ( $trending_post_text ) {
								echo esc_html( $trending_post_text );
							} else {
								esc_html_e( 'Trending Now', 'eximious-magazine' );
							}
							?>
						</strong>
					</div>
					<div class="eximious-trending-posts-content">
						<div data-flow="uf-marquee" class="marquee-posts-wrapper">
							<?php
							while ( $trending_post->have_posts() ) :
								$trending_post->the_post();
								?>
								<a href="<?php the_permalink(); ?>" class="text-decoration-none">
									<?php
									if ( in_array( 'thumb', $trending_post_meta ) ) :
										the_post_thumbnail( 'thumbnail' );
									endif;
									?>
									<?php
									if ( in_array( 'date', $trending_post_meta ) ) :
										$date_format = get_theme_mod( 'trending_posts_date_format', 'format_2' );
										?>
										<span class="eximious-trending-post-date">
											<?php
											if ( 'format_1' == $date_format ) :
												echo esc_html( human_time_diff( get_the_time( 'U' ), current_time( 'timestamp' ) ) . ' ' . __( 'ago', 'eximious-magazine' ) );
											else :
												echo esc_html( get_the_date() );
											endif;
											?>
										</span>
									<?php endif; ?>
									<span class="eximious-trending-post-title"><?php the_title(); ?></span>
								</a>
								<?php
							endwhile;
							wp_reset_postdata();
							?>
						</div>
					</div>
				</div>
			</div>
		</section>
		<?php
	endif;
endif;
