<?php
/**
 * Displays before home columns widget area.
 *
 * @package Eximious_Magazine
 */

if ( is_active_sidebar( 'before-homepage-cols-widget-area' ) ) :

	$heading_style = ' saga-title-style-' . get_theme_mod( 'before_home_cols_widgetarea_heading_style', 'style_10' );
	$heading_align = ' saga-title-align-' . get_theme_mod( 'before_home_cols_widgetarea_heading_align', 'left' );
	$class         = $heading_style . $heading_align;
	$class         = apply_filters( 'before_home_columns_widgetarea_wrapper_class', $class );
	?>
	<div class="before-home-cols-widget-region <?php echo esc_attr( $class ); ?>" role="complementary">
		<?php do_action( 'before_home_columns_widgetarea_top' ); ?>
		<div class="general-widget-area">
			<?php dynamic_sidebar( 'before-homepage-cols-widget-area' ); ?>
		</div>
		<?php do_action( 'before_home_columns_widgetarea_bottom' ); ?>
	</div>
	<?php

endif;
