<?php
/**
 * Displays before home widget area.
 *
 * @package Eximious_Magazine
 */

if ( is_active_sidebar( 'above-homepage-widget-area' ) ) :

	$heading_style = ' saga-title-style-' . get_theme_mod( 'above_home_widgetarea_heading_style', 'style_10' );
	$heading_align = ' saga-title-align-' . get_theme_mod( 'above_home_widgetarea_heading_align', 'left' );
	$class         = $heading_style . $heading_align;
	$class         = apply_filters( 'above_home_widgetarea_wrapper_class', $class );
	?>
	<div class="before-home-widget-region <?php echo esc_attr( $class ); ?>" role="complementary">
		<?php do_action( 'above_home_widgetarea_top' ); ?>
		<div class="general-widget-area">
			<?php dynamic_sidebar( 'above-homepage-widget-area' ); ?>
		</div>
		<?php do_action( 'above_home_widgetarea_bottom' ); ?>
	</div>
	<?php

endif;
