<?php
$post_args = array(
	'post_type'           => 'post',
	'post_status'         => 'publish',
	'no_found_rows'       => 1,
	'ignore_sticky_posts' => 1,
);

$banner_content_from = get_theme_mod( 'banner_content_from', 'category' );

if ( 'category' == $banner_content_from ) :

	$slider_cat                  = get_theme_mod( 'slider_cat' );
	$banner_posts_orderby        = esc_attr( get_theme_mod( 'banner_posts_orderby', 'date' ) );
	$post_args['posts_per_page'] = absint( get_theme_mod( 'no_of_banner_posts', 4 ) );
	$post_args['orderby']        = ( 'id' == $banner_posts_orderby ) ? strtoupper( $banner_posts_orderby ) : $banner_posts_orderby;
	$post_args['order']          = esc_attr( get_theme_mod( 'banner_posts_order', 'desc' ) );

	if ( ! empty( $slider_cat ) ) :
		$post_args['tax_query'][] = array(
			'taxonomy' => 'category',
			'field'    => 'term_id',
			'terms'    => absint( $slider_cat ),
		);
	endif;

else :

	$banner_post_ids = get_theme_mod( 'banner_post_ids' );
	if ( ! empty( $banner_post_ids ) ) :
		$post_ids                    = explode( ',', esc_attr( $banner_post_ids ) );
		$post_args['post__in']       = $post_ids;
		$post_args['orderby']        = 'post__in';
		$post_args['posts_per_page'] = count( $post_ids );
	endif;

endif;

$banner_posts = new WP_Query( $post_args );
if ( $banner_posts->have_posts() ) :

	// Empty container class for full width banner.
	$container_class = $slider_wrapper_class = '';

	// Holds banner attributes.
	$data_banner = array();

	// Default image size.
	$image_size = 'eximious-magazine-cover-image';

	$enable_banner_dots = $enable_banner_arrows = '';

	$banner_layout         = get_theme_mod( 'banner_layout', 'full-width' );
	$banner_display_as     = get_theme_mod( 'banner_display_as', 'slider' );
	$enable_banner_arrows  = get_theme_mod( 'enable_banner_arrows', true );
	$enable_banner_dots    = get_theme_mod( 'enable_banner_dots' );
	$enable_banner_overlay = get_theme_mod( 'enable_banner_overlay', true );
	if ( $enable_banner_overlay ) {
		$banner_overlay_style  = 'background-color:' . esc_attr( get_theme_mod( 'banner_overlay_color', '#000000' ) ) . ';';
		$banner_overlay_style .= 'opacity:' . esc_attr( get_theme_mod( 'banner_overlay_opacity', 0.6 ) ) . ';';
	}
	$show_banner_category = get_theme_mod( 'show_banner_category', true );
	if ( $show_banner_category ) {
		$banner_cat_style = get_theme_mod( 'banner_category_style', 'style_2' );
		$banner_cat_color = get_theme_mod( 'banner_category_color_display', 'as_bg' );
		$banner_cat_limit = get_theme_mod( 'banner_category_limit', 3 );
	}
	$banner_post_meta            = get_theme_mod( 'banner_post_meta' );
	$banner_post_meta_settings   = array(
		'date_format'  => get_theme_mod( 'banner_posts_date_format', 'format_2' ),
		'author_image' => get_theme_mod( 'enable_banner_author_image' ),
	);
	$enable_banner_desc          = get_theme_mod( 'enable_banner_desc', true );
	$banner_desc_length          = get_theme_mod( 'banner_desc_length', 25 );
	$enable_banner_read_more_btn = get_theme_mod( 'enable_banner_read_more_btn' );
	$banner_read_more_btn_text   = get_theme_mod( 'banner_read_more_btn_text' );

	$enable_pinned_posts = get_theme_mod( 'enable_pinned_posts' );

	// Wrapper class for non full width banner.
	if ( 'boxed' == $banner_layout ) :
		$container_class = ' wide-max-width';
		if ( $enable_pinned_posts ) :
			$image_size           = 'eximious-magazine-large-img';
			$slider_wrapper_class = 'col-lg-7';
		else :
			$slider_wrapper_class = 'col-lg-12';
		endif;
	endif;

	if ( 'full-width' == $banner_layout ) :
		$enable_pinned_posts  = false;
		$image_size           = 'eximious-magazine-cover-image';
		$slider_wrapper_class = 'col-lg-12';
	endif;

	if ( 'slider' == $banner_display_as ) :

		$banner_style = 'as-slider style_1';

		$data_banner['effect']     = 'fade';
		$data_banner['fadeEffect'] = array(
			'crossFade' => true,
		);

		$banner_style .= ' em-animate-content';

	else :

		$banner_style = 'as-carousel style_1';
		$item_gap     = absint( get_theme_mod( 'banner_carousel_item_gap', 5 ) );

		$data_banner['slidesPerView']  = 1.1;
		$data_banner['centeredSlides'] = true;
		$data_banner['keyboard']       = array(
			'enabled' => true,
		);
		$data_banner['spaceBetween']   = $item_gap;
		$data_banner['breakpoints']    = array(
			'800' => array(
				'slidesPerView' => 1.5,
			),
		);

		$banner_style .= ' em-animate-content';

	endif;

	if ( $enable_banner_arrows ) :
		$data_banner['navigation'] = array(
			'nextEl' => '.swiper-button-next',
			'prevEl' => '.swiper-button-prev',
		);
	endif;

	if ( $enable_banner_dots ) :
		$data_banner['pagination'] = array(
			'el'        => '.swiper-pagination',
			'clickable' => true,
		);
	endif;

	if ( get_theme_mod( 'enable_banner_autoplay', true ) ) :
		$data_banner['autoplay'] = array(
			'delay' => 5000,
		);
	endif;

	$wrapper_class = $banner_layout . ' ' . $banner_style;

	?>
	<section class="eximious-magazine-section-banner-wrapper <?php echo esc_attr( $wrapper_class ); ?>">
		<div class="eximious-magazine-section-banner<?php echo esc_attr( $container_class ); ?>">
			<div class="row<?php echo esc_attr( 'full-width' == $banner_layout ) ? ' gy-0' : ' g-2'; ?>">
				<div class="col <?php echo esc_attr( $slider_wrapper_class ); ?>">
					<?php
					$banner_title = get_theme_mod( 'banner_title' );
					if ( ! empty( $banner_title ) ) :
						$title_style = get_theme_mod( 'banner_title_style', 'style_1' );
						$title_align = 'has-text-align-' . get_theme_mod( 'banner_title_align', 'left' );
						?>
						<div class="saga-section-title">
							<h2 class="saga-element-header <?php echo esc_attr( $title_style . ' ' . $title_align ); ?>">
								<span><?php echo esc_html( $banner_title ); ?></span>
							</h2>
						</div>
					<?php endif; ?>
					<div class="eximious-magazine-banner-wrapper swiper" data-banner='<?php echo esc_attr( json_encode( $data_banner ) ); ?>'>
						<div class="eximious-magazine-banner swiper-wrapper">
							<?php
							$title_limit = get_theme_mod( 'banner_posts_title_limit' );
							while ( $banner_posts->have_posts() ) :
								$banner_posts->the_post();
								if ( has_post_thumbnail() ) :
									?>
									<div class="swiper-slide">
										<div class="banner-block-wrapper img-animate-zoom">
											<div class="banner-image">
												<a href="<?php the_permalink(); ?>">
													<?php if ( $enable_banner_overlay ) : ?>
														<span aria-hidden="true" class="eximious-magazine-block-overlay" style="<?php echo $banner_overlay_style; ?>"></span>
													<?php endif; ?>
													<?php
													the_post_thumbnail(
														$image_size,
														array(
															'alt' => the_title_attribute(
																array(
																	'echo' => false,
																)
															),
														)
													);
													?>
												</a>
											</div>
											<div class="banner-caption">
												<div class="banner-caption-inner">
													<?php
													if ( $show_banner_category ) :
														eximious_magazine_post_categories( $banner_cat_style, $banner_cat_color, $banner_cat_limit );
													endif;
													?>
													<h3 class="banner-title no-margin">
														<a href="<?php the_permalink(); ?>" class="text-decoration-none eximious-magazine-limit-lines <?php echo esc_attr( $title_limit ); ?>">
															<?php the_title(); ?>
														</a>
													</h3>
													<?php eximious_magazine_post_meta_info( $banner_post_meta, $banner_post_meta_settings ); ?>
													<?php
													if ( $enable_banner_desc && $banner_desc_length > 0 ) {
														?>
														<div class="banner-excerpt hide-on-mobile">
															<p class="no-margin">
																<?php echo wp_trim_words( get_the_excerpt(), $banner_desc_length, '&hellip;' ); ?>
															</p>
														</div>
													<?php } ?>
													<?php
													if ( $enable_banner_read_more_btn ) {
														?>
														<div class="banner-read-more">
															<a href="<?php the_permalink(); ?>" class="eximious-magazine-read-more text-decoration-none read-more-link style_1">
																<?php
																if ( $banner_read_more_btn_text ) {
																	echo esc_html( $banner_read_more_btn_text );
																} else {
																	esc_html_e( 'Read More', 'eximious-magazine' );
																}
																?>
															</a>
														</div>
														<?php
													}
													?>
												</div>
											</div>
										</div>
									</div>
									<?php
								endif;
							endwhile;
							wp_reset_postdata();
							?>
						</div>
						<?php
						if ( $enable_banner_dots ) :
							echo '<div class="swiper-pagination"></div>';
						endif;
						if ( $enable_banner_arrows ) :
							echo '<div class="swiper-button-next"></div><div class="swiper-button-prev"></div>';
						endif;
						?>
					</div>
				</div>
				<?php
				// Pinned Posts.
				if ( 'full-width' != $banner_layout && $enable_pinned_posts ) :
					$pinned_posts_cat = get_theme_mod( 'pinned_posts_cat', 1 );
					if ( ! empty( $pinned_posts_cat ) ) :
						$post_args   = array(
							'post_type'      => 'post',
							'posts_per_page' => 2,
							'post_status'    => 'publish',
							'tax_query'      => array(
								array(
									'taxonomy' => 'category',
									'field'    => 'term_id',
									'terms'    => absint( $pinned_posts_cat ),
								),
							),
						);
						$pinned_post = new WP_Query( $post_args );
						if ( $pinned_post->have_posts() ) :
							$show_pinned_posts_category = get_theme_mod( 'show_pinned_posts_category', true );
							if ( $show_pinned_posts_category ) {
								$pinned_posts_cat_style = get_theme_mod( 'pinned_posts_category_style', 'style_2' );
								$pinned_posts_cat_color = get_theme_mod( 'pinned_posts_category_color_display', 'as_bg' );
								$pinned_posts_cat_limit = get_theme_mod( 'pinned_posts_category_limit', 1 );
							}
							$enable_pinned_posts_overlay = get_theme_mod( 'enable_pinned_posts_overlay', true );
							if ( $enable_pinned_posts_overlay ) {
								$pinned_posts_overlay_style  = 'background-color:' . esc_attr( get_theme_mod( 'pinned_posts_overlay_color', '#000000' ) ) . ';';
								$pinned_posts_overlay_style .= 'opacity:' . esc_attr( get_theme_mod( 'pinned_posts_overlay_opacity', 0.6 ) ) . ';';
							}
							$pinned_post_meta          = get_theme_mod( 'pinned_post_meta' );
							$pinned_post_meta_settings = array(
								'date_format'  => get_theme_mod( 'pinned_posts_date_format', 'format_2' ),
								'author_image' => get_theme_mod( 'enable_pinned_posts_author_image' ),
							);
							?>
							<div class="col co-lg-5">
								<?php
								$pinned_posts_title = get_theme_mod( 'pinned_posts_title' );
								if ( ! empty( $pinned_posts_title ) ) :
									$title_style = get_theme_mod( 'pinned_posts_title_style', 'style_1' );
									$title_align = 'has-text-align-' . get_theme_mod( 'pinned_posts_title_align', 'left' );
									?>
									<div class="saga-section-title">
										<h2 class="saga-element-header <?php echo esc_attr( $title_style . ' ' . $title_align ); ?>">
											<span><?php echo esc_html( $pinned_posts_title ); ?></span>
										</h2>
									</div>
								<?php endif; ?>
								<div class="eximious-magazine-pinned-posts-wrapper">
									<div class="eximious-magazine-pinned-posts">
										<div class="row row-cols-1 row-cols-sm-2 row-cols-lg-1 g-2">
											<?php
											$title_limit = get_theme_mod( 'pinned_posts_title_limit' );
											while ( $pinned_post->have_posts() ) :
												$pinned_post->the_post();
												if ( has_post_thumbnail() ) :
													?>
													<div class="col">
														<div class="saga-block-item-w-overlay img-animate-zoom">
															<?php
															if ( get_theme_mod( 'show_pinned_posts_post_format_icon' ) ) {
																eximious_magazine_post_format_icon();
															}
															?>
															<div class="saga-block-image-w-overlay">
																<a href="<?php the_permalink(); ?>" class="">
																	<?php if ( $enable_pinned_posts_overlay ) : ?>
																		<span aria-hidden="true" class="eximious-magazine-block-overlay" style="<?php echo $pinned_posts_overlay_style; ?>"></span>
																	<?php endif; ?>
																	<?php the_post_thumbnail( 'eximious-magazine-large-img' ); ?>
																</a>
															</div>
															<div class="saga-block-overlay-content">
																<?php
																if ( $show_pinned_posts_category ) :
																	eximious_magazine_post_categories( $pinned_posts_cat_style, $pinned_posts_cat_color, $pinned_posts_cat_limit );
																endif;
																?>
																<h3 class="saga-block-overlay-title">
																	<a href="<?php the_permalink(); ?>" class="text-decoration-none  eximious-magazine-limit-lines <?php echo esc_attr( $title_limit ); ?>">
																		<?php the_title(); ?>
																	</a>
																</h3>
																<?php eximious_magazine_post_meta_info( $pinned_post_meta, $pinned_post_meta_settings ); ?>
															</div>
														</div>
													</div>
													<?php
												endif;
											endwhile;
											wp_reset_postdata();
											?>
										</div>
									</div>
								</div>
							</div>
							<?php
						endif;
					endif;
				endif;
				?>
			</div>
		</div>
	</section>       
	<?php
endif;
