<?php

$bg_attr = $wrapper_class = $header_class = '';

$is_header_image = get_header_image();
if ( $is_header_image ) {
	$header_bg_image = 'url(' . esc_url( $is_header_image ) . ')';
	$bg_attr         = 'style="background-image:' . $header_bg_image . '"';
	$header_class    = ' has-header-image';
}

if ( get_theme_mod( 'enable_top_bar' ) ) :
	get_template_part( 'template-parts/header/top-bar' );
endif;

if ( get_theme_mod( 'center_logo', true ) ) {
	$wrapper_class .= ' centered has-text-align-center';
}

$ad_banner_image = get_theme_mod( 'ad_banner_image' );
if ( $ad_banner_image ) {
	$wrapper_class .= ' ad-banner-enabled';
}
?>

<header id="masthead" class="site-header-row-wrapper site-header eximious-magazine-site-header<?php echo esc_attr( $header_class ); ?>" role="banner" <?php echo $bg_attr; ?>>
	<div class="eximious-magazine-site-branding-row">
		<div class="wrapper">
			<div class="eximious-magazine-site-brand-ad-wrapper<?php echo esc_attr( $wrapper_class ); ?>">
				<div class="eximious-magazine-site-branding-main">
					<?php get_template_part( 'template-parts/header/site-branding' ); ?>
				</div>
				<?php
				if ( $ad_banner_image ) {
					$ad_banner_link = get_theme_mod( 'ad_banner_link' );
					?>
					<div class="eximious-magazine-ad-space">
						<?php
						$ad_banner_image_html = '<img src="' . esc_url( $ad_banner_image ) . '">';
						$ad_banner_link_open  = $ad_banner_link_close = '';
						if ( $ad_banner_link ) {
							$ad_banner_link_open  = '<a href="' . esc_url( $ad_banner_link ) . '" target="_blank">';
							$ad_banner_link_close = '</a>';
						}
						echo wp_kses_post( $ad_banner_link_open . $ad_banner_image_html . $ad_banner_link_close );
						?>
					</div>
					<?php
				}
				?>
			</div>
		</div> <!-- .wrapper -->
	</div>
</header>

<?php get_template_part( 'template-parts/header/site-nav' ); ?>
