<?php 
// Inverted OffCanvas.
$wrapper_classes = 'eximious-magazine-canvas-block';
if ( 'dark' == get_theme_mod( 'offcanvas_theme', 'light' ) ) {
	$wrapper_classes .= ' inverted-offcanvas';
}
?>
<div class="eximious-magazine-canvas-modal <?php echo esc_attr( $wrapper_classes ); ?>" role="dialog" aria-modal="true" aria-label="<?php esc_attr_e( 'Offcanvas', 'eximious-magazine' ); ?>">
	<div class="eximious-magazine-canvas-header">
		<?php 
		$offcanvas_logo = get_theme_mod('offcanvas_logo'); 
		if( $offcanvas_logo ){
			?>
			<div class="eximious-magazine-offcanvas-logo">
				<img src="<?php echo esc_url( $offcanvas_logo );?>">
			</div>
			<?php
		}
		?>
		<button class="close-canvas-modal eximious-magazine-off-canvas-close toggle fill-children-current-color">
			<span class="screen-reader-text"><?php esc_html_e( 'Close Off Canvas', 'eximious-magazine' ); ?></span>
			<?php eximious_magazine_the_theme_svg( 'modal-close' ); ?>
		</button>
	</div>
	<?php
	$heading_style = ' saga-title-style-' . get_theme_mod( 'offcanvas_widgetarea_heading_style', 'style_10' );
	$heading_align = ' saga-title-align-' . get_theme_mod( 'offcanvas_widgetarea_heading_align', 'left' );
	$class         = $heading_style . $heading_align;
	?>
	<div class="eximious-magazine-canvas-content <?php echo esc_attr( $class ); ?>">
		<nav aria-label="<?php echo esc_attr_x( 'Mobile', 'menu', 'eximious-magazine' ); ?>" role="navigation">
			<ul id="eximious-magazine-mobile-nav" class="eximious-magazine-responsive-menu reset-list-style">
				<?php
				if ( has_nav_menu( 'primary-menu' ) ) {
					wp_nav_menu(
						array(
							'container'      => '',
							'items_wrap'     => '%3$s',
							'show_toggles'   => true,
							'theme_location' => 'primary-menu',
						)
					);
				}
				?>
			</ul>
		</nav>
		<?php 
		if ( is_active_sidebar( 'offcanvas' ) ) :
			dynamic_sidebar( 'offcanvas' ); 
		endif;
		?>
	</div>
</div>
