<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Eximious_Magazine_Social_Menu extends Eximious_Magazine_Widget_Base {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->widget_cssclass    = 'widget_eximious_magazine_social_menu';
		$this->widget_description = __( 'Displays social menu if you have set it.', 'eximious-magazine' );
		$this->widget_id          = 'eximious_magazine_social_menu';
		$this->widget_name        = __( 'Eximious Magazine: Social Menu', 'eximious-magazine' );
		$this->settings           = array(
			'title'      => array(
				'type'  => 'text',
				'label' => __( 'Title', 'eximious-magazine' ),
			),
			'color'      => array(
				'type'    => 'select',
				'label'   => __( 'Social Links Color', 'eximious-magazine' ),
				'options' => array(
					'theme_color' => __( 'Use Theme Color', 'eximious-magazine' ),
					'brand_color' => __( 'Use Brand Color', 'eximious-magazine' ),
				),
				'std'     => 'theme_color',
			),
			'style'      => array(
				'type'    => 'select',
				'label'   => __( 'Style', 'eximious-magazine' ),
				'options' => eximious_magazine_get_social_links_styles(),
				'std'     => 'style_1',
			),
			'show_label' => array(
				'type'  => 'checkbox',
				'label' => __( 'Show Label', 'eximious-magazine' ),
				'std'   => false,
			),
			'column'     => array(
				'type'    => 'select',
				'label'   => __( 'Column', 'eximious-magazine' ),
				'desc'    => __( 'Will only work when label is enabled from above and there is enough space to display the columns.', 'eximious-magazine' ),
				'options' => array(
					'one'   => __( 'One', 'eximious-magazine' ),
					'two'   => __( 'Two', 'eximious-magazine' ),
					'three' => __( 'Three', 'eximious-magazine' ),
				),
				'std'     => 'two',
			),
			'align'      => array(
				'type'    => 'select',
				'label'   => __( 'Alignment', 'eximious-magazine' ),
				'options' => array(
					'left'   => __( 'Left', 'eximious-magazine' ),
					'center' => __( 'Center', 'eximious-magazine' ),
					'right'  => __( 'Right', 'eximious-magazine' ),
				),
				'std'     => 'left',
			),
		);

		parent::__construct();
	}

	/**
	 * Output widget.
	 *
	 * @see WP_Widget
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {
		ob_start();

		$this->widget_start( $args, $instance );

		do_action( 'eximious_magazine_before_social_menu' );

		$wrapper_class = isset( $instance['align'] ) ? $instance['align'] : $this->settings['align']['std'];

		?>
		<div class="eximious-magazine-social-menu-widget menu-align-<?php echo esc_attr( $wrapper_class ); ?>">
			<?php

			if ( has_nav_menu( 'social-menu' ) ) {

				$social_link_class  = ' reset-list-style eximious-magazine-social-icons ';
				$social_link_style  = isset( $instance['style'] ) ? $instance['style'] : $this->settings['style']['std'];
				$social_link_style .= eximious_magazine_get_social_icons_class( $social_link_style );
				$social_link_color  = isset( $instance['color'] ) ? $instance['color'] : $this->settings['color']['std'];

				$social_link_class .= $social_link_style . ' ' . $social_link_color;

				$label_class = 'screen-reader-text';
				$show_label  = isset( $instance['show_label'] ) ? $instance['show_label'] : $this->settings['show_label']['std'];
				if ( $show_label ) {
					$label_class        = 'em-social-menu-label';
					$social_link_class .= ' has-social-menu-label';
					$column             = isset( $instance['column'] ) ? $instance['column'] : $this->settings['column']['std'];
					$social_link_class .= ' em-flex-col-' . $column;
				}

				wp_nav_menu(
					array(
						'theme_location'  => 'social-menu',
						'container_class' => 'social-navigation',
						'fallback_cb'     => false,
						'depth'           => 1,
						'menu_class'      => $social_link_class,
						'link_before'     => '<span class="' . $label_class . '">',
						'link_after'      => '</span>',
					)
				);
			} else {
				esc_html_e( 'Social menu is not set. You need to create menu and assign it to Social Menu on Menu Settings.', 'eximious-magazine' );
			}
			?>
		</div>
		<?php

		do_action( 'eximious_magazine_after_social_menu' );

		$this->widget_end( $args );

		echo ob_get_clean();
	}
}
