<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Eximious_Magazine_Recent_Posts extends Eximious_Magazine_Widget_Base {

	/**
	 * Constructor.
	 */
	public function __construct() {

		$this->widget_cssclass    = 'widget_eximious_magazine_recent_posts';
		$this->widget_description = __( 'Displays recent posts with an image', 'eximious-magazine' );
		$this->widget_id          = 'eximious_magazine_recent_posts_with_image';
		$this->widget_name        = __( 'Eximious Magazine: Recent Posts', 'eximious-magazine' );
		$this->settings           = array(
			'title'                   => array(
				'type'  => 'text',
				'label' => __( 'Title', 'eximious-magazine' ),
			),
			'post_settings_heading'   => array(
				'type'  => 'heading',
				'label' => __( 'Post Settings', 'eximious-magazine' ),
			),
			'category'                => array(
				'type'  => 'dropdown-taxonomies',
				'label' => __( 'Select Category', 'eximious-magazine' ),
				'desc'  => __( 'Leave empty if you don\'t want the posts to be category specific', 'eximious-magazine' ),
				'args'  => array(
					'taxonomy'        => 'category',
					'class'           => 'widefat',
					'hierarchical'    => true,
					'show_count'      => 1,
					'show_option_all' => __( '&mdash; Select &mdash;', 'eximious-magazine' ),
				),
			),
			'number'                  => array(
				'type'  => 'number',
				'step'  => 1,
				'min'   => 1,
				'max'   => '',
				'std'   => 3,
				'label' => __( 'Number of posts to show', 'eximious-magazine' ),
			),
			'orderby'                 => array(
				'type'    => 'select',
				'std'     => 'date',
				'label'   => __( 'Order by', 'eximious-magazine' ),
				'options' => array(
					'date'  => __( 'Date', 'eximious-magazine' ),
					'ID'    => __( 'ID', 'eximious-magazine' ),
					'title' => __( 'Title', 'eximious-magazine' ),
					'rand'  => __( 'Random', 'eximious-magazine' ),
				),
			),
			'order'                   => array(
				'type'    => 'select',
				'std'     => 'desc',
				'label'   => __( 'Order', 'eximious-magazine' ),
				'options' => array(
					'asc'  => __( 'ASC', 'eximious-magazine' ),
					'desc' => __( 'DESC', 'eximious-magazine' ),
				),
			),
			'meta_settings_heading'   => array(
				'type'  => 'heading',
				'label' => __( 'Post Meta Settings', 'eximious-magazine' ),
			),
			'post_meta'               => array(
				'type'    => 'multi-checkbox',
				'label'   => __( 'Post Meta', 'eximious-magazine' ),
				'options' => array(
					'author'    => __( 'Author', 'eximious-magazine' ),
					'read_time' => __( 'Post Read Time', 'eximious-magazine' ),
					'date'      => __( 'Date', 'eximious-magazine' ),
					'comment'   => __( 'Comment', 'eximious-magazine' ),
				),
				'std'     => array( 'date' ),
			),
			'date_format'             => array(
				'type'    => 'select',
				'label'   => __( 'Date Format', 'eximious-magazine' ),
				'desc'    => __( 'Make sure to select Date from above for this to work.', 'eximious-magazine' ),
				'options' => array(
					'format_1' => __( 'Times Ago', 'eximious-magazine' ),
					'format_2' => __( 'Default Format', 'eximious-magazine' ),
				),
				'std'     => 'format_1',
			),
			'author_image'            => array(
				'type'  => 'checkbox',
				'label' => __( 'Show Author Image', 'eximious-magazine' ),
				'desc'  => __( 'Make sure to select Author from above for this to work.', 'eximious-magazine' ),
				'std'   => false,
			),
			'widget_settings_heading' => array(
				'type'  => 'heading',
				'label' => __( 'Widget Settings', 'eximious-magazine' ),
			),
			'style'                   => array(
				'type'    => 'select',
				'label'   => __( 'Style', 'eximious-magazine' ),
				'options' => array(
					'style_1' => __( 'Default', 'eximious-magazine' ),
					'style_2' => __( 'Circled Image', 'eximious-magazine' ),
					'style_3' => __( 'With Background', 'eximious-magazine' ),
				),
				'std'     => 'style_1',
			),
			'enable_post_format_icon' => array(
				'type'  => 'checkbox',
				'label' => __( 'Enable Post Format Icon', 'eximious-magazine' ),
				'std'   => false,
			),
			'invert_list_post'        => array(
				'type'  => 'checkbox',
				'label' => __( 'Invert List Post', 'eximious-magazine' ),
				'std'   => false,
			),
			'title_limit'             => array(
				'type'    => 'select',
				'label'   => __( 'Post Title Limit', 'eximious-magazine' ),
				'options' => eximious_magazine_get_title_limit_choices(),
				'std'     => '',
			),
			'enable_item_separator'   => array(
				'type'  => 'checkbox',
				'label' => __( 'Enable Item Separator', 'eximious-magazine' ),
				'std'   => false,
			),
			'hide_list_image'         => array(
				'type'  => 'checkbox',
				'label' => __( 'Hide List Post Image', 'eximious-magazine' ),
				'std'   => false,
			),
		);

		parent::__construct();
	}

	/**
	 * Query the posts and return them.
	 *
	 * @param  array $args
	 * @param  array $instance
	 * @return WP_Query
	 */
	public function get_posts( $args, $instance ) {
		$number  = ! empty( $instance['number'] ) ? absint( $instance['number'] ) : $this->settings['number']['std'];
		$orderby = ! empty( $instance['orderby'] ) ? sanitize_text_field( $instance['orderby'] ) : $this->settings['orderby']['std'];
		$order   = ! empty( $instance['order'] ) ? sanitize_text_field( $instance['order'] ) : $this->settings['order']['std'];

		$query_args = array(
			'posts_per_page'      => $number,
			'post_status'         => 'publish',
			'no_found_rows'       => 1,
			'orderby'             => $orderby,
			'order'               => $order,
			'ignore_sticky_posts' => 1,
		);

		if ( ! empty( $instance['category'] ) && -1 != $instance['category'] && 0 != $instance['category'] ) {
			$query_args['tax_query'][] = array(
				'taxonomy' => 'category',
				'field'    => 'term_id',
				'terms'    => $instance['category'],
			);
		}

		return new WP_Query( apply_filters( 'eximious_magazine_recent_posts_query_args', $query_args ) );
	}

	/**
	 * Output widget.
	 *
	 * @see WP_Widget
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {

		ob_start();

		if ( ( $posts = $this->get_posts( $args, $instance ) ) && $posts->have_posts() ) {
			$this->widget_start( $args, $instance );

			do_action( 'eximious_magazine_before_recent_posts_with_image' );

			$class                         = '';
			$style                         = isset( $instance['style'] ) ? $instance['style'] : $this->settings['style']['std'];
			$widget_class                  = $style;
			$enable_post_format_icon       = isset( $instance['enable_post_format_icon'] ) ? $instance['enable_post_format_icon'] : $this->settings['enable_post_format_icon']['std'];
			$title_limit                   = isset( $instance['title_limit'] ) ? $instance['title_limit'] : $this->settings['title_limit']['std'];
			$enabled_post_meta             = isset( $instance['post_meta'] ) ? $instance['post_meta'] : $this->settings['post_meta']['std'];
			$meta_settings['date_format']  = isset( $instance['date_format'] ) ? $instance['date_format'] : $this->settings['date_format']['std'];
			$meta_settings['author_image'] = isset( $instance['author_image'] ) ? $instance['author_image'] : $this->settings['author_image']['std'];

			// Inverted Item.
			$invert_list_post = isset( $instance['invert_list_post'] ) ? $instance['invert_list_post'] : $this->settings['invert_list_post']['std'];
			if ( $invert_list_post ) {
				$widget_class .= ' saga-inverted-item';
			}
			// Item Separator.
			$item_separator = isset( $instance['enable_item_separator'] ) ? $instance['enable_item_separator'] : $this->settings['enable_item_separator']['std'];
			if ( $item_separator ) {
				$widget_class .= ' saga-item-sep';
			}
			// Hide List Image.
			$show_image      = true;
			$hide_list_image = isset( $instance['hide_list_image'] ) ? $instance['hide_list_image'] : $this->settings['hide_list_image']['std'];
			if ( $hide_list_image ) {
				$widget_class .= ' saga-hidden-post-image';
				$show_image    = false;
			}
			if ( 'style_1' === $style ) {
				$class = ' img-animate-zoom';
			}
			if ( 'style_3' === $style ) {
				$class = ' eximious-magazine-card-box img-animate-zoom';
			}

			?>

			<div class="eximious-magazine-recent-posts-widget <?php echo esc_attr( $widget_class ); ?>">
				<div class="eximious-magazine-list-posts">
					<?php
					while ( $posts->have_posts() ) :
						$posts->the_post();
						?>
							<div class="article-block-wrapper<?php echo esc_attr( $class ); ?>">
								<?php
								if ( $show_image && has_post_thumbnail() ) {
									?>
									<div class="article-image">
										<a href="<?php the_permalink(); ?>">
											<?php
											if ( $enable_post_format_icon ) {
												eximious_magazine_post_format_icon( 'center' );
											}
											?>
											<?php
											the_post_thumbnail(
												'thumbnail',
												array(
													'alt' => the_title_attribute(
														array(
															'echo' => false,
														)
													),
												)
											);
											?>
										</a>
									</div>
									<?php
								}
								?>
								<div class="article-details">
									<h3 class="entry-title no-margin">
										<a href="<?php the_permalink(); ?>" class="text-decoration-none color-accent-hover eximious-magazine-limit-lines <?php echo esc_attr( $title_limit ); ?>">
											<?php the_title(); ?>
										</a>
									</h3>
									<?php eximious_magazine_post_meta_info( $enabled_post_meta, $meta_settings ); ?>
								</div>
							</div>
						<?php
					endwhile;
					wp_reset_postdata();
					?>
				</div>
			</div>
			<?php

			do_action( 'eximious_magazine_after_recent_posts_with_image' );

			$this->widget_end( $args );
		}

		echo ob_get_clean();
	}

}
