<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Eximious_Magazine_Posts_Carousel extends Eximious_Magazine_Widget_Base {

	/**
	 * Constructor.
	 */
	public function __construct() {

		$this->widget_cssclass    = 'widget_eximious_magazine_posts_carousel';
		$this->widget_description = __( 'Displays posts in carousel', 'eximious-magazine' );
		$this->widget_id          = 'eximious_magazine_posts_carousel';
		$this->widget_name        = __( 'Eximious Magazine: Posts Carousel', 'eximious-magazine' );
		$this->settings           = array(
			'title'                     => array(
				'type'  => 'text',
				'label' => __( 'Title', 'eximious-magazine' ),
			),
			'post_settings_heading'     => array(
				'type'  => 'heading',
				'label' => __( 'Post Settings', 'eximious-magazine' ),
			),
			'category'                  => array(
				'type'  => 'dropdown-taxonomies',
				'label' => __( 'Select Category', 'eximious-magazine' ),
				'desc'  => __( 'Leave empty if you don\'t want the posts to be category specific', 'eximious-magazine' ),
				'args'  => array(
					'taxonomy'        => 'category',
					'class'           => 'widefat',
					'hierarchical'    => true,
					'show_count'      => 1,
					'show_option_all' => __( '&mdash; Select &mdash;', 'eximious-magazine' ),
				),
			),
			'number'                    => array(
				'type'  => 'number',
				'step'  => 1,
				'min'   => 1,
				'max'   => '',
				'std'   => 5,
				'label' => __( 'Number of posts to show', 'eximious-magazine' ),
			),
			'orderby'                   => array(
				'type'    => 'select',
				'std'     => 'date',
				'label'   => __( 'Order by', 'eximious-magazine' ),
				'options' => array(
					'date'  => __( 'Date', 'eximious-magazine' ),
					'ID'    => __( 'ID', 'eximious-magazine' ),
					'title' => __( 'Title', 'eximious-magazine' ),
					'rand'  => __( 'Random', 'eximious-magazine' ),
				),
			),
			'order'                     => array(
				'type'    => 'select',
				'std'     => 'desc',
				'label'   => __( 'Order', 'eximious-magazine' ),
				'options' => array(
					'asc'  => __( 'ASC', 'eximious-magazine' ),
					'desc' => __( 'DESC', 'eximious-magazine' ),
				),
			),
			'meta_settings_heading'     => array(
				'type'  => 'heading',
				'label' => __( 'Post Meta Settings', 'eximious-magazine' ),
			),
			'post_meta'                 => array(
				'type'    => 'multi-checkbox',
				'label'   => __( 'Post Meta', 'eximious-magazine' ),
				'options' => array(
					'author'    => __( 'Author', 'eximious-magazine' ),
					'read_time' => __( 'Post Read Time', 'eximious-magazine' ),
					'date'      => __( 'Date', 'eximious-magazine' ),
					'comment'   => __( 'Comment', 'eximious-magazine' ),
				),
				'std'     => array(),
			),
			'date_format'               => array(
				'type'    => 'select',
				'label'   => __( 'Date Format', 'eximious-magazine' ),
				'desc'    => __( 'Make sure to select Date from above for this to work.', 'eximious-magazine' ),
				'options' => array(
					'format_1' => __( 'Times Ago', 'eximious-magazine' ),
					'format_2' => __( 'Default Format', 'eximious-magazine' ),
				),
				'std'     => 'format_1',
			),
			'author_image'              => array(
				'type'  => 'checkbox',
				'label' => __( 'Show Author Image', 'eximious-magazine' ),
				'desc'  => __( 'Make sure to select Author from above for this to work.', 'eximious-magazine' ),
				'std'   => false,
			),
			'category_settings_heading' => array(
				'type'  => 'heading',
				'label' => __( 'Category Settings', 'eximious-magazine' ),
			),
			'show_category'             => array(
				'type'  => 'checkbox',
				'label' => __( 'Show Category', 'eximious-magazine' ),
				'std'   => true,
			),
			'category_color'            => array(
				'type'    => 'select',
				'label'   => __( 'Category Color', 'eximious-magazine' ),
				'options' => eximious_magazine_get_category_color_display(),
				'std'     => 'as_bg',
			),
			'category_style'            => array(
				'type'    => 'select',
				'label'   => __( 'Category Style', 'eximious-magazine' ),
				'options' => eximious_magazine_get_category_styles(),
				'std'     => 'style_2',
			),
			'no_of_category'            => array(
				'type'  => 'number',
				'step'  => 1,
				'min'   => 0,
				'max'   => '',
				'std'   => 1,
				'label' => __( 'Number of Category to Display', 'eximious-magazine' ),
			),
			'widget_settings_heading'   => array(
				'type'  => 'heading',
				'label' => __( 'Widget Settings', 'eximious-magazine' ),
			),
			'style'                     => array(
				'type'    => 'select',
				'label'   => __( 'Display Style', 'eximious-magazine' ),
				'options' => array(
					'style_1' => __( 'Style 1', 'eximious-magazine' ),
					'style_2' => __( 'Style 2', 'eximious-magazine' ),
				),
				'std'     => 'style_1',
			),
			'margin'                    => array(
				'type'  => 'number',
				'step'  => 1,
				'min'   => 0,
				'max'   => 100,
				'std'   => 10,
				'label' => __( 'Carousel margin', 'eximious-magazine' ),
			),
			'autoplay'                  => array(
				'type'  => 'checkbox',
				'label' => __( 'Autoplay', 'eximious-magazine' ),
				'std'   => false,
			),
			'column'                    => array(
				'type'  => 'number',
				'step'  => 1,
				'min'   => 1,
				'max'   => 5,
				'std'   => 3,
				'label' => __( 'Column', 'eximious-magazine' ),
			),
			'enable_post_format_icon'   => array(
				'type'  => 'checkbox',
				'label' => __( 'Enable Post Format Icon', 'eximious-magazine' ),
				'std'   => false,
			),
			'title_limit'               => array(
				'type'    => 'select',
				'label'   => __( 'Post Title Limit', 'eximious-magazine' ),
				'options' => eximious_magazine_get_title_limit_choices(),
				'std'     => '',
			),
		);

		parent::__construct();
	}

	/**
	 * Query the posts and return them.
	 *
	 * @param  array $args
	 * @param  array $instance
	 * @return WP_Query
	 */
	public function get_posts( $args, $instance ) {
		$number  = ! empty( $instance['number'] ) ? absint( $instance['number'] ) : $this->settings['number']['std'];
		$orderby = ! empty( $instance['orderby'] ) ? sanitize_title( $instance['orderby'] ) : $this->settings['orderby']['std'];
		$order   = ! empty( $instance['order'] ) ? sanitize_title( $instance['order'] ) : $this->settings['order']['std'];

		$query_args = array(
			'posts_per_page'      => $number,
			'post_status'         => 'publish',
			'no_found_rows'       => 1,
			'orderby'             => $orderby,
			'order'               => $order,
			'ignore_sticky_posts' => 1,
		);

		if ( ! empty( $instance['category'] ) && -1 != $instance['category'] && 0 != $instance['category'] ) {
			$query_args['tax_query'][] = array(
				'taxonomy' => 'category',
				'field'    => 'term_id',
				'terms'    => $instance['category'],
			);
		}

		return new WP_Query( apply_filters( 'eximious_magazine_posts_carousel_query_args', $query_args ) );
	}

	/**
	 * Output widget.
	 *
	 * @see WP_Widget
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {

		ob_start();

		if ( ( $posts = $this->get_posts( $args, $instance ) ) && $posts->have_posts() ) {
			$this->widget_start( $args, $instance );

			do_action( 'eximious_magazine_before_posts_carousel' );

			$overlay = '';
			$display_style = isset( $instance['style'] ) ? $instance['style'] : $this->settings['style']['std'];
			if ( 'style_2' == $display_style ) {  
				$overlay = '<span aria-hidden="true" class="eximious-magazine-block-overlay overlay_w_gradient"></span>';
			}

			$margin         = isset( $instance['margin'] ) ? absint( $instance['margin'] ) : $this->settings['margin']['std'];
			$autoplay       = isset( $instance['autoplay'] ) ? $instance['autoplay'] : $this->settings['autoplay']['std'];
			$column         = isset( $instance['column'] ) ? absint( $instance['column'] ) : $this->settings['column']['std'];
			$display_style .= " column-$column";

			// Build attributes.
			$data_slider        = array();
			$data_slider_option = '';

			$data_slider[] = '"spaceBetween": ' . $margin . '';

			if ( $autoplay ) :
				$data_slider[] = '"autoplay": {"delay": 5000}';
			endif;

			if ( $column == 2 ) {
				$data_slider[] = '"breakpoints": {"576": {"slidesPerView": 2}}';
			} elseif ( $column == 3 ) {
				$data_slider[] = '"breakpoints": {"576": {"slidesPerView": 2}, "768": {"slidesPerView": 3} }';
			} elseif ( $column == 4 ) {
				$data_slider[] = '"breakpoints": {"576": {"slidesPerView": 2}, "768": {"slidesPerView": 3}, "992": {"slidesPerView": 4} }';
			} elseif ( $column == 5 ) {
				$data_slider[] = '"breakpoints": {"576": {"slidesPerView": 2}, "768": {"slidesPerView": 3}, "992": {"slidesPerView": 4}, "1200": {"slidesPerView": 5} }';
			}

			if ( ! empty( $data_slider ) ) :
				$data_slider_option = trim( implode( ', ', $data_slider ) );
			endif;

			$show_category = isset( $instance['show_category'] ) ? $instance['show_category'] : $this->settings['show_category']['std'];
			if ( $show_category ) {
				$cat_style = isset( $instance['category_style'] ) ? $instance['category_style'] : $this->settings['category_style']['std'];
				$color     = isset( $instance['category_color'] ) ? $instance['category_color'] : $this->settings['category_color']['std'];
				$limit     = isset( $instance['no_of_category'] ) ? $instance['no_of_category'] : $this->settings['no_of_category']['std'];
			}
			$enabled_post_meta             = isset( $instance['post_meta'] ) ? $instance['post_meta'] : $this->settings['post_meta']['std'];
			$meta_settings['date_format']  = isset( $instance['date_format'] ) ? $instance['date_format'] : $this->settings['date_format']['std'];
			$meta_settings['author_image'] = isset( $instance['author_image'] ) ? $instance['author_image'] : $this->settings['author_image']['std'];
			$title_limit                   = isset( $instance['title_limit'] ) ? $instance['title_limit'] : $this->settings['title_limit']['std'];
			$enable_post_format_icon       = isset( $instance['enable_post_format_icon'] ) ? $instance['enable_post_format_icon'] : $this->settings['enable_post_format_icon']['std'];
			?>

			<div class="eximious-magazine-slider-wrapper-block as_carousel <?php echo esc_attr( $display_style ); ?>">
				<div class="swiper" data-slider='{<?php echo $data_slider_option; ?>}'>
					<div class="swiper-wrapper">
						<?php
						while ( $posts->have_posts() ) :
							$posts->the_post();
							if ( has_post_thumbnail() ) {
								?>
								<div class="swiper-slide">
									<div class="article-block-wrapper img-animate-zoom">
										<div class="article-image">
											<a href="<?php the_permalink(); ?>">
												<?php echo $overlay;?>
												<?php
												if ( $enable_post_format_icon ) {
													eximious_magazine_post_format_icon( 'left' );
												}
												?>
												<?php
												the_post_thumbnail(
													'eximious-magazine-large-img',
													array(
														'alt' => the_title_attribute(
															array(
																'echo' => false,
															)
														),
													)
												);
												?>
											</a>
										</div>
										<div class="article-details eximious-magazine-card-box">
											<?php
											if ( $show_category ) {
												echo '<div class="article-cat-info">';
												eximious_magazine_post_categories( $cat_style, $color, $limit );
												echo '</div>';
											}
											?>
											<h3 class="article-title no-margin">
												<a href="<?php the_permalink(); ?>" class="text-decoration-none eximious-magazine-limit-lines <?php echo esc_attr( $title_limit ); ?>">
													<?php the_title(); ?>
												</a>
											</h3>
											<?php eximious_magazine_post_meta_info( $enabled_post_meta, $meta_settings ); ?>
										</div>
									</div>
								</div>
								<?php
							}
						endwhile;
						wp_reset_postdata();
						?>
					</div>
					<div class="swiper-button-next"></div>
					<div class="swiper-button-prev"></div>
				</div>
			</div>

			<?php

			do_action( 'eximious_magazine_after_posts_carousel' );

			$this->widget_end( $args );
		}

		echo ob_get_clean();
	}

}
