<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Eximious_Magazine_Post_Categories_Grid extends Eximious_Magazine_Widget_Base {

	/**
	 * Constructor.
	 */
	public function __construct() {

		$this->widget_cssclass    = 'eximious_magazine_post_categories_grid_widget';
		$this->widget_description = __( 'Displays post categories with image in grid', 'eximious-magazine' );
		$this->widget_id          = 'eximious_magazine_post_categories_grid_widget';
		$this->widget_name        = __( 'Eximious Magazine: Post Categories Grid', 'eximious-magazine' );

		$post_categories = array(); 
		$categories      = get_categories(
			array(
				'orderby' => 'name',
				'order'   => 'ASC',
			)
		);

		if ( ! empty( $categories ) ) {
			foreach ( $categories as $cat ) {
				$post_categories[ $cat->term_id ] = $cat->name;
			}
		}

		$this->settings = array(
			'title'           => array(
				'type'  => 'text',
				'label' => __( 'Title', 'eximious-magazine' ),
			),
			'categories'      => array(
				'type'    => 'multi-checkbox',
				'label'   => __( 'Select Categories', 'eximious-magazine' ),
				'options' => $post_categories,
			),
			'no_of_column'    => array(
				'type'  => 'number',
				'step'  => 1,
				'min'   => 1,
				'max'   => 5,
				'std'   => 2,
				'label' => __( 'Number of Column', 'eximious-magazine' ),
			),
			'display_style'   => array(
				'type'    => 'select',
				'label'   => __( 'Display Style', 'eximious-magazine' ),
				'options' => array(
					'style_1' => __( 'Default', 'eximious-magazine' ),
					'style_2' => __( 'Category on Bottom', 'eximious-magazine' ),
					'style_3' => __( 'Category on Center', 'eximious-magazine' ),
					'style_4' => __( 'Small Height', 'eximious-magazine' ),
				),
				'std'     => 'style_1',
			),
			'overlay_color'   => array(
				'type'  => 'color',
				'label' => __( 'Overlay Color', 'eximious-magazine' ),
				'std'   => '#000000',
			),
			'overlay_opacity' => array(
				'type'  => 'number',
				'step'  => 10,
				'min'   => 0,
				'max'   => 100,
				'std'   => 50,
				'label' => __( 'Overlay Opacity', 'eximious-magazine' ),
			),
		);

		parent::__construct();
	}

	/**
	 * Output widget.
	 *
	 * @see WP_Widget
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {

		ob_start();

		if ( ! empty( $instance['categories'] ) ) {

			$this->widget_start( $args, $instance );

			do_action( 'eximious_magazine_before_post_cat_grid' );

			$column = $instance['no_of_column'];
			$style  = $instance['display_style'];

			$col_class = 'row row-cols-1 row-cols-sm-2 g-3';

			if ( 2 == $column ) {
				$col_class .= ' eximious-magazine-grid-2';
			} elseif ( 3 == $column ) {
				$col_class .= ' row-cols-md-2 row-cols-lg-3 eximious-magazine-grid-3';
			} elseif ( 4 == $column ) {
				$col_class .= ' row-cols-md-2 row-cols-xl-4 eximious-magazine-grid-4';
			} elseif ( 5 == $column ) {
				$col_class .= ' row-cols-md-3 row-cols-lg-4 row-cols-xl-5 eximious-magazine-grid-5';
			} else {
				$col_class = ' row row-cols-1 g-3';
			}

			$img_size = 'eximious-magazine-large-img';

			?>

			<div class="eximious-magazine-posts-categories-grid-widget <?php echo esc_attr( $style ); ?>">
				<div class="<?php echo esc_attr( $col_class ); ?>">
					<?php
					foreach ( $instance['categories'] as $category ) {
						$cat_info = get_category( $category );
						if ( ! empty( $cat_info ) && ! is_wp_error( $cat_info ) ) {
							$term_link        = get_category_link( $category );
							$thumbnail_id     = get_term_meta( $category, 'thumbnail_id', true );
							$image_attributes = wp_get_attachment_image_src( $thumbnail_id, $img_size );
							if ( $image_attributes ) {
								$style  = 'background-color:' . $instance['overlay_color'] . ';';
								$style .= 'opacity:' . ( $instance['overlay_opacity'] / 100 ) . ';';
								?>
								<div class="col">
									<div class="saga-block-item-w-overlay img-animate-zoom">
										<div class="saga-block-image-w-overlay">
											<a href="<?php echo esc_url( $term_link ); ?>" class="">
											<span aria-hidden="true" class="eximious-magazine-block-overlay" style="<?php echo esc_attr( $style ); ?>"></span>
												<img src="<?php echo esc_url( $image_attributes[0] ); ?>">
											</a>
										</div>
										<div class="saga-block-overlay-content">
											<h3 class="saga-block-overlay-title">
												<a href="<?php echo esc_url( $term_link ); ?>" class="text-decoration-none">
													<?php echo esc_html( $cat_info->name ); ?>
												</a>
											</h3>
										</div>
									</div>
								</div>
								<?php
							}
						}
					}
					?>
				</div>
			</div>
			<?php

			do_action( 'eximious_magazine_after_post_cat_grid' );

			$this->widget_end( $args );

		}

		echo ob_get_clean();
	}

}
