<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Eximious_Magazine_Popular_Posts extends Eximious_Magazine_Widget_Base {
	/**
	 * Constructor.
	 */
	public function __construct() {

		$this->widget_cssclass    = 'widget_eximious_magazine_popular_posts';
		$this->widget_description = __( 'Displays popular posts with an image', 'eximious-magazine' );
		$this->widget_id          = 'eximious_magazine_popular_posts';
		$this->widget_name        = __( 'Eximious Magazine: Popular Posts', 'eximious-magazine' );
		$this->settings           = array(
			'title'                   => array(
				'type'  => 'text',
				'label' => __( 'Title', 'eximious-magazine' ),
			),
			'post_settings_heading'   => array(
				'type'  => 'heading',
				'label' => __( 'Post Settings', 'eximious-magazine' ),
			),
			'category'                => array(
				'type'  => 'dropdown-taxonomies',
				'label' => __( 'Select Category', 'eximious-magazine' ),
				'desc'  => __( 'Leave empty if you don\'t want the posts to be category specific', 'eximious-magazine' ),
				'args'  => array(
					'taxonomy'        => 'category',
					'class'           => 'widefat',
					'hierarchical'    => true,
					'show_count'      => 1,
					'show_option_all' => __( '&mdash; Select &mdash;', 'eximious-magazine' ),
				),
			),
			'number'                  => array(
				'type'  => 'number',
				'step'  => 1,
				'min'   => 1,
				'max'   => '',
				'std'   => 5,
				'label' => __( 'Number of posts to show', 'eximious-magazine' ),
			),
			'orderby'                 => array(
				'type'    => 'select',
				'std'     => 'comment_count',
				'label'   => __( 'Order by', 'eximious-magazine' ),
				'options' => array(
					'date'          => __( 'Date', 'eximious-magazine' ),
					'ID'            => __( 'ID', 'eximious-magazine' ),
					'title'         => __( 'Title', 'eximious-magazine' ),
					'rand'          => __( 'Random', 'eximious-magazine' ),
					'comment_count' => __( 'Comment Count', 'eximious-magazine' ),
				),
			),
			'order'                   => array(
				'type'    => 'select',
				'std'     => 'desc',
				'label'   => __( 'Order', 'eximious-magazine' ),
				'options' => array(
					'asc'  => __( 'ASC', 'eximious-magazine' ),
					'desc' => __( 'DESC', 'eximious-magazine' ),
				),
			),
			'meta_settings_heading'   => array(
				'type'  => 'heading',
				'label' => __( 'Post Meta Settings', 'eximious-magazine' ),
			),
			'post_meta'               => array(
				'type'    => 'multi-checkbox',
				'label'   => __( 'Post Meta', 'eximious-magazine' ),
				'options' => array(
					'author'    => __( 'Author', 'eximious-magazine' ),
					'read_time' => __( 'Post Read Time', 'eximious-magazine' ),
					'date'      => __( 'Date', 'eximious-magazine' ),
					'comment'   => __( 'Comment', 'eximious-magazine' ),
				),
				'std'     => array( 'date' ),
			),
			'date_format'             => array(
				'type'    => 'select',
				'label'   => __( 'Date Format', 'eximious-magazine' ),
				'desc'    => __( 'Make sure to select Date from above for this to work.', 'eximious-magazine' ),
				'options' => array(
					'format_1' => __( 'Times Ago', 'eximious-magazine' ),
					'format_2' => __( 'Default Format', 'eximious-magazine' ),
				),
				'std'     => 'format_1',
			),
			'author_image'            => array(
				'type'  => 'checkbox',
				'label' => __( 'Show Author Image', 'eximious-magazine' ),
				'desc'  => __( 'Make sure to select Author from above for this to work.', 'eximious-magazine' ),
				'std'   => false,
			),
			'widget_settings_heading' => array(
				'type'  => 'heading',
				'label' => __( 'Widget Settings', 'eximious-magazine' ),
			),
			'post_counter_position'   => array(
				'type'    => 'select',
				'label'   => __( 'Post Counter Position', 'eximious-magazine' ),
				'options' => array(
					'center'       => __( 'Center', 'eximious-magazine' ),
					'top_left'     => __( 'Top Left', 'eximious-magazine' ),
					'top_right'    => __( 'Top Right', 'eximious-magazine' ),
					'bottom_left'  => __( 'Bottom Left', 'eximious-magazine' ),
					'bottom_right' => __( 'Bottom Right', 'eximious-magazine' ),
				),
				'std'     => 'center',
			),
			'style'                   => array(
				'type'    => 'select',
				'label'   => __( 'Style', 'eximious-magazine' ),
				'options' => array(
					'style_1' => __( 'Default', 'eximious-magazine' ),
					'style_2' => __( 'Circled Image', 'eximious-magazine' ),
					'style_3' => __( 'With Background', 'eximious-magazine' ),
				),
				'std'     => 'style_1',
			),
			'bg_overlay_color'        => array(
				'type'  => 'color',
				'label' => __( 'Overlay Color', 'eximious-magazine' ),
				'std'   => '#000000',
			),
			'overlay_opacity'         => array(
				'type'  => 'number',
				'step'  => 10,
				'min'   => 0,
				'max'   => 100,
				'std'   => 50,
				'label' => __( 'Overlay Opacity', 'eximious-magazine' ),
			),
			'invert_list_post'        => array(
				'type'  => 'checkbox',
				'label' => __( 'Invert List Post', 'eximious-magazine' ),
				'std'   => false,
			),
			'title_limit'             => array(
				'type'    => 'select',
				'label'   => __( 'Post Title Limit', 'eximious-magazine' ),
				'options' => eximious_magazine_get_title_limit_choices(),
				'std'     => '',
			),
		);

		parent::__construct();
	}

	/**
	 * Query the posts and return them.
	 *
	 * @param  array $args
	 * @param  array $instance
	 * @return WP_Query
	 */
	public function get_posts( $args, $instance ) {
		$number  = ! empty( $instance['number'] ) ? absint( $instance['number'] ) : $this->settings['number']['std'];
		$orderby = ! empty( $instance['orderby'] ) ? sanitize_text_field( $instance['orderby'] ) : $this->settings['orderby']['std'];
		$order   = ! empty( $instance['order'] ) ? sanitize_text_field( $instance['order'] ) : $this->settings['order']['std'];

		$query_args = array(
			'posts_per_page'      => $number,
			'post_status'         => 'publish',
			'no_found_rows'       => 1,
			'orderby'             => $orderby,
			'order'               => $order,
			'ignore_sticky_posts' => 1,
		);

		if ( ! empty( $instance['category'] ) && -1 !== $instance['category'] && 0 !== $instance['category'] ) {
			$query_args['tax_query'][] = array(
				'taxonomy' => 'category',
				'field'    => 'term_id',
				'terms'    => $instance['category'],
			);
		}

		return new WP_Query( apply_filters( 'eximious_magazine_popular_posts_query_args', $query_args ) );
	}

	/**
	 * Output widget.
	 *
	 * @see WP_Widget
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {

		ob_start();

		if ( ( $posts = $this->get_posts( $args, $instance ) ) && $posts->have_posts() ) {
			$this->widget_start( $args, $instance );

			do_action( 'eximious_magazine_before_popular_posts_with_image' );

			$style            = $instance['style'];
			$widget_class     = $style;
			$title_limit      = isset( $instance['title_limit'] ) ? $instance['title_limit'] : $this->settings['title_limit']['std'];
			$invert_list_post = isset( $instance['invert_list_post'] ) ? $instance['invert_list_post'] : $this->settings['invert_list_post']['std'];
			if ( $invert_list_post ) {
				$widget_class .= ' saga-inverted-item';
			}
			$enabled_post_meta             = isset( $instance['post_meta'] ) ? $instance['post_meta'] : $this->settings['post_meta']['std'];
			$meta_settings['date_format']  = isset( $instance['date_format'] ) ? $instance['date_format'] : $this->settings['date_format']['std'];
			$meta_settings['author_image'] = isset( $instance['author_image'] ) ? $instance['author_image'] : $this->settings['author_image']['std'];
			?>

			<div class="eximious-magazine-popular-posts-widget <?php echo esc_attr( $widget_class ); ?>">
				<div class="eximious-magazine-list-posts">
					<?php
					$counter = 1;
					$class   = '';

					$counter_position = $instance['post_counter_position'];

					$horizontal_pos = 0;
					$vertical_pos   = 0;

					if ( 'style_1' === $style ) {
						$class = ' img-animate-zoom';
					}

					if ( 'style_2' === $style ) {
						$horizontal_pos = '1rem';
					}

					if ( 'style_3' === $style ) {
						$class = ' eximious-magazine-card-box img-animate-zoom';
					}

					switch ( $counter_position ) {
						case 'top_left':
							$counter_style  = 'top:' . $vertical_pos . ';';
							$counter_style .= 'left:' . $horizontal_pos . ';';
							break;
						case 'top_right':
							$counter_style  = 'top:' . $vertical_pos . ';';
							$counter_style .= 'right:' . $horizontal_pos . ';';
							break;
						case 'bottom_left':
							$counter_style  = 'bottom:' . $vertical_pos . ';';
							$counter_style .= 'left:' . $horizontal_pos . ';';
							break;
						case 'bottom_right':
							$counter_style  = 'bottom:' . $vertical_pos . ';';
							$counter_style .= 'right:' . $horizontal_pos . ';';
							break;
						default:
							$counter_style = '';
					}

					$style  = 'background-color:' . $instance['bg_overlay_color'] . ';';
					$style .= 'opacity:' . ( $instance['overlay_opacity'] / 100 ) . ';';

					while ( $posts->have_posts() ) :
						$posts->the_post();
						?>
							<div class="article-block-wrapper<?php echo esc_attr( $class ); ?>">
								<?php if ( has_post_thumbnail() ) : ?>
									<div class="article-image">
										<a href="<?php the_permalink(); ?>">
											<span class="article-counter bg-accent" style="<?php echo esc_attr( $counter_style ); ?>"><?php echo esc_html( $counter ); ?></span>
											<span aria-hidden="true" class="eximious-magazine-block-overlay" style="<?php echo esc_attr( $style ); ?>"></span>
											<?php
											the_post_thumbnail(
												'thumbnail',
												array(
													'alt' => the_title_attribute(
														array(
															'echo' => false,
														)
													),
												)
											);
											?>
										</a>
									</div>
								<?php endif; ?>
								<div class="article-details">
									<h3 class="entry-title no-margin">
										<a href="<?php the_permalink(); ?>" class="text-decoration-none color-accent-hover eximious-magazine-limit-lines <?php echo esc_attr( $title_limit ); ?>">
											<?php the_title(); ?>
										</a>
									</h3>
									<?php eximious_magazine_post_meta_info( $enabled_post_meta, $meta_settings ); ?>
								</div>
							</div>
						<?php
						$counter++;
					endwhile;
					wp_reset_postdata();
					?>
				</div>
			</div>
			<?php

			do_action( 'eximious_magazine_after_popular_posts_with_image' );

			$this->widget_end( $args );
		}

		echo ob_get_clean();
	}

}
