<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Eximious_Magazine_Mailchimp_Form extends Eximious_Magazine_Widget_Base {

	/**
	 * Constructor.
	 */
	public function __construct() {
		 $this->widget_cssclass   = 'widget_eximious_magazine_mailchimp_form';
		$this->widget_description = __( 'Displays MailChimp form if you have any', 'eximious-magazine' );
		$this->widget_id          = 'eximious_magazine_mailchimp_form';
		$this->widget_name        = __( 'Eximious Magazine: MailChimp Form', 'eximious-magazine' );
		$this->settings           = array(
			'title'                      => array(
				'type'  => 'text',
				'label' => __( 'Widget Title', 'eximious-magazine' ),
			),
			'mailchimp_settings_heading' => array(
				'type'  => 'heading',
				'label' => __( 'Mailchimp Settings', 'eximious-magazine' ),
			),
			'mailchimp_title'            => array(
				'type'  => 'text',
				'label' => __( 'Mailchimp Title', 'eximious-magazine' ),
			),
			'desc'                       => array(
				'type'  => 'textarea',
				'label' => __( 'Description', 'eximious-magazine' ),
				'rows'  => 10,
			),
			'form_shortcode'             => array(
				'type'  => 'text',
				'label' => __( 'MailChimp Form Shortcode', 'eximious-magazine' ),
			),
			'widget_settings_heading'    => array(
				'type'  => 'heading',
				'label' => __( 'Widget Settings', 'eximious-magazine' ),
			),
			'style'                      => array(
				'type'    => 'select',
				'label'   => __( 'Style', 'eximious-magazine' ),
				'desc'  => __( 'For Inline Style, make sure to wrap elements, you want to display as inline, inside a single tag like "&lt;p&gt;" or "&lt;div&gt;"', 'eximious-magazine' ),
				'options' => array(
					'style_1' => __( 'Items Aligned Left', 'eximious-magazine' ),
					'style_2' => __( 'Items Aligned Center', 'eximious-magazine' ),
					'style_3' => __( 'Items Aligned Center + Wide Submit Button', 'eximious-magazine' ),
					'style_4' => __( 'Form Items Inline', 'eximious-magazine' ),
				),
				'std'     => 'style_1',
			),
			'enable_bg_color'            => array(
				'type'  => 'checkbox',
				'label' => __( 'Enable Background Color', 'eximious-magazine' ),
				'std'   => false,
			),
			'bg_color'                   => array(
				'type'  => 'color',
				'label' => __( 'Background Color', 'eximious-magazine' ),
				'std'   => '#000000',
				'desc'  => __( 'Will be overridden if used background image.', 'eximious-magazine' ),
			),
			'bg_image'                   => array(
				'type'  => 'image',
				'label' => __( 'Background Image', 'eximious-magazine' ),
				'desc'  => __( 'Don\'t upload any image if you do not want to show the background image.', 'eximious-magazine' ),
			),
			'enable_fixed_bg'            => array(
				'type'  => 'checkbox',
				'label' => __( 'Enable Fixed Background Image', 'eximious-magazine' ),
				'std'   => true,
			),
			'bg_overlay_color'           => array(
				'type'  => 'color',
				'label' => __( 'Overlay Color', 'eximious-magazine' ),
				'std'   => '#000000',
			),
			'overlay_opacity'            => array(
				'type'  => 'number',
				'step'  => 10,
				'min'   => 0,
				'max'   => 100,
				'std'   => 50,
				'label' => __( 'Overlay Opacity', 'eximious-magazine' ),
			),
			'height'                     => array(
				'type'  => 'number',
				'step'  => 1,
				'min'   => 150,
				'max'   => '',
				'std'   => 350,
				'label' => __( 'Height (px)', 'eximious-magazine' ),
				'desc'  => __( 'Works when there is either a background color or image.', 'eximious-magazine' ),
			),
		);
		parent::__construct();
	}

	/**
	 * Output widget.
	 *
	 * @see WP_Widget
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {
		if ( ! empty( $instance['form_shortcode'] ) ) {

			ob_start();

			$style         = '';
			$class         = $instance['style'];
			$image_enabled = false;

			$this->widget_start( $args, $instance );

			if ( $instance['enable_bg_color'] ) {
				$bg_color = isset( $instance['bg_color'] ) ? $instance['bg_color'] : $this->settings['bg_color']['std'];
				$style    = 'background-color:' . esc_attr( $bg_color ) . ';';
			}

			if ( ( $instance['bg_image'] && 0 != $instance['bg_image'] ) ) {
				$image_enabled = true;
				if ( $instance['enable_fixed_bg'] ) {
					$class .= ' eximious-magazine-bg-image eximious-magazine-bg-attachment-fixed';
				}
			}

			if ( $instance['enable_bg_color'] || $image_enabled ) {
				$height = isset( $instance['height'] ) ? $instance['height'] : $this->settings['height']['std'];
				$style  .= 'min-height:' . esc_attr( $height ) . 'px;';
				$class .= ' eximious-magazine-cover-block';
			}

			do_action( 'eximious_magazine_before_mailchimp' );

			?>
			
			<div class="eximious-magazine-mailchimp-widget <?php echo esc_attr( $class ); ?>" style="<?php echo esc_attr( $style ); ?>">

				<?php
				if ( $image_enabled ) {
					$overlay_style  = 'background-color:' . $instance['bg_overlay_color'] . ';';
					$overlay_style .= 'opacity:' . ( $instance['overlay_opacity'] / 100 ) . ';';
					?>
					<span aria-hidden="true" class="eximious-magazine-block-overlay" style="<?php echo esc_attr( $overlay_style ); ?>"></span>
					<?php echo wp_get_attachment_image( $instance['bg_image'], 'full' ); ?>
					<?php
				}
				?>
				<div class="eximious-magazine-mailchimp-inner-wrapper eximious-magazine-block-inner-wrapper">

					<?php if ( $instance['mailchimp_title'] ) : ?>
						<h3 class="mailchimp-title">
							<?php echo esc_html( $instance['mailchimp_title'] ); ?>
						</h3>
					<?php endif; ?>

					<?php if ( $instance['desc'] ) : ?>
						<div class="mailchimp-desc">
							<?php echo wpautop( wp_kses_post( $instance['desc'] ) ); ?>
						</div>
					<?php endif; ?>
					
					<?php echo do_shortcode( $instance['form_shortcode'] ); ?>

				</div>

			</div>

			<?php

			do_action( 'eximious_magazine_after_mailchimp' );

			$this->widget_end( $args );

			echo ob_get_clean();
		}
	}
}
