<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Eximious_Magazine_Heading extends Eximious_Magazine_Widget_Base {
	/**
	 * Constructor.
	 */
	public function __construct() {

		$this->widget_cssclass    = 'eximious_magazine_heading_widget';
		$this->widget_description = __( 'Displays widget heading style to match the theme styles. It helps if you\'re using blocks in widgets but want a heading style of the theme.', 'eximious-magazine' );
		$this->widget_id          = 'eximious_magazine_heading_widget';
		$this->widget_name        = __( 'Eximious Magazine: Heading', 'eximious-magazine' );
		$this->settings           = array(
			'title'                => array(
				'type'  => 'text',
				'label' => __( 'Title', 'eximious-magazine' ),
			),
			'heading_style'        => array(
				'type'    => 'select',
				'label'   => __( 'Heading Style', 'eximious-magazine' ),
				'options' => eximious_magazine_get_title_styles(),
				'std'     => 'style_1',
			),
			'heading_alignment'    => array(
				'type'    => 'select',
				'label'   => __( 'Heading Alignment', 'eximious-magazine' ),
				'options' => eximious_magazine_get_title_alignments(),
				'std'     => 'left',
			),
			'inverted_title_color' => array(
				'type'  => 'checkbox',
				'label' => __( 'Inverted Title Color', 'eximious-magazine' ),
				'desc'  => __( 'Can be used if you have dark background and want ligter color on the title.', 'eximious-magazine' ),
				'std'   => false,
			),
		);

		parent::__construct();
	}

	/**
	 * Output widget.
	 *
	 * @see WP_Widget
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {

		ob_start();

		$before_widget = $args['before_widget'];
		$after_widget  = $args['after_widget'];

		$wrapper_class  = $instance['heading_style'];
		$wrapper_class .= ' has-text-align-' . $instance['heading_alignment'];

		$inverted_title_color = isset( $instance['inverted_title_color'] ) ? $instance['inverted_title_color'] : $this->settings['inverted_title_color']['std'];

		if ( $inverted_title_color ) {
			$wrapper_class .= ' em-inverted-title-color';
		}

		echo wp_kses_post( $before_widget );

		if ( $title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base ) ) {
			?>
			<h2 class="heading-widget-title saga-element-header <?php echo esc_attr( $wrapper_class ); ?>">
				<span><?php echo esc_html( $title ); ?></span>
			</h2>
			<?php
		}

		echo wp_kses_post( $after_widget );

		echo ob_get_clean();
	}
}
