<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Eximious_Magazine_Grid_Posts extends Eximious_Magazine_Widget_Base {
	/**
	 * Constructor.
	 */
	public function __construct() {

		$this->widget_cssclass    = 'eximious_magazine_grid_posts_widget';
		$this->widget_description = __( 'Displays posts in grid style', 'eximious-magazine' );
		$this->widget_id          = 'eximious_magazine_double_column_posts';
		$this->widget_name        = __( 'Eximious Magazine: Grid Posts', 'eximious-magazine' );
		$this->settings           = array(
			'title'                     => array(
				'type'  => 'text',
				'label' => __( 'Title', 'eximious-magazine' ),
			),
			'post_settings_heading'     => array(
				'type'  => 'heading',
				'label' => __( 'Post Settings', 'eximious-magazine' ),
			),
			'category'                  => array(
				'type'  => 'dropdown-taxonomies',
				'label' => __( 'Select Category', 'eximious-magazine' ),
				'desc'  => __( 'Leave empty if you don\'t want the posts to be category specific', 'eximious-magazine' ),
				'args'  => array(
					'taxonomy'        => 'category',
					'class'           => 'widefat',
					'hierarchical'    => true,
					'show_count'      => 1,
					'show_option_all' => __( '&mdash; Select &mdash;', 'eximious-magazine' ),
				),
			),
			'number'                    => array(
				'type'  => 'number',
				'step'  => 1,
				'min'   => 1,
				'max'   => '',
				'std'   => 6,
				'label' => __( 'Number of posts to show', 'eximious-magazine' ),
			),
			'orderby'                   => array(
				'type'    => 'select',
				'std'     => 'date',
				'label'   => __( 'Order By', 'eximious-magazine' ),
				'options' => array(
					'date'  => __( 'Date', 'eximious-magazine' ),
					'ID'    => __( 'ID', 'eximious-magazine' ),
					'title' => __( 'Title', 'eximious-magazine' ),
					'rand'  => __( 'Random', 'eximious-magazine' ),
				),
			),
			'order'                     => array(
				'type'    => 'select',
				'std'     => 'desc',
				'label'   => __( 'Order', 'eximious-magazine' ),
				'options' => array(
					'asc'  => __( 'ASC', 'eximious-magazine' ),
					'desc' => __( 'DESC', 'eximious-magazine' ),
				),
			),
			'meta_settings_heading'     => array(
				'type'  => 'heading',
				'label' => __( 'Post Meta Settings', 'eximious-magazine' ),
			),
			'post_meta'                 => array(
				'type'    => 'multi-checkbox',
				'label'   => __( 'Post Meta', 'eximious-magazine' ),
				'options' => array(
					'author'    => __( 'Author', 'eximious-magazine' ),
					'read_time' => __( 'Post Read Time', 'eximious-magazine' ),
					'date'      => __( 'Date', 'eximious-magazine' ),
					'comment'   => __( 'Comment', 'eximious-magazine' ),
				),
				'std'     => array( 'author', 'date', 'comment' ),
			),
			'date_format'               => array(
				'type'    => 'select',
				'label'   => __( 'Date Format', 'eximious-magazine' ),
				'desc'    => __( 'Make sure to select Date from above for this to work.', 'eximious-magazine' ),
				'options' => array(
					'format_1' => __( 'Times Ago', 'eximious-magazine' ),
					'format_2' => __( 'Default Format', 'eximious-magazine' ),
				),
				'std'     => 'format_1',
			),
			'author_image'              => array(
				'type'  => 'checkbox',
				'label' => __( 'Show Author Image', 'eximious-magazine' ),
				'desc'  => __( 'Make sure to select Author from above for this to work.', 'eximious-magazine' ),
				'std'   => false,
			),
			'excerpt_settings_heading'  => array(
				'type'  => 'heading',
				'label' => __( 'Excerpt Settings', 'eximious-magazine' ),
			),
			'show_excerpt'              => array(
				'type'  => 'checkbox',
				'label' => __( 'Show Excerpt', 'eximious-magazine' ),
				'std'   => true,
			),
			'excerpt_length'            => array(
				'type'  => 'number',
				'step'  => 1,
				'min'   => 0,
				'max'   => '',
				'std'   => 20,
				'label' => __( 'Excerpt Length', 'eximious-magazine' ),
			),
			'show_read_more'            => array(
				'type'  => 'checkbox',
				'label' => __( 'Show Read More', 'eximious-magazine' ),
				'std'   => false,
			),
			'read_more_text'            => array(
				'type'  => 'text',
				'label' => __( 'Read More Text', 'eximious-magazine' ),
				'desc'  => __( 'Leave Empty if you want to use default text "Read More" ', 'eximious-magazine' ),
			),
			'read_more_style'           => array(
				'type'    => 'select',
				'label'   => __( 'Read More Style', 'eximious-magazine' ),
				'options' => eximious_magazine_get_read_more_styles(),
				'std'     => 'style_2',
			),
			'read_more_icon'            => array(
				'type'    => 'select',
				'label'   => __( 'Read More Icon', 'eximious-magazine' ),
				'options' => array(
					''                        => __( 'None', 'eximious-magazine' ),
					'arrow-bar-right'         => __( 'Arrow Bar Right', 'eximious-magazine' ),
					'arrow-right'             => __( 'Arrow Right', 'eximious-magazine' ),
					'arrow-right-circle'      => __( 'Arrow Right Circle', 'eximious-magazine' ),
					'arrow-right-circle-fill' => __( 'Arrow Right Circle fill', 'eximious-magazine' ),
					'chevron-right'           => __( 'Chevron Right', 'eximious-magazine' ),
					'chevron-double-right'    => __( 'Chevron Double Right', 'eximious-magazine' ),
					'caret-right'             => __( 'Caret Right', 'eximious-magazine' ),
					'caret-right-fill'        => __( 'Caret Right Fill', 'eximious-magazine' ),
				),
				'std'     => 'arrow-right',
			),
			'category_settings_heading' => array(
				'type'  => 'heading',
				'label' => __( 'Category Settings', 'eximious-magazine' ),
			),
			'show_category'             => array(
				'type'  => 'checkbox',
				'label' => __( 'Show Category', 'eximious-magazine' ),
				'std'   => true,
			),
			'category_color'            => array(
				'type'    => 'select',
				'label'   => __( 'Category Color', 'eximious-magazine' ),
				'options' => eximious_magazine_get_category_color_display(),
				'std'     => 'as_bg',
			),
			'category_style'            => array(
				'type'    => 'select',
				'label'   => __( 'Category Style', 'eximious-magazine' ),
				'options' => eximious_magazine_get_category_styles(),
				'std'     => 'style_2',
			),
			'no_of_category'            => array(
				'type'  => 'number',
				'step'  => 1,
				'min'   => 0,
				'max'   => '',
				'std'   => 1,
				'label' => __( 'Number of Category to Display', 'eximious-magazine' ),
			),
			'widget_settings_heading'   => array(
				'type'  => 'heading',
				'label' => __( 'Widget Settings', 'eximious-magazine' ),
			),
			'no_of_column'              => array(
				'type'  => 'number',
				'step'  => 1,
				'min'   => 2,
				'max'   => 5,
				'std'   => 2,
				'label' => __( 'Number of Column', 'eximious-magazine' ),
			),
			'enable_post_format_icon'   => array(
				'type'  => 'checkbox',
				'label' => __( 'Enable Post Format Icon', 'eximious-magazine' ),
				'std'   => false,
			),
			'title_limit'               => array(
				'type'    => 'select',
				'label'   => __( 'Post Title Limit', 'eximious-magazine' ),
				'options' => eximious_magazine_get_title_limit_choices(),
				'std'     => '',
			),
		);

		parent::__construct();
	}

	/**
	 * Query the posts and return them.
	 *
	 * @param  array $args
	 * @param  array $instance
	 * @return WP_Query
	 */
	public function get_posts( $args, $instance ) {
		$number  = ! empty( $instance['number'] ) ? absint( $instance['number'] ) : $this->settings['number']['std'];
		$orderby = ! empty( $instance['orderby'] ) ? sanitize_text_field( $instance['orderby'] ) : $this->settings['orderby']['std'];
		$order   = ! empty( $instance['order'] ) ? sanitize_text_field( $instance['order'] ) : $this->settings['order']['std'];

		$query_args = array(
			'posts_per_page'      => $number,
			'post_status'         => 'publish',
			'no_found_rows'       => 1,
			'orderby'             => $orderby,
			'order'               => $order,
			'ignore_sticky_posts' => 1,
		);

		if ( ! empty( $instance['category'] ) && -1 != $instance['category'] && 0 != $instance['category'] ) {
			$query_args['tax_query'][] = array(
				'taxonomy' => 'category',
				'field'    => 'term_id',
				'terms'    => $instance['category'],
			);
		}

		return new WP_Query( apply_filters( 'eximious_magazine_grid_posts_query_args', $query_args ) );
	}

	/**
	 * Output widget.
	 *
	 * @see WP_Widget
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {

		ob_start();

		if ( ( $posts = $this->get_posts( $args, $instance ) ) && $posts->have_posts() ) {
			$this->widget_start( $args, $instance );

			do_action( 'eximious_magazine_before_grid_posts' );

			$column                  = isset( $instance['no_of_column'] ) ? $instance['no_of_column'] : $this->settings['no_of_column']['std'];
			$title_limit             = isset( $instance['title_limit'] ) ? $instance['title_limit'] : $this->settings['title_limit']['std'];
			$enable_post_format_icon = isset( $instance['enable_post_format_icon'] ) ? $instance['enable_post_format_icon'] : $this->settings['enable_post_format_icon']['std'];
			$show_excerpt            = isset( $instance['show_excerpt'] ) ? $instance['show_excerpt'] : $this->settings['show_excerpt']['std'];
			$show_read_more          = isset( $instance['show_read_more'] ) ? $instance['show_read_more'] : $this->settings['show_read_more']['std'];
			if ( $show_read_more ) {
				$read_more_text  = isset( $instance['read_more_text'] ) ? $instance['read_more_text'] : '';
				$read_more_style = isset( $instance['read_more_style'] ) ? $instance['read_more_style'] : $this->settings['read_more_style']['std'];
				$read_more_icon  = isset( $instance['read_more_icon'] ) ? $instance['read_more_icon'] : $this->settings['read_more_icon']['std'];
			}
			$show_category = isset( $instance['show_category'] ) ? $instance['show_category'] : $this->settings['show_category']['std'];
			if ( $show_category ) {
				$cat_style = isset( $instance['category_style'] ) ? $instance['category_style'] : $this->settings['category_style']['std'];
				$color     = isset( $instance['category_color'] ) ? $instance['category_color'] : $this->settings['category_color']['std'];
				$limit     = isset( $instance['no_of_category'] ) ? $instance['no_of_category'] : $this->settings['no_of_category']['std'];
			}
			$enabled_post_meta             = isset( $instance['post_meta'] ) ? $instance['post_meta'] : $this->settings['post_meta']['std'];
			$meta_settings['date_format']  = isset( $instance['date_format'] ) ? $instance['date_format'] : $this->settings['date_format']['std'];
			$meta_settings['author_image'] = isset( $instance['author_image'] ) ? $instance['author_image'] : $this->settings['author_image']['std'];

			$col_class = 'row row-cols-1 row-cols-sm-2 row-cols-md-2 gx-4 gy-5';

			if ( 2 == $column ) {
				$col_class .= ' eximious-magazine-grid-2';
			} elseif ( 3 == $column ) {
				$col_class .= ' row-cols-lg-3 eximious-magazine-grid-3';
			} elseif ( 4 == $column ) {
				$col_class .= ' row-cols-xl-4 eximious-magazine-grid-4';
			} elseif ( 5 == $column ) {
				$col_class .= ' row-cols-md-3 row-cols-lg-4 row-cols-xl-5 eximious-magazine-grid-5';
			} else {
				$col_class .= ' row-cols-lg-2 eximious-magazine-grid-2';
			}
			?>

			<div class="eximious-magazine-grid-posts-widget">
				<div class="<?php echo esc_attr( $col_class ); ?>">
					<?php
					while ( $posts->have_posts() ) :
						$posts->the_post();
						?>
							<div class="col">
								<div class="article-block-wrapper img-animate-zoom">
									<?php
									if ( has_post_thumbnail() ) {
										?>
										<div class="article-image">
											<a href="<?php the_permalink(); ?>">
												<?php
												if ( $enable_post_format_icon ) {
													eximious_magazine_post_format_icon( 'right' );
												}
												?>
												<?php
												the_post_thumbnail(
													'eximious-magazine-large-img',
													array(
														'alt' => the_title_attribute(
															array(
																'echo' => false,
															)
														),
													)
												);
												?>
											</a>
										</div>
										<?php
									}
									?>
									<div class="article-details">
										<?php
										if ( $show_category ) {
											echo '<div class="article-cat-info">';
											eximious_magazine_post_categories( $cat_style, $color, $limit );
											echo '</div>';
										}
										?>
										<h3 class="article-title no-margin">
											<a href="<?php the_permalink(); ?>" class="text-decoration-none color-accent-hover eximious-magazine-limit-lines <?php echo esc_attr( $title_limit ); ?>">
												<?php the_title(); ?>
											</a>
										</h3>
										<?php
										eximious_magazine_post_meta_info( $enabled_post_meta, $meta_settings );
										if ( $show_excerpt && $instance['excerpt_length'] > 0 ) {
											?>
											<div class="article-excerpt">
												<p class="no-margin">
													<?php echo wp_trim_words( get_the_excerpt(), $instance['excerpt_length'], '&hellip;' ); ?>
												</p>
											</div>
										<?php } ?>
										<?php
										if ( $show_read_more ) {
											?>
											<div class="article-read-more">
												<a href="<?php the_permalink(); ?>" class="eximious-magazine-read-more text-decoration-none read-more-link <?php echo $read_more_style; ?>">
													<?php
													if ( $read_more_text ) {
														echo esc_html( $read_more_text );
													} else {
														esc_html_e( 'Read More', 'eximious-magazine' );
													}
													if ( $read_more_icon ) {
														?>
														<span><?php echo eximious_magazine_the_theme_svg( $read_more_icon ); ?></span>
														<?php
													}
													?>
												</a>
											</div>
											<?php
										}
										?>
									</div>
								</div>
							</div>
						<?php
					endwhile;
					wp_reset_postdata();
					?>
				</div>
			</div>
			<?php

			do_action( 'eximious_magazine_after_grid_posts' );

			$this->widget_end( $args );
		}

		echo ob_get_clean();
	}

}
