<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Eximious_Magazine_Call_To_Action extends Eximious_Magazine_Widget_Base {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->widget_cssclass    = 'widget_eximious_magazine_call_to_action';
		$this->widget_description = __( 'Adds Call to action section', 'eximious-magazine' );
		$this->widget_id          = 'eximious_magazine_call_to_action';
		$this->widget_name        = __( 'Eximious Magazine: Call To Action', 'eximious-magazine' );

		$this->settings = array(
			'title'            => array(
				'type'  => 'text',
				'label' => __( 'Widget Title', 'eximious-magazine' ),
			),
			'cta_settings'     => array(
				'type'  => 'heading',
				'label' => __( 'CTA Settings', 'eximious-magazine' ),
			),
			'title_text'       => array(
				'type'  => 'text',
				'label' => __( 'CTA Title', 'eximious-magazine' ),
			),
			'desc'             => array(
				'type'  => 'textarea',
				'label' => __( 'CTA Description', 'eximious-magazine' ),
				'rows'  => 10,
			),
			'btn_text'         => array(
				'type'  => 'text',
				'label' => __( 'Button Text', 'eximious-magazine' ),
			),
			'btn_link'         => array(
				'type'  => 'url',
				'label' => __( 'Link to url', 'eximious-magazine' ),
				'desc'  => __( 'Enter a proper url with http: OR https:', 'eximious-magazine' ),
			),
			'link_target'      => array(
				'type'  => 'checkbox',
				'label' => __( 'Open Link in new Tab', 'eximious-magazine' ),
				'std'   => true,
			),
			'widget_settings'  => array(
				'type'  => 'heading',
				'label' => __( 'Widget Settings', 'eximious-magazine' ),
			),
			'style'            => array(
				'type'    => 'select',
				'label'   => __( 'Display Style', 'eximious-magazine' ),
				'options' => array(
					'style_1' => __( 'Items Aligned Center + Small Width Description', 'eximious-magazine' ),
					'style_2' => __( 'Items Aligned Center + Full Width Description', 'eximious-magazine' ),
					'style_3' => __( 'Items Aligned Left', 'eximious-magazine' ),
					'style_4' => __( 'Items Aligned Right', 'eximious-magazine' ),
				),
				'std'     => 'style_1',
			),
			'enable_bg_color'  => array(
				'type'  => 'checkbox',
				'label' => __( 'Enable Background Color', 'eximious-magazine' ),
				'std'   => false,
			),
			'bg_color'         => array(
				'type'  => 'color',
				'label' => __( 'Background Color', 'eximious-magazine' ),
				'std'   => '#000000',
				'desc'  => __( 'Will be overridden if used background image.', 'eximious-magazine' ),
			),
			'bg_image'         => array(
				'type'  => 'image',
				'label' => __( 'Background Image', 'eximious-magazine' ),
			),
			'enable_fixed_bg'  => array(
				'type'  => 'checkbox',
				'label' => __( 'Enable Fixed Background Image', 'eximious-magazine' ),
				'std'   => true,
			),
			'bg_overlay_color' => array(
				'type'  => 'color',
				'label' => __( 'Overlay Color', 'eximious-magazine' ),
				'std'   => '#000000',
			),
			'overlay_opacity'  => array(
				'type'  => 'number',
				'step'  => 10,
				'min'   => 0,
				'max'   => 100,
				'std'   => 50,
				'label' => __( 'Overlay Opacity', 'eximious-magazine' ),
			),
			'height'           => array(
				'type'  => 'number',
				'step'  => 1,
				'min'   => 150,
				'max'   => '',
				'std'   => 350,
				'label' => __( 'Height (px)', 'eximious-magazine' ),
				'desc'  => __( 'Works when there is either a background color or image.', 'eximious-magazine' ),
			),
		);

		parent::__construct();
	}

	/**
	 * Output widget.
	 *
	 * @see WP_Widget
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {

		ob_start();

		$style         = '';
		$class         = $instance['style'];
		$image_enabled = false;

		$this->widget_start( $args, $instance );

		if ( $instance['enable_bg_color'] ) {
			$bg_color = isset( $instance['bg_color'] ) ? $instance['bg_color'] : $this->settings['bg_color']['std'];
			$style    = 'background-color:' . esc_attr( $bg_color ) . ';';
		}

		if ( ( $instance['bg_image'] && 0 != $instance['bg_image'] ) ) {
			$image_enabled = true;
			if ( $instance['enable_fixed_bg'] ) {
				$class .= ' eximious-magazine-bg-image eximious-magazine-bg-attachment-fixed';
			}
		}

		if ( $instance['enable_bg_color'] || $image_enabled ) {
			$height = isset( $instance['height'] ) ? $instance['height'] : $this->settings['height']['std'];
			$style .= 'min-height:' . esc_attr( $height ) . 'px;';
			$class .= ' eximious-magazine-cover-block';
		}

		do_action( 'eximious_magazine_before_cta' );

		?>

		<div class="eximious-magazine-cta-widget <?php echo esc_attr( $class ); ?>" style="<?php echo esc_attr( $style ); ?>">

			<?php
				if ( $image_enabled ) {
					$overlay_style  = 'background-color:' . $instance['bg_overlay_color'] . ';';
					$overlay_style .= 'opacity:' . ( $instance['overlay_opacity'] / 100 ) . ';';
					?>
					<span aria-hidden="true" class="eximious-magazine-block-overlay" style="<?php echo esc_attr( $overlay_style ); ?>"></span>
					<?php echo wp_get_attachment_image( $instance['bg_image'], 'full' ); ?>
					<?php
				}
			?>
			<div class="eximious-magazine-cta-inner-wrapper eximious-magazine-block-inner-wrapper">

				<?php if ( $instance['title_text'] ) : ?>
					<div class="cta-title">
						<?php echo esc_html( $instance['title_text'] ); ?>
					</div>
				<?php endif; ?>

				<?php if ( $instance['desc'] ) : ?>
					<div class="cta-description">
						<?php echo wpautop( wp_kses_post( $instance['desc'] ) ); ?>
					</div>
				<?php endif; ?>

				<?php if ( $instance['btn_text'] ) : ?>
					<div class="cta-button">
						<a 
						href="<?php echo ( $instance['btn_link'] ) ? esc_url( $instance['btn_link'] ) : ''; ?>" 
						target="<?php echo ( $instance['link_target'] ) ? '_blank' : '_self'; ?>" class="button"><?php echo esc_html( ( $instance['btn_text'] ) ); ?></a>
					</div>
				<?php endif; ?>

			</div>

		</div>

		<?php

		do_action( 'eximious_magazine_after_cta' );

		$this->widget_end( $args );

		echo ob_get_clean();
	}

}
