<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Eximious_Magazine_Ads_Code extends Eximious_Magazine_Widget_Base {
	/**
	 * Constructor.
	 */
	public function __construct() {

		$this->widget_cssclass    = 'eximious_magazine_ads_code_widget';
		$this->widget_description = __( 'Advertisements or codes widget.', 'eximious-magazine' );
		$this->widget_id          = 'eximious_magazine_ads_code_widget';
		$this->widget_name        = __( 'Eximious Magazine: Ads Code', 'eximious-magazine' );
		$this->settings           = array(
			'ads_code'        => array(
				'type'  => 'textarea',
				'label' => __( 'Ads Code', 'eximious-magazine' ),
			),
			'align'           => array(
				'type'    => 'select',
				'label'   => __( 'Alignment', 'eximious-magazine' ),
				'options' => array(
					'left'    => __( 'Left', 'eximious-magazine' ),
					'center'  => __( 'Center', 'eximious-magazine' ),
					'right'   => __( 'Right', 'eximious-magazine' ),
					'strecth' => __( 'Stretch', 'eximious-magazine' ),
				),
				'std'     => 'center',
			),
			'hide_on_desktop' => array(
				'type'  => 'checkbox',
				'label' => __( 'Hide on Desktop', 'eximious-magazine' ),
				'std'   => false,
			),
			'hide_on_tablet'  => array(
				'type'  => 'checkbox',
				'label' => __( 'Hide on Tablet', 'eximious-magazine' ),
				'std'   => false,
			),
			'hide_on_mobile'  => array(
				'type'  => 'checkbox',
				'label' => __( 'Hide on Mobile', 'eximious-magazine' ),
				'std'   => false,
			),
		);

		parent::__construct();
	}

	/**
	 * Output widget.
	 *
	 * @see WP_Widget
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {

		ob_start();

		$before_widget = $args['before_widget'];
		$after_widget  = $args['after_widget'];

		echo wp_kses_post( $before_widget );

		$ad_class = '';
		if ( $instance['hide_on_desktop'] ) {
			$ad_class .= ' hide-on-desktop';
		}
		if ( $instance['hide_on_tablet'] ) {
			$ad_class .= ' hide-on-tablet';
		}
		if ( $instance['hide_on_mobile'] ) {
			$ad_class .= ' hide-on-mobile';
		}

		do_action( 'eximious_magazine_before_ads_code' );

		?>

		<div class="eximious-magazine-ads-code-widget<?php echo esc_attr( $ad_class ); ?>" style="justify-items:<?php echo esc_attr( $instance['align'] ); ?>;" >
			<?php
			if ( $instance['ads_code'] ) {
				echo wp_kses_post( $instance['ads_code'] );
			}
			?>
		</div>

		<?php

		do_action( 'eximious_magazine_after_ads_code' );

		echo wp_kses_post( $after_widget );

		echo ob_get_clean();
	}

}
