<?php

if ( ! function_exists( 'eximious_magazine_ajax_pagination' ) ) :
	/**
	 * Outputs the required structure for ajax loading posts on scroll and click
	 *
	 * @since 1.0.0
	 * @param $type string Ajax Load Type
	 */
	function eximious_magazine_ajax_pagination( $type ) {
		global $wp_query;
		if ( $wp_query->max_num_pages > 1 ) {

			?>
			<div class="eximious-magazine-load-posts-btn-wrapper" 
			data-page="1" 
			data-max-pages="<?php echo esc_attr( $wp_query->max_num_pages ); ?>" 
			data-load-type="<?php echo esc_attr( $type ); ?>"
			>
				<a href="#" class="eximious-magazine-ajax-load-btn text-decoration-none">
					<span class="eximious-magazine-ajax-btn-txt"><?php esc_html_e( 'Load More Posts', 'eximious-magazine' ); ?></span>
					<span class="eximious-magazine-ajax-loader">
						<?php eximious_magazine_the_theme_svg( 'arrow-repeat' ); ?>
					</span>
				</a>
			</div>
			<?php
		}
	}
endif;

if ( ! function_exists( 'eximious_magazine_load_posts' ) ) :
	/**
	 * Ajax Load posts Callback.
	 *
	 * @since 1.0.0
	 */
	function eximious_magazine_load_posts() {

		check_ajax_referer( 'eximious-magazine-load-posts-nonce', 'load_post_nonce' );

		$query_vars = json_decode( stripslashes( $_POST['query_vars'] ), true );

		$query_vars['post_type']   = ( isset( $_POST['post_type'] ) && ! empty( $_POST['post_type'] ) ) ? esc_attr( $_POST['post_type'] ) : 'post';
		$query_vars['paged']       = (int) $_POST['page'];
		$query_vars['post_status'] = 'publish';

		$posts = new WP_Query( $query_vars );

		if ( $posts->have_posts() ) :

			ob_start();

			$archive_style = $_POST['template'];
			set_query_var( 'archive_style', $archive_style );

			// Set a query var for new query to work with the default query.
			set_query_var( 'archive_query', $posts );

			// Load a different template for search page else load archive template.
			if ( isset( $query_vars['s'] ) && ! empty( $query_vars['s'] ) ) {
				$template_part = 'template-parts/content/content-search';
			} else {
				$template_part = 'template-parts/archive/styles/' . $archive_style;
			}

			get_template_part( $template_part );

			$output['content'][] = ob_get_clean();
			wp_send_json_success( $output );

		else :

			$error = new WP_Error( '500', __( 'No More Posts', 'eximious-magazine' ) );
			wp_send_json_error( $error );

		endif;

		wp_die();
	}
endif;
add_action( 'wp_ajax_eximious_magazine_load_posts', 'eximious_magazine_load_posts' );
add_action( 'wp_ajax_nopriv_eximious_magazine_load_posts', 'eximious_magazine_load_posts' );
