<?php
/**
 * CSS related hooks.
 *
 * This file contains hook functions which are related to CSS.
 *
 * @package Eximious_Magazine
 */

if ( ! function_exists( 'eximious_magazine_generate_font_family' ) ) :
	/**
	 * Returns css apporpriate font family
	 *
	 * @since 1.0.0
	 *
	 * @return string font-family
	 */
	function eximious_magazine_generate_font_family( $font_base ) {
		if ( ! empty( $font_base ) ) {
			$font_base         = str_replace( '"', '', $font_base );
			$font_base_explode = explode( ', ', $font_base );
			$font_name         = isset( $font_base_explode[0] ) ? $font_base_explode[0] : '';
			$font_serif        = isset( $font_base_explode[2] ) ? $font_base_explode[2] : '';
			$space_end         = ', ';
			if ( empty( $font_serif ) ) :
				$space_end = '';
			endif;
			return "'" . $font_name . "'" . $space_end . $font_serif;
		}
	}
endif;

if ( ! function_exists( 'eximious_magazine_get_inline_css' ) ) :
	/**
	 * Outputs theme custom CSS.
	 *
	 * @since 1.0.0
	 */
	function eximious_magazine_get_inline_css() {

		$defaults = array(
			'site_title_font_size_desktop'            => 42,
			'site_tagline_font_size_desktop'          => 16,
			'primary_color'                           => '#404040',
			'accent_color'                            => '#00adb5',
			'link_color'                              => '#00adb5',
			'link_color_hover'                        => '#000000',
			'h1_color'                                => '#000000',
			'h2_color'                                => '#000000',
			'h3_color'                                => '#000000',
			'h4_color'                                => '#000000',
			'h5_color'                                => '#000000',
			'h6_color'                                => '#000000',
			'header_social_links_icons_color'         => '#ffffff',
			'header_social_links_icons_hover_color'   => '#00adb5',
			'header_search_btn_bg_color'              => '#00adb5',
			'top_bar_bg_color'                        => '#222831',
			'top_bar_date_color'                      => '#ffffff',
			'top_bar_nav_menu_color'                  => '#ffffff',
			'top_bar_nav_menu_hover_color'            => '#00adb5',
			'top_bar_sub_menu_bg_color'               => '#000000',
			'primary_menu_bg_color'                   => '#ffffff',
			'offcanvas_icon_color'                    => '#000000',
			'primary_menu_text_color'                 => '#000000',
			'primary_menu_text_hover_color'           => '#000000',
			'primary_menu_text_hover_border'          => '#00adb5',
			'primary_menu_active_item_color'          => '#000000',
			'primary_menu_active_item_border'         => '#00adb5',
			'primary_menu_desc_color'                 => '#999999',
			'sub_menu_bg_color'                       => '#ffffff',
			'sub_menu_text_color'                     => '#000000',
			'sub_menu_text_hover_color'               => '#000000',
			'sub_menu_text_hover_border'              => '#00adb5',
			'sub_menu_desc_color'                     => '#999999',
			'header_bg_color'                         => '#ffffff',
			'preloader_bg_color'                      => '#ffffff',
			'preloader_color'                         => '#00adb5',
			'progressbar_color'                       => '#00adb5',
			'breadcrumb_link_color'                   => '#00adb5',
			'global_buttons_text_color'               => '#ffffff',
			'global_buttons_bg_color'                 => '#00adb5',
			'primary_font'                            => '"Roboto", "100:100italic:300:300italic:regular:italic:500:500italic:700:700italic:900:900italic", sans-serif',
			'secondary_font'                          => '"Roboto", "100:100italic:300:300italic:regular:italic:500:500italic:700:700italic:900:900italic", sans-serif',
			'primary_menu_font'                       => '"Roboto", "100:100italic:300:300italic:regular:italic:500:500italic:700:700italic:900:900italic", sans-serif',
			'primary_font_weight'                     => 500,
			'secondary_font_weight'                   => 'normal',
			'primary_menu_font_weight'                => 700,
			'offcanvas_bg_color'                      => '#ffffff',
			'dark_offcanvas_bg_color'                 => '#10100f',
			'footer_bg_color'                         => '#f0f0f0',
			'dark_footer_bg_color'                    => '#222831',
			'footer_bg_image_opacity'                 => 0.5,
			'footer_bg_image_overlay_color'           => '#000000',
			'sub_footer_theme'                        => 'dark',
			'sub_footer_bg_color'                     => '#ffffff',
			'dark_sub_footer_bg_color'                => '#393e46',
			'scroll_to_top_bg_color'                  => '#00adb5',
			'banner_arrows_bg_color'                  => '#ffffff',
			'banner_section_bg_color'                 => '#ffffff',
			'trending_section_bg_color'               => '#ffffff',
			'trending_post_text_bg_color'             => '#00adb5',
			'trending_post_text_color'                => '#ffffff',
			'below_header_widgetarea_bg_color'        => '#ffffff',
			'before_home_columns_widgetarea_bg_color' => '#ffffff',
			'home_columns_widgetarea_bg_color'        => '#ffffff',
			'above_home_widgetarea_bg_color'          => '#ffffff',
			'below_home_widgetarea_bg_color'          => '#ffffff',
			'above_footer_widgetarea_bg_color'        => '#ffffff',
			'below_footer_widgetarea_bg_color'        => '#ffffff',
		);

		$site_title_font_size            = get_theme_mod( 'site_title_font_size_desktop', $defaults['site_title_font_size_desktop'] );
		$site_tagline_font_size          = get_theme_mod( 'site_tagline_font_size_desktop', $defaults['site_tagline_font_size_desktop'] );
		$primary_color                   = get_theme_mod( 'primary_color', $defaults['primary_color'] );
		$accent_color                    = get_theme_mod( 'accent_color', $defaults['accent_color'] );
		$link_color                      = get_theme_mod( 'link_color', $defaults['link_color'] );
		$link_color_hover                = get_theme_mod( 'link_color_hover', $defaults['link_color_hover'] );
		$header_social_icons             = get_theme_mod( 'header_social_links_icons_color', $defaults['header_social_links_icons_color'] );
		$header_social_icons_hover       = get_theme_mod( 'header_social_links_icons_hover_color', $defaults['header_social_links_icons_hover_color'] );
		$header_search_btn_bg_color      = get_theme_mod( 'header_search_btn_bg_color', $defaults['header_search_btn_bg_color'] );
		$primary_menu_bg_color           = get_theme_mod( 'primary_menu_bg_color', $defaults['primary_menu_bg_color'] );
		$offcanvas_icon_color            = get_theme_mod( 'offcanvas_icon_color', $defaults['offcanvas_icon_color'] );
		$primary_menu_text_color         = get_theme_mod( 'primary_menu_text_color', $defaults['primary_menu_text_color'] );
		$primary_menu_text_hover_color   = get_theme_mod( 'primary_menu_text_hover_color', $defaults['primary_menu_text_hover_color'] );
		$primary_menu_text_hover_border  = get_theme_mod( 'primary_menu_text_hover_border', $defaults['primary_menu_text_hover_border'] );
		$primary_menu_active_item_color  = get_theme_mod( 'primary_menu_active_item_color', $defaults['primary_menu_active_item_color'] );
		$primary_menu_active_item_border = get_theme_mod( 'primary_menu_active_item_border', $defaults['primary_menu_active_item_border'] );
		$primary_menu_desc_color         = get_theme_mod( 'primary_menu_desc_color', $defaults['primary_menu_desc_color'] );
		$sub_menu_bg_color               = get_theme_mod( 'sub_menu_bg_color', $defaults['sub_menu_bg_color'] );
		$sub_menu_text_color             = get_theme_mod( 'sub_menu_text_color', $defaults['sub_menu_text_color'] );
		$sub_menu_text_hover_color       = get_theme_mod( 'sub_menu_text_hover_color', $defaults['sub_menu_text_hover_color'] );
		$sub_menu_text_hover_border      = get_theme_mod( 'sub_menu_text_hover_border', $defaults['sub_menu_text_hover_border'] );
		$sub_menu_desc_color             = get_theme_mod( 'sub_menu_desc_color', $defaults['sub_menu_desc_color'] );
		$header_bg_color                 = get_theme_mod( 'header_bg_color', $defaults['header_bg_color'] );
		$offcanvas_bg_color              = get_theme_mod( 'offcanvas_bg_color', $defaults['offcanvas_bg_color'] );
		$dark_offcanvas_bg_color         = get_theme_mod( 'dark_offcanvas_bg_color', $defaults['dark_offcanvas_bg_color'] );
		$footer_bg_color                 = get_theme_mod( 'footer_bg_color', $defaults['footer_bg_color'] );
		$dark_footer_bg_color            = get_theme_mod( 'dark_footer_bg_color', $defaults['dark_footer_bg_color'] );
		$sub_footer_bg_color             = get_theme_mod( 'sub_footer_bg_color', $defaults['sub_footer_bg_color'] );
		$dark_sub_footer_bg_color        = get_theme_mod( 'dark_sub_footer_bg_color', $defaults['dark_sub_footer_bg_color'] );
		$scroll_to_top_bg_color          = get_theme_mod( 'scroll_to_top_bg_color', $defaults['scroll_to_top_bg_color'] );
		$primary_font                    = get_theme_mod( 'primary_font', $defaults['primary_font'] );
		$primary_font_weight             = get_theme_mod( 'primary_font_weight', $defaults['primary_font_weight'] );
		$secondary_font                  = get_theme_mod( 'secondary_font', $defaults['secondary_font'] );
		$secondary_font_weight           = get_theme_mod( 'secondary_font_weight', $defaults['secondary_font_weight'] );
		$primary_menu_font               = get_theme_mod( 'primary_menu_font', $defaults['primary_menu_font'] );
		$primary_menu_font_weight        = get_theme_mod( 'primary_menu_font_weight', $defaults['primary_menu_font_weight'] );
		$top_bar_bg_color                = get_theme_mod( 'top_bar_bg_color', $defaults['top_bar_bg_color'] );
		$top_bar_date_color              = get_theme_mod( 'top_bar_date_color', $defaults['top_bar_date_color'] );
		$top_bar_nav_menu_color          = get_theme_mod( 'top_bar_nav_menu_color', $defaults['top_bar_nav_menu_color'] );
		$top_bar_nav_menu_hover_color    = get_theme_mod( 'top_bar_nav_menu_hover_color', $defaults['top_bar_nav_menu_hover_color'] );
		$top_bar_sub_menu_bg_color       = get_theme_mod( 'top_bar_sub_menu_bg_color', $defaults['top_bar_sub_menu_bg_color'] );
		$progressbar_color               = get_theme_mod( 'progressbar_color', $defaults['progressbar_color'] );
		$preloader_bg_color              = get_theme_mod( 'preloader_bg_color', $defaults['preloader_bg_color'] );
		$preloader_color                 = get_theme_mod( 'preloader_color', $defaults['preloader_color'] );
		$breadcrumb_link_color           = get_theme_mod( 'breadcrumb_link_color', $defaults['breadcrumb_link_color'] );
		$global_buttons_text_color       = get_theme_mod( 'global_buttons_text_color', $defaults['global_buttons_text_color'] );
		$global_buttons_bg_color         = get_theme_mod( 'global_buttons_bg_color', $defaults['global_buttons_bg_color'] );
		$h1_color                        = get_theme_mod( 'h1_color', $defaults['h1_color'] );
		$h2_color                        = get_theme_mod( 'h2_color', $defaults['h2_color'] );
		$h3_color                        = get_theme_mod( 'h3_color', $defaults['h3_color'] );
		$h4_color                        = get_theme_mod( 'h4_color', $defaults['h4_color'] );
		$h5_color                        = get_theme_mod( 'h5_color', $defaults['h5_color'] );
		$h6_color                        = get_theme_mod( 'h6_color', $defaults['h6_color'] );
		$banner_arrows_bg_color          = get_theme_mod( 'banner_arrows_bg_color', $defaults['banner_arrows_bg_color'] );
		$banner_section_bg_color         = get_theme_mod( 'banner_section_bg_color', $defaults['banner_section_bg_color'] );
		$trending_section_bg_color       = get_theme_mod( 'trending_section_bg_color', $defaults['trending_section_bg_color'] );
		$trending_post_text_bg_color     = get_theme_mod( 'trending_post_text_bg_color', $defaults['trending_post_text_bg_color'] );
		$trending_post_text_color        = get_theme_mod( 'trending_post_text_color', $defaults['trending_post_text_color'] );
		$home_before_columns_bg_color    = get_theme_mod( 'before_home_columns_widgetarea_bg_color', $defaults['before_home_columns_widgetarea_bg_color'] );
		$home_columns_bg_color           = get_theme_mod( 'home_columns_widgetarea_bg_color', $defaults['home_columns_widgetarea_bg_color'] );
		$below_header_area_bg            = get_theme_mod( 'below_header_widgetarea_bg_color', $defaults['below_header_widgetarea_bg_color'] );
		$above_home_area_bg              = get_theme_mod( 'above_home_widgetarea_bg_color', $defaults['above_home_widgetarea_bg_color'] );
		$below_home_area_bg              = get_theme_mod( 'below_home_widgetarea_bg_color', $defaults['below_home_widgetarea_bg_color'] );
		$above_footer_area_bg            = get_theme_mod( 'above_footer_widgetarea_bg_color', $defaults['above_footer_widgetarea_bg_color'] );
		$below_footer_area_bg            = get_theme_mod( 'below_footer_widgetarea_bg_color', $defaults['below_footer_widgetarea_bg_color'] );

		$css = '';

		if ( get_theme_mod( 'show_progressbar' ) ) :
			if ( $progressbar_color !== $defaults['progressbar_color'] ) :
				$css .= '
				:root {
					--global--color-progressbar:' . esc_attr( $progressbar_color ) . ';
				}';
			endif;
		endif;

		if ( get_theme_mod( 'show_preloader' ) ) :
			if ( $preloader_bg_color !== $defaults['preloader_bg_color'] ) :
				$css .= '
				:root {
					--global--color-preloader-bg:' . esc_attr( $preloader_bg_color ) . ';
				}';
			endif;
			if ( $preloader_color !== $defaults['preloader_color'] ) :
				$css .= '
				:root {
					--global--color-preloader:' . esc_attr( $preloader_color ) . ';
				}';
				$css .= '
				.preloader-loader-wrapper .loading svg polyline#back {
					stroke: ' . eximious_magazine_hex2rbga( $preloader_color, 0.3 ) . ';
				}';
			endif;
		endif;

		if ( $primary_font != $defaults['primary_font'] ) :
			$css .= '
            :root {
                --font-headings:' . sanitize_text_field( eximious_magazine_generate_font_family( $primary_font ) ) . ';
            }';
		endif;

		if ( $primary_font_weight != $defaults['primary_font_weight'] ) :
			$css .= '
            :root {
                --heading--font-weight:' . esc_attr( $primary_font_weight ) . ';
            }';
		endif;

		if ( $secondary_font != $defaults['secondary_font'] ) :
			$css .= '
            :root {
                --font-base:' . sanitize_text_field( eximious_magazine_generate_font_family( $secondary_font ) ) . ';
            }';
		endif;

		if ( $secondary_font_weight != $defaults['secondary_font_weight'] ) :
			$css .= '
            body {
                font-weight:' . esc_attr( $secondary_font_weight ) . ';
            }';
		endif;

		if ( $primary_menu_font != $defaults['primary_menu_font'] ) :
			$css .= '
            :root {
                --font-primary-menu:' . sanitize_text_field( eximious_magazine_generate_font_family( $primary_menu_font ) ) . ';
            }';
		endif;

		if ( $primary_menu_font_weight != $defaults['primary_menu_font_weight'] ) :
			$css .= '
            :root {
                --primary--menu-font-weight:' . esc_attr( $primary_menu_font_weight ) . ';
            }';
		endif;

		if ( $site_title_font_size != $defaults['site_title_font_size_desktop'] ) :
			$css .= '
            @media (min-width: 1000px){
                .site-title {
                    font-size:' . esc_attr( $site_title_font_size ) . 'px;
                }
            }';
		endif;

		if ( $site_tagline_font_size != $defaults['site_tagline_font_size_desktop'] ) :
			$css .= '
             @media (min-width: 1000px){
                .site-description {
                    font-size:' . esc_attr( $site_tagline_font_size ) . 'px;
                }
            }';
		endif;

		if ( $header_social_icons !== $defaults['header_social_links_icons_color'] ) :
			$css .= '
			:root {
                --global--color-header-social-nav:' . esc_attr( $header_social_icons ) . ';
            }';
		endif;

		if ( $header_social_icons_hover !== $defaults['header_social_links_icons_hover_color'] ) :
			$css .= '
			:root {
				--global--color-header-social-nav-hover:' . esc_attr( $header_social_icons_hover ) . ';
			}';
		endif;

		if ( $header_search_btn_bg_color !== $defaults['header_search_btn_bg_color'] ) :
			$css .= '
			:root {
				--global--color-header-search-btn-bg:' . esc_attr( $header_search_btn_bg_color ) . ';
			}';
		endif;

		if ( get_theme_mod( 'enable_top_bar' ) ) :

			if ( $top_bar_bg_color !== $defaults['top_bar_bg_color'] ) :
				$css .= '
				:root {
					--global--color-topbar-bg:' . esc_attr( $top_bar_bg_color ) . ';
				}';
			endif;

			if ( get_theme_mod( 'enable_todays_date' ) ) :
				if ( $top_bar_date_color !== $defaults['top_bar_date_color'] ) :
					$css .= '
					:root {
						--global--color-topbar-date:' . esc_attr( $top_bar_date_color ) . ';
					}';
				endif;
			endif;

			if ( get_theme_mod( 'enable_top_nav' ) ) :
				if ( $top_bar_nav_menu_color !== $defaults['top_bar_nav_menu_color'] ) :
					$css .= '
					:root {
						--global--color-topbar-menu:' . esc_attr( $top_bar_nav_menu_color ) . ';
					}';
				endif;
				if ( $top_bar_nav_menu_hover_color !== $defaults['top_bar_nav_menu_hover_color'] ) :
					$css .= '
					:root {
						--global--color-topbar-menu-hover:' . esc_attr( $top_bar_nav_menu_hover_color ) . ';
					}';
				endif;
				if ( $top_bar_sub_menu_bg_color !== $defaults['top_bar_sub_menu_bg_color'] ) :
					$css .= '
					:root {
						--global--color-topbar-submenu-bg:' . esc_attr( $top_bar_sub_menu_bg_color ) . ';
					}';
				endif;
			endif;

		endif;

		if ( $header_bg_color !== $defaults['header_bg_color'] ) :
			$css .= '
			:root {
                --global--color-header-bg:' . esc_attr( $header_bg_color ) . ';
            }';
		endif;

		if ( $offcanvas_bg_color !== $defaults['offcanvas_bg_color'] ) :
			$css .= '
			.eximious-magazine-canvas-block {
                background-color:' . esc_attr( $offcanvas_bg_color ) . ';
            }';
		endif;

		if ( $dark_offcanvas_bg_color !== $defaults['dark_offcanvas_bg_color'] ) :
			$css .= '
			.eximious-magazine-canvas-block.inverted-offcanvas {
                background-color:' . esc_attr( $dark_offcanvas_bg_color ) . ';
            }';
		endif;

		if ( 'light' == get_theme_mod( 'footer_theme', 'dark' ) ) :
			if ( $footer_bg_color !== $defaults['footer_bg_color'] ) :
				$css .= '
				:root {
					--global--color-footer-bg:' . esc_attr( $footer_bg_color ) . ';
				}';
			endif;
		endif;

		if ( 'dark' == get_theme_mod( 'footer_theme', 'dark' ) ) :
			if ( $dark_footer_bg_color !== $defaults['dark_footer_bg_color'] ) :
				$css .= '
				.site-footer.inverted-footer {
					background-color:' . esc_attr( $dark_footer_bg_color ) . ';
				}';
			endif;
		endif;

		if ( 'light' == get_theme_mod( 'sub_footer_theme', 'dark' ) ) :
			if ( $sub_footer_bg_color !== $defaults['sub_footer_bg_color'] ) :
				$css .= '
				:root {
					--global--color-sub-footer-bg:' . esc_attr( $sub_footer_bg_color ) . ';
				}';
			endif;
		endif;

		if ( 'dark' == get_theme_mod( 'sub_footer_theme', 'dark' ) ) :
			if ( $dark_sub_footer_bg_color !== $defaults['dark_sub_footer_bg_color'] ) :
				$css .= '
				.site-sub-footer.inverted-sub-footer {
					background-color:' . esc_attr( $dark_sub_footer_bg_color ) . ';
				}';
			endif;
		endif;

		if ( $scroll_to_top_bg_color !== $defaults['scroll_to_top_bg_color'] ) :
			$css .= '
			:root {
				--global--color-scroll-top-bg:' . esc_attr( $scroll_to_top_bg_color ) . ';
			}';
		endif;

		if ( $primary_color !== $defaults['primary_color'] ) :
			$css .= '
			:root {
                --global--color-primary:' . esc_attr( $primary_color ) . ';
            }';
		endif;

		if ( $primary_menu_bg_color !== $defaults['primary_menu_bg_color'] ) :
			$css .= '
			:root {
                --global--color-primary-menu-bg:' . esc_attr( $primary_menu_bg_color ) . ';
            }';
		endif;

		if ( $offcanvas_icon_color !== $defaults['offcanvas_icon_color'] ) :
			$css .= '
			:root {
                --global--color-offcanvas-icon:' . esc_attr( $offcanvas_icon_color ) . ';
            }';
		endif;

		if ( $primary_menu_text_color !== $defaults['primary_menu_text_color'] ) :
			$css .= '
			:root {
                --global--color-primary-menu:' . esc_attr( $primary_menu_text_color ) . ';
            }';
		endif;

		if ( $primary_menu_text_hover_color !== $defaults['primary_menu_text_hover_color'] ) :
			$css .= '
			:root {
                --global--color-primary-menu-hover:' . esc_attr( $primary_menu_text_hover_color ) . ';
            }';
		endif;

		if ( $primary_menu_text_hover_border !== $defaults['primary_menu_text_hover_border'] ) :
			$css .= '
			:root {
                --global--color-primary-menu-hover-border:' . esc_attr( $primary_menu_text_hover_border ) . ';
            }';
		endif;

		if ( $primary_menu_active_item_color !== $defaults['primary_menu_active_item_color'] ) :
			$css .= '
			:root {
                --global--color-primary-menu-active:' . esc_attr( $primary_menu_active_item_color ) . ';
            }';
		endif;

		if ( $primary_menu_active_item_border !== $defaults['primary_menu_active_item_border'] ) :
			$css .= '
			:root {
                --global--color-primary-menu-active-border:' . esc_attr( $primary_menu_active_item_border ) . ';
            }';
		endif;

		if ( $primary_menu_desc_color !== $defaults['primary_menu_desc_color'] ) :
			$css .= '
			:root {
                --global--color-primary-menu-desc:' . esc_attr( $primary_menu_desc_color ) . ';
            }';
		endif;

		if ( $sub_menu_bg_color !== $defaults['sub_menu_bg_color'] ) :
			$css .= '
			:root {
                --global--color-sub-menu-bg:' . esc_attr( $sub_menu_bg_color ) . ';
            }';
		endif;

		if ( $sub_menu_text_color !== $defaults['sub_menu_text_color'] ) :
			$css .= '
			:root {
                --global--color-sub-menu:' . esc_attr( $sub_menu_text_color ) . ';
            }';
		endif;

		if ( $sub_menu_text_hover_color !== $defaults['sub_menu_text_hover_color'] ) :
			$css .= '
			:root {
                --global--color-sub-menu-hover:' . esc_attr( $sub_menu_text_hover_color ) . ';
            }';
		endif;

		if ( $sub_menu_text_hover_border !== $defaults['sub_menu_text_hover_border'] ) :
			$css .= '
			:root {
                --global--color-sub-menu-hover-border:' . esc_attr( $sub_menu_text_hover_border ) . ';
            }';
		endif;

		if ( $sub_menu_desc_color !== $defaults['sub_menu_desc_color'] ) :
			$css .= '
			:root {
                --global--color-sub-menu-desc:' . esc_attr( $sub_menu_desc_color ) . ';
            }';
		endif;

		if ( $accent_color !== $defaults['accent_color'] ) :
			$css .= '
			:root {
                --global--color-accent:' . esc_attr( $accent_color ) . ';
            }';
		endif;

		if ( $link_color !== $defaults['link_color'] ) :
			$css .= '
			:root {
                --global--link-color:' . esc_attr( $link_color ) . ';
            }';
		endif;

		if ( $link_color_hover !== $defaults['link_color_hover'] ) :
			$css .= '
			:root {
                --global--link-color-hover:' . esc_attr( $link_color_hover ) . ';
            }';
		endif;

		if ( get_theme_mod( 'enable_breadcrumb', true ) ) :
			if ( $breadcrumb_link_color !== $defaults['breadcrumb_link_color'] ) :
				$css .= '
				:root {
					--global--color-breadcrumb:' . esc_attr( $breadcrumb_link_color ) . ';
				}';
			endif;
		endif;

		if ( $global_buttons_text_color !== $defaults['global_buttons_text_color'] ) :
			$css .= '
			:root {
				--global--color-btn:' . esc_attr( $global_buttons_text_color ) . ';
			}';
		endif;

		if ( $global_buttons_bg_color !== $defaults['global_buttons_bg_color'] ) :
			$css .= '
			:root {
				--global--color-btn-bg:' . esc_attr( $global_buttons_bg_color ) . ';
			}';
		endif;

		if ( $h1_color !== $defaults['h1_color'] ) :
			$css .= '
			:root {
                --global--color-h1:' . esc_attr( $h1_color ) . ';
            }';
			$css .= '
			h1 a {
                color:' . esc_attr( $h1_color ) . ';
            }';
		endif;

		if ( $h2_color !== $defaults['h2_color'] ) :
			$css .= '
			:root {
                --global--color-h2:' . esc_attr( $h2_color ) . ';
            }';
			$css .= '
			h2 a {
                color:' . esc_attr( $h2_color ) . ';
            }';
		endif;

		if ( $h3_color !== $defaults['h3_color'] ) :
			$css .= '
			:root {
                --global--color-h3:' . esc_attr( $h3_color ) . ';
            }';
			$css .= '
			h3 a {
                color:' . esc_attr( $h3_color ) . ';
            }';
		endif;

		if ( $h4_color !== $defaults['h4_color'] ) :
			$css .= '
			:root {
                --global--color-h4:' . esc_attr( $h4_color ) . ';
            }';
			$css .= '
			h4 a {
                color:' . esc_attr( $h4_color ) . ';
            }';
		endif;

		if ( $h5_color !== $defaults['h5_color'] ) :
			$css .= '
			:root {
                --global--color-h5:' . esc_attr( $h5_color ) . ';
            }';
			$css .= '
			h5 a {
                color:' . esc_attr( $h5_color ) . ';
            }';
		endif;

		if ( $h6_color !== $defaults['h6_color'] ) :
			$css .= '
			:root {
                --global--color-h6:' . esc_attr( $h6_color ) . ';
            }';
			$css .= '
			h6 a {
                color:' . esc_attr( $h6_color ) . ';
            }';
		endif;

		if ( get_theme_mod( 'enable_banner' ) ) :
			if ( get_theme_mod( 'enable_banner_arrows', true ) ) :
				if ( $banner_arrows_bg_color !== $defaults['banner_arrows_bg_color'] ) :
					$banner_arrows_bg_color = eximious_magazine_hex2rbga( $banner_arrows_bg_color, 0.8 );
					$css                   .= '
					.eximious-magazine-banner-wrapper { 
						--swiper-pagination-bg-color:' . esc_attr( $banner_arrows_bg_color ) . ';
					}';
				endif;
			endif;
			if ( $banner_section_bg_color !== $defaults['banner_section_bg_color'] ) :
				$css .= '
				:root {
					--global--banner-section-bg:' . esc_attr( $banner_section_bg_color ) . ';
				}';
			endif;
		endif;

		if ( get_theme_mod( 'enable_trending_posts' ) ) :
			if ( $trending_section_bg_color !== $defaults['trending_section_bg_color'] ) :
				$css .= '
				:root {
					--global--trending-section-bg:' . esc_attr( $trending_section_bg_color ) . ';
				}';
			endif;
			if ( $trending_post_text_bg_color !== $defaults['trending_post_text_bg_color'] ) :
				$css .= '
				:root {
					--global--color-trending-text-bg:' . esc_attr( $trending_post_text_bg_color ) . ';
				}';
			endif;
			if ( $trending_post_text_color !== $defaults['trending_post_text_color'] ) :
				$css .= '
				:root {
					--global--color-trending-text:' . esc_attr( $trending_post_text_color ) . ';
				}';
			endif;
		endif;

		if ( $below_header_area_bg !== $defaults['below_header_widgetarea_bg_color'] ) :
			$css .= '
			:root {
                --global--widetarea-below-header-bg:' . esc_attr( $below_header_area_bg ) . ';
            }';
		endif;

		if ( $home_before_columns_bg_color !== $defaults['before_home_columns_widgetarea_bg_color'] ) :
			$css .= '
			:root {
                --global--widetarea-before-home-columns-bg:' . esc_attr( $home_before_columns_bg_color ) . ';
            }';
		endif;

		if ( $home_columns_bg_color !== $defaults['home_columns_widgetarea_bg_color'] ) :
			$css .= '
			:root {
                --global--widetarea-home-columns-bg:' . esc_attr( $home_columns_bg_color ) . ';
            }';
		endif;

		if ( $above_home_area_bg !== $defaults['above_home_widgetarea_bg_color'] ) :
			$css .= '
			:root {
                --global--widetarea-before-home-bg:' . esc_attr( $above_home_area_bg ) . ';
            }';
		endif;

		if ( $below_home_area_bg !== $defaults['below_home_widgetarea_bg_color'] ) :
			$css .= '
			:root {
                --global--widetarea-after-home-bg:' . esc_attr( $below_home_area_bg ) . ';
            }';
		endif;

		if ( $above_footer_area_bg !== $defaults['above_footer_widgetarea_bg_color'] ) :
			$css .= '
			:root {
                --global--widetarea-before-footer-bg:' . esc_attr( $above_footer_area_bg ) . ';
            }';
		endif;

		if ( $below_footer_area_bg !== $defaults['below_footer_widgetarea_bg_color'] ) :
			$css .= '
			:root {
                --global--widetarea-after-footer-bg:' . esc_attr( $below_footer_area_bg ) . ';
            }';
		endif;

		return refactor_css( $css );
	}
endif;

if ( ! function_exists( 'eximious_magazine_get_woo_inline_css' ) ) :
	/**
	 * Outputs woocommerce custom CSS.
	 *
	 * @since 1.0.0
	 */
	function eximious_magazine_get_woo_inline_css() {

		$defaults = array(
			'accent_color' => '#00adb5',
		);

		$accent_color = get_theme_mod( 'accent_color', $defaults['accent_color'] );

		$css = '';

		if ( $accent_color !== $defaults['accent_color'] ) :
			$css .= '
			:root {
				--global--color-woo-accent:' . esc_attr( $accent_color ) . ';
			}';
		endif;

		return refactor_css( $css );
	}

endif;

if ( ! function_exists( 'refactor_css' ) ) :
	/**
	 * Refactor CSS.
	 *
	 * @since 1.0.0
	 */
	function refactor_css( $css ) {
		$refactored_css = str_replace( array( "\r\n", "\r", "\n", "\t", '  ', '    ', '    ' ), '', $css );
		return $refactored_css;
	}
endif;
