<?php
/**
 * Free v Pro
 *
 * @package Eximious_Magazine
 */

$icons = array(
	'0' => '<span class="dashicons dashicons-no"></span>',
	'1' => '<span class="dashicons dashicons-yes"></span>',
);
?>
<div class="eximious-magazine-dashboard-body">
	<div class="free-vs-pro-wrapper">
		<div class="section-cta-upgrade">
			<span><?php esc_html_e( 'PREMIUM', 'eximious-magazine' ); ?></span>
			<h2><?php esc_html_e( 'Unlock More with Eximious Magazine Pro', 'eximious-magazine' ); ?></h2>
			<p><?php esc_html_e( 'Unlock all the possibilties and true potential with premium version of this theme', 'eximious-magazine' ); ?></p>
			<a href="<?php echo esc_url( $this->theme_url . '?utm_source=wp&utm_medium=theme-dashboard&utm_campaign=fvp' ); ?>" target="_blank" class="button button-primary button-plus"><?php esc_html_e( 'Upgrade To Pro', 'eximious-magazine' ); ?></a>
		</div>
		<table>
			<thead>
				<tr>
					<th class="eximious-magazine-text-left"><?php esc_html_e( 'Features', 'eximious-magazine' ); ?></th>
					<th class="eximious-magazine-text-center"><?php esc_html_e( 'Free', 'eximious-magazine' ); ?></th>
					<th class="eximious-magazine-text-center"><?php esc_html_e( 'Pro', 'eximious-magazine' ); ?></th>
				</tr>
			</thead>
			<tbody>
				<?php
				$free_vs_pro = array(
					array(
						'feature' => __( 'Help and support', 'eximious-magazine' ),
						'free'    => __( 'Standard support', 'eximious-magazine' ),
						'pro'     => __( 'High priority support', 'eximious-magazine' ),
					),
					array(
						'feature' => __( 'Predesigned website templates', 'eximious-magazine' ),
						'free'    => __( '1', 'eximious-magazine' ),
						'pro'     => __( '4', 'eximious-magazine' ),
					),
					array(
						'feature' => __( 'Seo optimized', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Translation ready', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'RTL ready', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Post formats support', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'WooCommerce ready', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => __( 'With more options', 'eximious-magazine' ),
					),
					array(
						'feature' => __( 'Preloader option', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => __( '15+ Preloaders', 'eximious-magazine' ),
					),
					array(
						'feature' => __( 'Progressbar option', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Typography font option', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Typography color option', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Primary menu font option', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Primary menu responisve font sizes', 'eximious-magazine' ),
						'free'    => 0,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Headings font option', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Headings responisve font sizes', 'eximious-magazine' ),
						'free'    => 0,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Body font option', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Body responisve font sizes', 'eximious-magazine' ),
						'free'    => 0,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Primary color option', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Menu color option', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Sub-menu color option', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Homepage banner slider option', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Homepage banner slider style', 'eximious-magazine' ),
						'free'    => __( '1', 'eximious-magazine' ),
						'pro'     => __( '3', 'eximious-magazine' ),
					),
					array(
						'feature' => __( 'Homepage banner carousel option', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Homepage banner carousel style', 'eximious-magazine' ),
						'free'    => __( '1', 'eximious-magazine' ),
						'pro'     => __( '4', 'eximious-magazine' ),
					),
					array(
						'feature' => __( 'Homepage pinned posts', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Homepage banner section visibility options', 'eximious-magazine' ),
						'free'    => 0,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Homepage banner section dimensions', 'eximious-magazine' ),
						'free'    => 0,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Homepage banner section dividers', 'eximious-magazine' ),
						'free'    => 0,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Homepage trending posts', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Homepage trending post style', 'eximious-magazine' ),
						'free'    => __( '1', 'eximious-magazine' ),
						'pro'     => __( '2', 'eximious-magazine' ),
					),
					array(
						'feature' => __( 'Homepage trending post visibility options', 'eximious-magazine' ),
						'free'    => 0,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Homepage trending post section dimensions', 'eximious-magazine' ),
						'free'    => 0,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Homepage trending post section dividers', 'eximious-magazine' ),
						'free'    => 0,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Homepage layout option', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => __( 'With more options', 'eximious-magazine' ),
					),
					array(
						'feature' => __( 'Homepage custom sidebar', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Darkmode option', 'eximious-magazine' ),
						'free'    => 0,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Topbar option', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Topbar color option', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Header style', 'eximious-magazine' ),
						'free'    => __( '2', 'eximious-magazine' ),
						'pro'     => __( '4', 'eximious-magazine' ),
					),
					array(
						'feature' => __( 'Header ad banner', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Sticky header', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Header section dimensions', 'eximious-magazine' ),
						'free'    => 0,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Menu Bar option', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Sticky sidebar', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Offcanvas', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Offcanvas Light/Dark Theme', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Offcanvas Logo', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Offcanvas Widgets Title Style', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Archive style', 'eximious-magazine' ),
						'free'    => __( '3', 'eximious-magazine' ),
						'pro'     => __( '6', 'eximious-magazine' ),
					),
					array(
						'feature' => __( 'Archive post metas', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Ajax load posts on click', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Infinite scroll load posts', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Related posts', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Floating related posts', 'eximious-magazine' ),
						'free'    => 0,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Author posts', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Author info box', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => __( 'With social links option', 'eximious-magazine' ),
					),
					array(
						'feature' => __( 'Integrated social share option', 'eximious-magazine' ),
						'free'    => 0,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Page layout option', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Category image option', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Category color option', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Different design style for each category', 'eximious-magazine' ),
						'free'    => 0,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Different design style for each tags', 'eximious-magazine' ),
						'free'    => 0,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Custom widgets', 'eximious-magazine' ),
						'free'    => __( '15+', 'eximious-magazine' ),
						'pro'     => __( '20+', 'eximious-magazine' ),
					),
					array(
						'feature' => __( 'Widgets title style & align options', 'eximious-magazine' ),
						'free'    =>  __( '10+ Styles', 'eximious-magazine' ),
						'pro'     =>  __( '15+ Styles', 'eximious-magazine' ),
					),
					array(
						'feature' => __( 'Widgetareas', 'eximious-magazine' ),
						'free'    =>  __( '12+', 'eximious-magazine' ),
						'pro'     =>  __( '12+', 'eximious-magazine' ),
					),
					array(
						'feature' => __( 'Widgetareas visibility options', 'eximious-magazine' ),
						'free'    => 0,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Widgetareas dimension options', 'eximious-magazine' ),
						'free'    => 0,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Widgetareas dividers', 'eximious-magazine' ),
						'free'    => 0,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Single post layout', 'eximious-magazine' ),
						'free'    =>  __( '3', 'eximious-magazine' ),
						'pro'     =>  __( '4', 'eximious-magazine' ),
					),
					array(
						'feature' => __( 'Single post navigation style', 'eximious-magazine' ),
						'free'    => __( '3', 'eximious-magazine' ),
						'pro'     => __( '5', 'eximious-magazine' ),
					),
					array(
						'feature' => __( 'Footer Layouts', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Footer Widgets title style & align options', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Footer Light/Dark Theme', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Sub Footer', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Sub Footer Light/Dark Theme', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Sub Footer Layout', 'eximious-magazine' ),
						'free'    => __( '1', 'eximious-magazine' ),
						'pro'     => __( '2', 'eximious-magazine' ),
					),
					array(
						'feature' => __( 'Sub Footer Logo', 'eximious-magazine' ),
						'free'    => 0,
						'pro'     => 1,
					),
					array(
						'feature' => __( 'Scroll To Top', 'eximious-magazine' ),
						'free'    => 1,
						'pro'     => __( 'With more options', 'eximious-magazine' ),
					),
				);
				foreach ( $free_vs_pro as $features ) :
					?>
					<tr>
						<td class="eximious-magazine-text-left"><?php echo esc_html( $features['feature'] ); ?></td>
						<td class="eximious-magazine-text-center">
							<?php
							if ( 1 === $features['free'] ) {
								echo $icons[1];
							} elseif ( 0 === $features['free'] ) {
								echo $icons[0];
							} else {
								echo esc_html( $features['free'] );
							}
							?>
						</td>
						<td class="eximious-magazine-text-center">
							<?php
							if ( 1 === $features['pro'] ) {
								echo $icons[1];
							} elseif ( 0 === $features['pro'] ) {
								echo $icons[0];
							} else {
								echo esc_html( $features['pro'] );
							}
							?>
						</td>
					</tr>
					<?php
				endforeach;
				?>
			</tbody>
		</table>
		<div class="free-vs-pro-footer">
			<a href="<?php echo esc_url( $this->theme_url . '?utm_source=wp&utm_medium=theme-dashboard&utm_campaign=fvp' ); ?>" target="_blank"><?php esc_html_e( 'And many more features', 'eximious-magazine' ); ?><span class="dashicons dashicons-external"></span></a>
		</div>
	</div>
</div>
