<?php
$wp_customize->add_section(
	'single_post_options',
	array(
		'title' => __( 'Single Post Options', 'eximious-magazine' ),
		'panel' => 'single_posts_options_panel',
	)
);

/* Single Post Layout*/
$wp_customize->add_setting(
	'single_post_layout',
	array(
		'default'           => $theme_options_defaults['single_post_layout'],
		'sanitize_callback' => 'eximious_magazine_sanitize_radio',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Radio_Image_Control(
		$wp_customize,
		'single_post_layout',
		array(
			'label'   => __( 'Single Post Layout', 'eximious-magazine' ),
			'section' => 'single_post_options',
			'choices' => eximious_magazine_get_general_layouts(),
		)
	)
);

/*Single Post Style*/
$wp_customize->add_setting(
	'single_post_style',
	array(
		'default'           => $theme_options_defaults['single_post_style'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'single_post_style',
	array(
		'label'   => __( 'Single Post Style', 'eximious-magazine' ),
		'section' => 'single_post_options',
		'type'    => 'select',
		'choices' => eximious_magazine_get_single_layouts(),
	)
);

/*Posts Navigation Style*/
$wp_customize->add_setting(
	'posts_navigation_style',
	array(
		'default'           => $theme_options_defaults['posts_navigation_style'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'posts_navigation_style',
	array(
		'label'   => __( 'Posts Navigation Style', 'eximious-magazine' ),
		'section' => 'single_post_options',
		'type'    => 'select',
		'choices' => eximious_magazine_get_single_navigation_styles(),
	)
);

/* Post Meta */
$wp_customize->add_setting(
	'single_post_meta',
	array(
		'default'           => $theme_options_defaults['single_post_meta'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox_multiple',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Checkbox_Multiple(
		$wp_customize,
		'single_post_meta',
		array(
			'label'       => __( 'Single Post Meta', 'eximious-magazine' ),
			'description' => __( 'Choose the post meta you want to be displayed on post detail page', 'eximious-magazine' ),
			'section'     => 'single_post_options',
			'choices'     => array(
				'author'    => __( 'Author', 'eximious-magazine' ),
				'read_time' => __( 'Post Read Time', 'eximious-magazine' ),
				'date'      => __( 'Date', 'eximious-magazine' ),
				'comment'   => __( 'Comment', 'eximious-magazine' ),
				'category'  => __( 'Category', 'eximious-magazine' ),
				'tags'      => __( 'Tags', 'eximious-magazine' ),
			),
		)
	)
);

// Center Align header meta.
$wp_customize->add_setting(
	'center_align_single_header_meta',
	array(
		'default'           => $theme_options_defaults['center_align_single_header_meta'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'center_align_single_header_meta',
		array(
			'label'   => __( 'Center Align Post Header Meta', 'eximious-magazine' ),
			'section' => 'single_post_options',
		)
	)
);

// Single Post Date Format.
$wp_customize->add_setting(
	'single_date_format',
	array(
		'default'           => $theme_options_defaults['single_date_format'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'single_date_format',
	array(
		'label'       => __( 'Date Format', 'eximious-magazine' ),
		'description' => __( 'Make sure to enable Date post meta from above for this to work.', 'eximious-magazine' ),
		'section'     => 'single_post_options',
		'type'        => 'select',
		'choices'     => array(
			'format_1' => __( 'Times Ago', 'eximious-magazine' ),
			'format_2' => __( 'Default Format', 'eximious-magazine' ),
		),
	)
);

// Show Single Post author image.
$wp_customize->add_setting(
	'enable_single_author_image',
	array(
		'default'           => $theme_options_defaults['enable_single_author_image'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'enable_single_author_image',
		array(
			'label'       => __( 'Show Author Image', 'eximious-magazine' ),
			'description' => __( 'Make sure to enable Author post meta from above for this to work.', 'eximious-magazine' ),
			'section'     => 'single_post_options',
		)
	)
);

// Show Single Category Label.
$wp_customize->add_setting(
	'enable_single_cat_label',
	array(
		'default'           => $theme_options_defaults['enable_single_cat_label'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'enable_single_cat_label',
		array(
			'label'       => __( 'Show Category Label', 'eximious-magazine' ),
			'description' => __( 'Make sure to enable Category post meta from above for this to work.', 'eximious-magazine' ),
			'section'     => 'single_post_options',
		)
	)
);

// Single Category Color Display.
$wp_customize->add_setting(
	'single_category_color_display',
	array(
		'default'           => $theme_options_defaults['single_category_color_display'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'single_category_color_display',
	array(
		'label'   => __( 'Category Color Display', 'eximious-magazine' ),
		'section' => 'single_post_options',
		'type'    => 'select',
		'choices' => eximious_magazine_get_category_color_display(),
	)
);

/* Category Style in Single post Page*/
$wp_customize->add_setting(
	'single_category_style',
	array(
		'default'           => $theme_options_defaults['single_category_style'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'single_category_style',
	array(
		'label'   => __( 'Category Style', 'eximious-magazine' ),
		'section' => 'single_post_options',
		'type'    => 'select',
		'choices' => eximious_magazine_get_category_styles(),
	)
);

// No of Single Categories.
$wp_customize->add_setting(
	'single_category_limit',
	array(
		'default'           => $theme_options_defaults['single_category_limit'],
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'single_category_limit',
	array(
		'label'       => __( 'Limit Categories To Display', 'eximious-magazine' ),
		'description' => __( 'Use 0 for no limit.', 'eximious-magazine' ),
		'section'     => 'single_post_options',
		'type'        => 'number',
	)
);

// Single Category Position.
$wp_customize->add_setting(
	'single_category_position',
	array(
		'default'           => $theme_options_defaults['single_category_position'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'single_category_position',
	array(
		'label'   => __( 'Single Category Position', 'eximious-magazine' ),
		'section' => 'single_post_options',
		'type'    => 'select',
		'choices' => array(
			'before_title'  => __( 'Before Title', 'eximious-magazine' ),
			'after_content' => __( 'After Content', 'eximious-magazine' ),
		),

	)
);

// Show Single Tag Label.
$wp_customize->add_setting(
	'enable_single_tag_label',
	array(
		'default'           => $theme_options_defaults['enable_single_tag_label'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'enable_single_tag_label',
		array(
			'label'       => __( 'Show Tag Label', 'eximious-magazine' ),
			'description' => __( 'Make sure to enable Tags post meta from above for this to work.', 'eximious-magazine' ),
			'section'     => 'single_post_options',
		)
	)
);

/* Tag Style in Single post Page*/
$wp_customize->add_setting(
	'single_tag_style',
	array(
		'default'           => $theme_options_defaults['single_tag_style'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'single_tag_style',
	array(
		'label'   => __( 'Tag Style', 'eximious-magazine' ),
		'section' => 'single_post_options',
		'type'    => 'select',
		'choices' => eximious_magazine_get_tag_styles(),
	)
);

// No of Single Tags.
$wp_customize->add_setting(
	'single_tag_limit',
	array(
		'default'           => $theme_options_defaults['single_tag_limit'],
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'single_tag_limit',
	array(
		'label'       => __( 'Limit Tags To Display', 'eximious-magazine' ),
		'description' => __( 'Use 0 for no limit.', 'eximious-magazine' ),
		'section'     => 'single_post_options',
		'type'        => 'number',
	)
);