<?php
$wp_customize->add_section(
	'single_comments_options',
	array(
		'title' => __( 'Comments Options', 'eximious-magazine' ),
		'panel' => 'single_posts_options_panel',
	)
);

// Heading Style.
$wp_customize->add_setting(
	'single_comments_heading_style',
	array(
		'default'           => $theme_options_defaults['single_comments_heading_style'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'single_comments_heading_style',
	array(
		'label'           => __( 'Heading Style', 'eximious-magazine' ),
		'section'         => 'single_comments_options',
		'type'            => 'select',
		'choices'         => eximious_magazine_get_title_styles(),
	)
);

// Heading Align.
$wp_customize->add_setting(
	'single_comments_heading_align',
	array(
		'default'           => $theme_options_defaults['single_comments_heading_align'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'single_comments_heading_align',
	array(
		'label'           => __( 'Heading Align', 'eximious-magazine' ),
		'section'         => 'single_comments_options',
		'type'            => 'select',
		'choices'         => eximious_magazine_get_title_alignments(),
	)
);

// Center align Form Content.
$wp_customize->add_setting(
	'single_comments_center_form_content',
	array(
		'default'           => $theme_options_defaults['single_comments_center_form_content'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'single_comments_center_form_content',
		array(
			'label'   => __( 'Center Align Comment Form Content', 'eximious-magazine' ),
			'section' => 'single_comments_options',
		)
	)
);