<?php
$wp_customize->add_section(
	'single_author_post_options',
	array(
		'title' => __( 'Author Post Options', 'eximious-magazine' ),
		'panel' => 'single_posts_options_panel',
	)
);

/*
Show Author Posts
*-----------------------------------------*/
$wp_customize->add_setting(
	'show_author_posts',
	array(
		'default'           => $theme_options_defaults['show_author_posts'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'show_author_posts',
		array(
			'label'   => __( 'Show Author Posts', 'eximious-magazine' ),
			'section' => 'single_author_post_options',
		)
	)
);

/*Author Posts Text.*/
$wp_customize->add_setting(
	'author_posts_text',
	array(
		'default'           => $theme_options_defaults['author_posts_text'],
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'author_posts_text',
	array(
		'label'           => __( 'Author Posts Title', 'eximious-magazine' ),
		'section'         => 'single_author_post_options',
		'type'            => 'text',
		'active_callback' => 'eximious_magazine_is_author_posts_enabled',
	)
);

// Author Posts Title Style.
$wp_customize->add_setting(
	'author_posts_title_style',
	array(
		'default'           => $theme_options_defaults['author_posts_title_style'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'author_posts_title_style',
	array(
		'label'           => __( 'Author Posts Title Style', 'eximious-magazine' ),
		'section'         => 'single_author_post_options',
		'type'            => 'select',
		'choices'         => eximious_magazine_get_title_styles(),
		'active_callback' => 'eximious_magazine_is_author_posts_enabled',
	)
);

// Author Posts Title Align.
$wp_customize->add_setting(
	'author_posts_title_align',
	array(
		'default'           => $theme_options_defaults['author_posts_title_align'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'author_posts_title_align',
	array(
		'label'           => __( 'Author Posts Title Align', 'eximious-magazine' ),
		'section'         => 'single_author_post_options',
		'type'            => 'select',
		'choices'         => eximious_magazine_get_title_alignments(),
		'active_callback' => 'eximious_magazine_is_author_posts_enabled',
	)
);

/* Number of Author Posts */
$wp_customize->add_setting(
	'no_of_author_posts',
	array(
		'default'           => $theme_options_defaults['no_of_author_posts'],
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'no_of_author_posts',
	array(
		'label'           => __( 'Number of Author Posts', 'eximious-magazine' ),
		'section'         => 'single_author_post_options',
		'type'            => 'number',
		'active_callback' => 'eximious_magazine_is_author_posts_enabled',
	)
);

/*Author Posts Orderby*/
$wp_customize->add_setting(
	'author_posts_orderby',
	array(
		'default'           => $theme_options_defaults['author_posts_orderby'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'author_posts_orderby',
	array(
		'label'           => __( 'Orderby', 'eximious-magazine' ),
		'section'         => 'single_author_post_options',
		'type'            => 'select',
		'choices'         => array(
			'date'  => __( 'Date', 'eximious-magazine' ),
			'id'    => __( 'ID', 'eximious-magazine' ),
			'title' => __( 'Title', 'eximious-magazine' ),
			'rand'  => __( 'Random', 'eximious-magazine' ),
		),
		'active_callback' => 'eximious_magazine_is_author_posts_enabled',
	)
);

/*Author Posts Order*/
$wp_customize->add_setting(
	'author_posts_order',
	array(
		'default'           => $theme_options_defaults['author_posts_order'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'author_posts_order',
	array(
		'label'           => __( 'Order', 'eximious-magazine' ),
		'section'         => 'single_author_post_options',
		'type'            => 'select',
		'choices'         => array(
			'asc'  => __( 'ASC', 'eximious-magazine' ),
			'desc' => __( 'DESC', 'eximious-magazine' ),
		),
		'active_callback' => 'eximious_magazine_is_author_posts_enabled',
	)
);

// Author Post Title Limit.
$wp_customize->add_setting(
	'author_posts_title_limit',
	array(
		'default'           => '',
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'author_posts_title_limit',
	array(
		'label'           => __( 'Post Title Limit', 'eximious-magazine' ),
		'section'         => 'single_author_post_options',
		'type'            => 'select',
		'choices'         => eximious_magazine_get_title_limit_choices(),
		'active_callback' => 'eximious_magazine_is_author_posts_enabled',
	)
);

// Show Post Format Icons.
$wp_customize->add_setting(
	'show_author_posts_post_format_icon',
	array(
		'default'           => $theme_options_defaults['show_author_posts_post_format_icon'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'show_author_posts_post_format_icon',
		array(
			'label'           => __( 'Show Post Format Icon', 'eximious-magazine' ),
			'section'         => 'single_author_post_options',
			'active_callback' => 'eximious_magazine_is_author_posts_enabled',
		)
	)
);