<?php
$wp_customize->add_section(
	'single_author_box_options',
	array(
		'title' => __( 'Author Info Box Options', 'eximious-magazine' ),
		'panel' => 'single_posts_options_panel',
	)
);

/*
Show Author Info Box
*-------------------------------*/
$wp_customize->add_setting(
	'show_author_info',
	array(
		'default'           => $theme_options_defaults['show_author_info'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'show_author_info',
		array(
			'label'   => __( 'Show Author Info Box', 'eximious-magazine' ),
			'section' => 'single_author_box_options',
		)
	)
);
