<?php
$wp_customize->add_section(
	'progressbar_options',
	array(
		'title' => __( 'Progressbar Options', 'eximious-magazine' ),
		'panel' => 'misc_options_panel',
	)
);

/*Show Progressbar*/
$wp_customize->add_setting(
	'show_progressbar',
	array(
		'default'           => $theme_options_defaults['show_progressbar'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'show_progressbar',
		array(
			'label'   => __( 'Show Progressbar', 'eximious-magazine' ),
			'section' => 'progressbar_options',
		)
	)
);

$wp_customize->add_setting(
	'progressbar_position',
	array(
		'default'           => $theme_options_defaults['progressbar_position'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'progressbar_position',
	array(
		'label'           => __( 'Progressbar Position', 'eximious-magazine' ),
		'section'         => 'progressbar_options',
		'type'            => 'select',
		'choices'         => array(
			'top'    => __( 'Top', 'eximious-magazine' ),
			'bottom' => __( 'Bottom', 'eximious-magazine' ),
		),
		'active_callback' => 'eximious_magazine_is_progressbar_enabled',
	)
);

$wp_customize->add_setting(
	'progressbar_color',
	array(
		'default'           => $theme_options_defaults['progressbar_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'progressbar_color',
		array(
			'label'           => __( 'Progressbar Color', 'eximious-magazine' ),
			'section'         => 'progressbar_options',
			'type'            => 'color',
			'active_callback' => 'eximious_magazine_is_progressbar_enabled',
		)
	)
);