<?php

// Primary Menu Options.
$wp_customize->add_section(
	'primary_menu_options',
	array(
		'title' => __( 'Primary Menu Bar Options', 'eximious-magazine' ),
		'panel' => 'header_options_panel',
	)
);

// Primary menu Background color.
$wp_customize->add_setting(
	'primary_menu_bg_color',
	array(
		'default'           => $theme_options_defaults['primary_menu_bg_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'primary_menu_bg_color',
		array(
			'label'   => __( 'Primary Menu Background Color', 'eximious-magazine' ),
			'section' => 'primary_menu_options',
			'type'    => 'color',
		)
	)
);

// Offcanvas icon color.
$wp_customize->add_setting(
	'offcanvas_icon_color',
	array(
		'default'           => $theme_options_defaults['offcanvas_icon_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'offcanvas_icon_color',
		array(
			'label'   => __( 'Offcanvas Icon Color', 'eximious-magazine' ),
			'section' => 'primary_menu_options',
			'type'    => 'color',
		)
	)
);

/*Center align Menu*/
$wp_customize->add_setting(
	'center_align_primary_nav',
	array(
		'default'           => $theme_options_defaults['center_align_primary_nav'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'center_align_primary_nav',
		array(
			'label'   => __( 'Center Align Menu', 'eximious-magazine' ),
			'section' => 'primary_menu_options',
		)
	)
);

/*Enable Different Menu Bar Logo*/
$wp_customize->add_setting(
	'enable_different_logo_menu_bar',
	array(
		'default'           => $theme_options_defaults['enable_different_logo_menu_bar'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'enable_different_logo_menu_bar',
		array(
			'label'           => __( 'Different Logo Menu Bar', 'eximious-magazine' ),
			'section'         => 'primary_menu_options',
			'active_callback' => 'eximious_magazine_is_menu_bar_logo_available',
		)
	)
);

/*Menu Bar Logo*/
$wp_customize->add_setting(
	'logo_menu_bar',
	array(
		'default'           => $theme_options_defaults['logo_menu_bar'],
		'sanitize_callback' => 'eximious_magazine_sanitize_image',
	)
);
$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize,
		'logo_menu_bar',
		array(
			'label'           => __( 'Menu Bar Logo', 'eximious-magazine' ),
			'description'     => __( 'Use images with 16:9 aspect ratio for best results', 'eximious-magazine' ),
			'section'         => 'primary_menu_options',
			'active_callback' => function( $control ) {
				return (
					eximious_magazine_is_menu_bar_logo_available( $control )
					&&
					eximious_magazine_is_menu_bar_logo_enabled( $control )
				);
			},
		)
	)
);

/*Enable Menu Bar Social Nav*/
$wp_customize->add_setting(
	'show_menu_bar_social_nav',
	array(
		'default'           => $theme_options_defaults['show_menu_bar_social_nav'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'show_menu_bar_social_nav',
		array(
			'label'       => __( 'Enable Menu Bar Social Nav Menu', 'eximious-magazine' ),
			'description' => sprintf( __( 'You can add/edit social nav menu from <a href="%s">here</a>.', 'eximious-magazine' ), "javascript:wp.customize.control( 'nav_menu_locations[social-menu]' ).focus();" ),
			'section'     => 'primary_menu_options',
		)
	)
);

/*Enable Search*/
$wp_customize->add_setting(
	'enable_search_on_menu_bar',
	array(
		'default'           => $theme_options_defaults['enable_search_on_menu_bar'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'enable_search_on_menu_bar',
		array(
			'label'   => __( 'Enable Search Icon', 'eximious-magazine' ),
			'section' => 'primary_menu_options',
		)
	)
);

if ( eximious_magazine_is_wc_active() ) {

	/*Enable Mini Cart Icon on header*/
	$wp_customize->add_setting(
		'enable_woo_mini_cart_menu_bar',
		array(
			'default'           => $theme_options_defaults['enable_woo_mini_cart_menu_bar'],
			'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
		)
	);
	$wp_customize->add_control(
		new Eximious_Magazine_Toggle_Control(
			$wp_customize,
			'enable_woo_mini_cart_menu_bar',
			array(
				'label'   => __( 'Enable Mini Cart Icon', 'eximious-magazine' ),
				'section' => 'primary_menu_options',
			)
		)
	);

	/*Enable Myaccount Link*/
	$wp_customize->add_setting(
		'enable_woo_my_account_menu_bar',
		array(
			'default'           => $theme_options_defaults['enable_woo_my_account_menu_bar'],
			'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
		)
	);
	$wp_customize->add_control(
		new Eximious_Magazine_Toggle_Control(
			$wp_customize,
			'enable_woo_my_account_menu_bar',
			array(
				'label'   => __( 'Enable My Account Icon', 'eximious-magazine' ),
				'section' => 'primary_menu_options',
			)
		)
	);

}

// Primary menu text color.
$wp_customize->add_setting(
	'primary_menu_text_color',
	array(
		'default'           => $theme_options_defaults['primary_menu_text_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'primary_menu_text_color',
		array(
			'label'   => __( 'Primary Menu Text Color', 'eximious-magazine' ),
			'section' => 'primary_menu_options',
			'type'    => 'color',
		)
	)
);

// Primary menu text hover color.
$wp_customize->add_setting(
	'primary_menu_text_hover_color',
	array(
		'default'           => $theme_options_defaults['primary_menu_text_hover_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'primary_menu_text_hover_color',
		array(
			'label'   => __( 'Primary Menu Text Hover Color', 'eximious-magazine' ),
			'section' => 'primary_menu_options',
			'type'    => 'color',
		)
	)
);

// Primary menu text hover Border color.
$wp_customize->add_setting(
	'primary_menu_text_hover_border',
	array(
		'default'           => $theme_options_defaults['primary_menu_text_hover_border'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'primary_menu_text_hover_border',
		array(
			'label'   => __( 'Primary Menu Text Hover Border Color', 'eximious-magazine' ),
			'section' => 'primary_menu_options',
			'type'    => 'color',
		)
	)
);

// Primary menu active item color.
$wp_customize->add_setting(
	'primary_menu_active_item_color',
	array(
		'default'           => $theme_options_defaults['primary_menu_active_item_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'primary_menu_active_item_color',
		array(
			'label'   => __( 'Primary Menu Active Item Color', 'eximious-magazine' ),
			'section' => 'primary_menu_options',
			'type'    => 'color',
		)
	)
);

// Primary menu active item border color.
$wp_customize->add_setting(
	'primary_menu_active_item_border',
	array(
		'default'           => $theme_options_defaults['primary_menu_active_item_border'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'primary_menu_active_item_border',
		array(
			'label'   => __( 'Primary Menu Active Item Border Color', 'eximious-magazine' ),
			'section' => 'primary_menu_options',
			'type'    => 'color',
		)
	)
);

// Primary menu desc color.
$wp_customize->add_setting(
	'primary_menu_desc_color',
	array(
		'default'           => $theme_options_defaults['primary_menu_desc_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'primary_menu_desc_color',
		array(
			'label'   => __( 'Primary Menu Description Color', 'eximious-magazine' ),
			'section' => 'primary_menu_options',
			'type'    => 'color',
		)
	)
);

// Capitalzie primary menu text.
$wp_customize->add_setting(
	'capitalize_primary_nav_text',
	array(
		'default'           => $theme_options_defaults['capitalize_primary_nav_text'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'capitalize_primary_nav_text',
		array(
			'label'   => __( 'Capitalize Primary Menu Text', 'eximious-magazine' ),
			'section' => 'primary_menu_options',
		)
	)
);

// Sub menu background color.
$wp_customize->add_setting(
	'sub_menu_bg_color',
	array(
		'default'           => $theme_options_defaults['sub_menu_bg_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'sub_menu_bg_color',
		array(
			'label'   => __( 'Sub Menu Background Color', 'eximious-magazine' ),
			'section' => 'primary_menu_options',
			'type'    => 'color',
		)
	)
);

// Sub menu text color.
$wp_customize->add_setting(
	'sub_menu_text_color',
	array(
		'default'           => $theme_options_defaults['sub_menu_text_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'sub_menu_text_color',
		array(
			'label'   => __( 'Sub Menu Text Color', 'eximious-magazine' ),
			'section' => 'primary_menu_options',
			'type'    => 'color',
		)
	)
);

// Sub menu text hover color.
$wp_customize->add_setting(
	'sub_menu_text_hover_color',
	array(
		'default'           => $theme_options_defaults['sub_menu_text_hover_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'sub_menu_text_hover_color',
		array(
			'label'   => __( 'Sub Menu Text Hover Color', 'eximious-magazine' ),
			'section' => 'primary_menu_options',
			'type'    => 'color',
		)
	)
);

// Sub menu text hover Border color.
$wp_customize->add_setting(
	'sub_menu_text_hover_border',
	array(
		'default'           => $theme_options_defaults['sub_menu_text_hover_border'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'sub_menu_text_hover_border',
		array(
			'label'   => __( 'Sub Menu Text Hover Border Color', 'eximious-magazine' ),
			'section' => 'primary_menu_options',
			'type'    => 'color',
		)
	)
);

// Sub menu desc color.
$wp_customize->add_setting(
	'sub_menu_desc_color',
	array(
		'default'           => $theme_options_defaults['sub_menu_desc_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'sub_menu_desc_color',
		array(
			'label'   => __( 'Sub Menu Description Color', 'eximious-magazine' ),
			'section' => 'primary_menu_options',
			'type'    => 'color',
		)
	)
);

// Capitalzie sub menu text.
$wp_customize->add_setting(
	'capitalize_sub_nav_text',
	array(
		'default'           => $theme_options_defaults['capitalize_sub_nav_text'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'capitalize_sub_nav_text',
		array(
			'label'   => __( 'Capitalize Sub Menu Text', 'eximious-magazine' ),
			'section' => 'primary_menu_options',
		)
	)
);

/*Enable Border Top*/
$wp_customize->add_setting(
	'enable_top_border_menu_bar',
	array(
		'default'           => $theme_options_defaults['enable_top_border_menu_bar'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'enable_top_border_menu_bar',
		array(
			'label'   => __( 'Enable Top Border', 'eximious-magazine' ),
			'section' => 'primary_menu_options',
		)
	)
);

/*Enable Border Bottom*/
$wp_customize->add_setting(
	'enable_bottom_border_menu_bar',
	array(
		'default'           => $theme_options_defaults['enable_bottom_border_menu_bar'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'enable_bottom_border_menu_bar',
		array(
			'label'   => __( 'Enable Bottom Border', 'eximious-magazine' ),
			'section' => 'primary_menu_options',
		)
	)
);
