<?php

/*Header Options*/
$wp_customize->add_section(
	'header_options',
	array(
		'title' => __( 'Header Options', 'eximious-magazine' ),
		'panel' => 'header_options_panel',
	)
);

/* Header Background Color*/
$wp_customize->add_setting(
	'header_bg_color',
	array(
		'default'           => $theme_options_defaults['header_bg_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'header_bg_color',
		array(
			'label'   => __( 'Header Background Color', 'eximious-magazine' ),
			'section' => 'header_options',
			'type'    => 'color',
		)
	)
);

/* Header Style */
$wp_customize->add_setting(
	'header_style',
	array(
		'default'           => $theme_options_defaults['header_style'],
		'sanitize_callback' => 'eximious_magazine_sanitize_radio',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Radio_Image_Control(
		$wp_customize,
		'header_style',
		array(
			'label'       => __( 'Header Style', 'eximious-magazine' ),
			'description' => __( 'Some options related to header may not show in the front-end based on header style chosen.', 'eximious-magazine' ),
			'section'     => 'header_options',
			'choices'     => eximious_magazine_get_header_layouts(),
		)
	)
);

/*Ad Banner Image*/
$wp_customize->add_setting(
	'ad_banner_image',
	array(
		'default'           => $theme_options_defaults['ad_banner_image'],
		'sanitize_callback' => 'eximious_magazine_sanitize_image',
	)
);
$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize,
		'ad_banner_image',
		array(
			'label'           => __( 'Ad Banner Image', 'eximious-magazine' ),
			'description'     => __( 'Use image with 16:9 aspect ratio for best results', 'eximious-magazine' ),
			'section'         => 'header_options',
			'active_callback' => 'eximious_magazine_is_ad_banner_enabled',
		)
	)
);

/*Ad Banner Link.*/
$wp_customize->add_setting(
	'ad_banner_link',
	array(
		'default'           => $theme_options_defaults['ad_banner_link'],
		'sanitize_callback' => 'esc_url_raw',
	)
);
$wp_customize->add_control(
	'ad_banner_link',
	array(
		'label'           => __( 'Ad Banner Link', 'eximious-magazine' ),
		'section'         => 'header_options',
		'type'            => 'text',
		'description'     => __( 'Leave empty if you don\'t want the image to have a link', 'eximious-magazine' ),
		'active_callback' => 'eximious_magazine_is_ad_banner_enabled',
	)
);

/*Centered Logo*/
$wp_customize->add_setting(
	'center_logo',
	array(
		'default'           => $theme_options_defaults['center_logo'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'center_logo',
		array(
			'label'           => __( 'Centered Logo', 'eximious-magazine' ),
			'description'     => __( 'Center the logo if no ad banner is present', 'eximious-magazine' ),
			'section'         => 'header_options',
			'active_callback' => 'eximious_magazine_is_ad_banner_enabled',
		)
	)
);
