<?php

// Some Header Global Options.
$wp_customize->add_section(
	'header_global_options',
	array(
		'title' => __( 'Header Element Options', 'eximious-magazine' ),
		'panel' => 'header_options_panel',
	)
);

// Social Links Brand Color.
$wp_customize->add_setting(
	'header_social_links_color_as',
	array(
		'default'           => $theme_options_defaults['header_social_links_color_as'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'header_social_links_color_as',
	array(
		'label'   => __( 'Social Menu Brand Color', 'eximious-magazine' ),
		'section' => 'header_global_options',
		'type'    => 'select',
		'choices' => array(
			'theme_color' => __( 'Use Theme Color', 'eximious-magazine' ),
			'brand_color' => __( 'Use Brand Color', 'eximious-magazine' ),
		),
	)
);

// Social Icons Color
$wp_customize->add_setting(
	'header_social_links_icons_color',
	array(
		'default'           => $theme_options_defaults['header_social_links_icons_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'header_social_links_icons_color',
		array(
			'label'           => __( 'Social Menu Icons Color', 'eximious-magazine' ),
			'section'         => 'header_global_options',
			'type'            => 'color',
			'active_callback' => 'eximious_magazine_is_header_social_icons_theme_color',
		)
	)
);

// Social Icons Hover Color
$wp_customize->add_setting(
	'header_social_links_icons_hover_color',
	array(
		'default'           => $theme_options_defaults['header_social_links_icons_hover_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'header_social_links_icons_hover_color',
		array(
			'label'           => __( 'Social Menu Icons Hover Color', 'eximious-magazine' ),
			'section'         => 'header_global_options',
			'type'            => 'color',
			'active_callback' => 'eximious_magazine_is_header_social_icons_theme_color',
		)
	)
);

// Social Links Display Style.
$wp_customize->add_setting(
	'header_social_links_display_style',
	array(
		'default'           => $theme_options_defaults['header_social_links_display_style'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'header_social_links_display_style',
	array(
		'label'   => __( 'Social Menu Display Style', 'eximious-magazine' ),
		'section' => 'header_global_options',
		'type'    => 'select',
		'choices' => eximious_magazine_get_social_links_styles(),
	)
);

// Search Button Background Color.
$wp_customize->add_setting(
	'header_search_btn_bg_color',
	array(
		'default'           => $theme_options_defaults['header_search_btn_bg_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'header_search_btn_bg_color',
		array(
			'label'   => __( 'Search Form Button Background', 'eximious-magazine' ),
			'section' => 'header_global_options',
			'type'    => 'color',
		)
	)
);
