<?php
// Trending Posts Options.
$wp_customize->add_section(
	'home_page_trending_posts_options',
	array(
		'title' => __( 'Trending Post Options', 'eximious-magazine' ),
		'panel' => 'theme_home_option_panel',
	)
);

// Enable Trending Posts.
$wp_customize->add_setting(
	'enable_trending_posts',
	array(
		'default'           => $theme_options_defaults['enable_trending_posts'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'enable_trending_posts',
		array(
			'label'   => __( 'Enable Trending Posts', 'eximious-magazine' ),
			'section' => 'home_page_trending_posts_options',
		)
	)
);

// Trending section background.
$wp_customize->add_setting(
	'trending_section_bg_color',
	array(
		'default'           => $theme_options_defaults['trending_section_bg_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'trending_section_bg_color',
		array(
			'label'           => __( 'Trending Section Background', 'eximious-magazine' ),
			'section'         => 'home_page_trending_posts_options',
			'type'            => 'color',
			'active_callback' => 'eximious_magazine_is_trending_posts_enabled',
		)
	)
);

// Trending Posts Text.
$wp_customize->add_setting(
	'trending_post_text',
	array(
		'default'           => $theme_options_defaults['trending_post_text'],
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'trending_post_text',
	array(
		'label'           => __( 'Trending Posts Text', 'eximious-magazine' ),
		'description'     => __( 'Leave empty if you want to use the default text "Trending Now".', 'eximious-magazine' ),
		'section'         => 'home_page_trending_posts_options',
		'type'            => 'text',
		'active_callback' => 'eximious_magazine_is_trending_posts_enabled',
	)
);

// Trending Posts Uppercase.
$wp_customize->add_setting(
	'trending_posts_text_uppercase',
	array(
		'default'           => $theme_options_defaults['trending_posts_text_uppercase'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'trending_posts_text_uppercase',
		array(
			'label'           => __( 'Uppercase Trending Posts Text', 'eximious-magazine' ),
			'section'         => 'home_page_trending_posts_options',
			'active_callback' => 'eximious_magazine_is_trending_posts_enabled',
		)
	)
);

// Text background.
$wp_customize->add_setting(
	'trending_post_text_bg_color',
	array(
		'default'           => $theme_options_defaults['trending_post_text_bg_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'trending_post_text_bg_color',
		array(
			'label'           => __( 'Trending Posts Text Background', 'eximious-magazine' ),
			'section'         => 'home_page_trending_posts_options',
			'type'            => 'color',
			'active_callback' => 'eximious_magazine_is_trending_posts_enabled',
		)
	)
);

// Text Color.
$wp_customize->add_setting(
	'trending_post_text_color',
	array(
		'default'           => $theme_options_defaults['trending_post_text_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'trending_post_text_color',
		array(
			'label'           => __( 'Trending Posts Text Color', 'eximious-magazine' ),
			'section'         => 'home_page_trending_posts_options',
			'type'            => 'color',
			'active_callback' => 'eximious_magazine_is_trending_posts_enabled',
		)
	)
);

// Trending Posts Category.
$wp_customize->add_setting(
	'trending_post_cat',
	array(
		'default'           => $theme_options_defaults['trending_post_cat'],
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Dropdown_Taxonomies_Control(
		$wp_customize,
		'trending_post_cat',
		array(
			'label'           => __( 'Choose Trending posts category', 'eximious-magazine' ),
			'section'         => 'home_page_trending_posts_options',
			'active_callback' => 'eximious_magazine_is_trending_posts_enabled',
		)
	)
);

// No of posts.
$wp_customize->add_setting(
	'no_of_trending_posts',
	array(
		'default'           => $theme_options_defaults['no_of_trending_posts'],
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'no_of_trending_posts',
	array(
		'label'           => __( 'Number of Posts', 'eximious-magazine' ),
		'section'         => 'home_page_trending_posts_options',
		'type'            => 'number',
		'active_callback' => 'eximious_magazine_is_trending_posts_enabled',
	)
);

// Posts Orderby.
$wp_customize->add_setting(
	'trending_posts_orderby',
	array(
		'default'           => $theme_options_defaults['trending_posts_orderby'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'trending_posts_orderby',
	array(
		'label'           => __( 'Orderby', 'eximious-magazine' ),
		'section'         => 'home_page_trending_posts_options',
		'type'            => 'select',
		'choices'         => array(
			'date'  => __( 'Date', 'eximious-magazine' ),
			'id'    => __( 'ID', 'eximious-magazine' ),
			'title' => __( 'Title', 'eximious-magazine' ),
			'rand'  => __( 'Random', 'eximious-magazine' ),
		),
		'active_callback' => 'eximious_magazine_is_trending_posts_enabled',
	)
);

// Posts Order.
$wp_customize->add_setting(
	'trending_posts_order',
	array(
		'default'           => $theme_options_defaults['trending_posts_order'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'trending_posts_order',
	array(
		'label'           => __( 'Order', 'eximious-magazine' ),
		'section'         => 'home_page_trending_posts_options',
		'type'            => 'select',
		'choices'         => array(
			'asc'  => __( 'ASC', 'eximious-magazine' ),
			'desc' => __( 'DESC', 'eximious-magazine' ),
		),
		'active_callback' => 'eximious_magazine_is_trending_posts_enabled',
	)
);

/* Trending Posts Meta */
$wp_customize->add_setting(
	'trending_post_meta',
	array(
		'default'           => $theme_options_defaults['trending_post_meta'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox_multiple',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Checkbox_Multiple(
		$wp_customize,
		'trending_post_meta',
		array(
			'label'           => __( 'Trending Post Meta', 'eximious-magazine' ),
			'section'         => 'home_page_trending_posts_options',
			'choices'         => array(
				'date'  => __( 'Date', 'eximious-magazine' ),
				'thumb' => __( 'Thumbnail', 'eximious-magazine' ),
			),
			'active_callback' => 'eximious_magazine_is_trending_posts_enabled',
		)
	)
);

// Trending Post Date Format
$wp_customize->add_setting(
	'trending_posts_date_format',
	array(
		'default'           => $theme_options_defaults['trending_posts_date_format'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'trending_posts_date_format',
	array(
		'label'           => __( 'Date Format', 'eximious-magazine' ),
		'description'     => __( 'Make sure to enable Date post meta from above for this to work.', 'eximious-magazine' ),
		'section'         => 'home_page_trending_posts_options',
		'type'            => 'select',
		'choices'         => array(
			'format_1' => __( 'Times Ago', 'eximious-magazine' ),
			'format_2' => __( 'Default Format', 'eximious-magazine' ),
		),
		'active_callback' => 'eximious_magazine_is_trending_posts_enabled',
	)
);
