<?php
// Add Home Page Banner Section.
$wp_customize->add_section(
	'home_banner_options',
	array(
		'title' => __( 'Banner Options', 'eximious-magazine' ),
		'panel' => 'theme_home_option_panel',
	)
);

// Enable Banner Section.
$wp_customize->add_setting(
	'enable_banner',
	array(
		'default'           => $theme_options_defaults['enable_banner'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'enable_banner',
		array(
			'label'   => __( 'Enable Home Banner', 'eximious-magazine' ),
			'section' => 'home_banner_options',
		)
	)
);

// Banner section background.
$wp_customize->add_setting(
	'banner_section_bg_color',
	array(
		'default'           => $theme_options_defaults['banner_section_bg_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'banner_section_bg_color',
		array(
			'label'           => __( 'Banner Section Background', 'eximious-magazine' ),
			'section'         => 'home_banner_options',
			'type'            => 'color',
			'active_callback' => 'eximious_magazine_is_home_banner_enabled',
		)
	)
);

// Banner Title.
$wp_customize->add_setting(
	'banner_title',
	array(
		'default'           => $theme_options_defaults['banner_title'],
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'banner_title',
	array(
		'label'           => __( 'Banner Title', 'eximious-magazine' ),
		'description'     => __( 'Leave empty if you don\'t want to show the title.', 'eximious-magazine' ),
		'section'         => 'home_banner_options',
		'type'            => 'text',
		'active_callback' => 'eximious_magazine_is_home_banner_enabled',
	)
);

// Banner Title Style.
$wp_customize->add_setting(
	'banner_title_style',
	array(
		'default'           => $theme_options_defaults['banner_title_style'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'banner_title_style',
	array(
		'label'           => __( 'Banner Title Style', 'eximious-magazine' ),
		'section'         => 'home_banner_options',
		'type'            => 'select',
		'choices'         => eximious_magazine_get_title_styles(),
		'active_callback' => 'eximious_magazine_is_home_banner_enabled',
	)
);

// Banner Title Align.
$wp_customize->add_setting(
	'banner_title_align',
	array(
		'default'           => $theme_options_defaults['banner_title_align'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'banner_title_align',
	array(
		'label'           => __( 'Banner Title Alignment', 'eximious-magazine' ),
		'section'         => 'home_banner_options',
		'type'            => 'select',
		'choices'         => eximious_magazine_get_title_alignments(),
		'active_callback' => 'eximious_magazine_is_home_banner_enabled',
	)
);

// Banner Layout.
$wp_customize->add_setting(
	'banner_layout',
	array(
		'default'           => $theme_options_defaults['banner_layout'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'banner_layout',
	array(
		'label'           => __( 'Banner Layout', 'eximious-magazine' ),
		'section'         => 'home_banner_options',
		'type'            => 'select',
		'choices'         => array(
			'full-width' => __( 'FullWidth', 'eximious-magazine' ),
			'boxed'      => __( 'Boxed', 'eximious-magazine' ),
		),
		'active_callback' => 'eximious_magazine_is_home_banner_enabled',
	)
);

// Banner Display as slider/carousel.
$wp_customize->add_setting(
	'banner_display_as',
	array(
		'default'           => $theme_options_defaults['banner_display_as'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'banner_display_as',
	array(
		'label'           => __( 'Banner Display As', 'eximious-magazine' ),
		'section'         => 'home_banner_options',
		'type'            => 'select',
		'choices'         => array(
			'slider'   => __( 'Slider', 'eximious-magazine' ),
			'carousel' => __( 'Carousel', 'eximious-magazine' ),
		),
		'active_callback' => 'eximious_magazine_is_home_banner_enabled',
	)
);

// Banner Carousel gap.
$wp_customize->add_setting(
	'banner_carousel_item_gap',
	array(
		'default'           => $theme_options_defaults['banner_carousel_item_gap'],
		'sanitize_callback' => 'eximious_magazine_sanitize_float',
	)
);
$wp_customize->add_control(
	'banner_carousel_item_gap',
	array(
		'label'           => __( 'Carousel Item Gap', 'eximious-magazine' ),
		'section'         => 'home_banner_options',
		'type'            => 'number',
		'input_attrs'     => array(
			'min'   => 0,
			'max'   => 100,
			'step'  => 1,
			'style' => 'width: 150px;',
		),
		'active_callback' => function ( $control ) {
			return (
				eximious_magazine_is_home_banner_enabled( $control )
				&&
				eximious_magazine_is_home_banner_as_carousel( $control )
			);
		},
	)
);

// Banner Content from ids or category.
$wp_customize->add_setting(
	'banner_content_from',
	array(
		'default'           => $theme_options_defaults['banner_content_from'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'banner_content_from',
	array(
		'label'           => __( 'Get Banner Content From', 'eximious-magazine' ),
		'section'         => 'home_banner_options',
		'type'            => 'select',
		'choices'         => array(
			'category' => __( 'Category', 'eximious-magazine' ),
			'post_ids' => __( 'Post ID\'s', 'eximious-magazine' ),
		),
		'active_callback' => 'eximious_magazine_is_home_banner_enabled',
	)
);

// Banner Post Category.
$wp_customize->add_setting(
	'slider_cat',
	array(
		'default'           => $theme_options_defaults['slider_cat'],
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Dropdown_Taxonomies_Control(
		$wp_customize,
		'slider_cat',
		array(
			'label'           => __( 'Choose Category', 'eximious-magazine' ),
			'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'eximious-magazine' ),
			'section'         => 'home_banner_options',
			'active_callback' => function( $control ) {
				return (
					eximious_magazine_is_home_banner_enabled( $control )
					&&
					eximious_magazine_banner_content_from_category( $control )
				);
			},
		)
	)
);

// No of posts.
$wp_customize->add_setting(
	'no_of_banner_posts',
	array(
		'default'           => $theme_options_defaults['no_of_banner_posts'],
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'no_of_banner_posts',
	array(
		'label'           => __( 'Number of Posts', 'eximious-magazine' ),
		'section'         => 'home_banner_options',
		'type'            => 'number',
		'active_callback' => function( $control ) {
			return (
				eximious_magazine_is_home_banner_enabled( $control )
				&&
				eximious_magazine_banner_content_from_category( $control )
			);
		},
	)
);

// Posts Orderby.
$wp_customize->add_setting(
	'banner_posts_orderby',
	array(
		'default'           => $theme_options_defaults['banner_posts_orderby'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'banner_posts_orderby',
	array(
		'label'           => __( 'Orderby', 'eximious-magazine' ),
		'section'         => 'home_banner_options',
		'type'            => 'select',
		'choices'         => array(
			'date'  => __( 'Date', 'eximious-magazine' ),
			'id'    => __( 'ID', 'eximious-magazine' ),
			'title' => __( 'Title', 'eximious-magazine' ),
			'rand'  => __( 'Random', 'eximious-magazine' ),
		),
		'active_callback' => function( $control ) {
			return (
				eximious_magazine_is_home_banner_enabled( $control )
				&&
				eximious_magazine_banner_content_from_category( $control )
			);
		},
	)
);

// Posts Order.
$wp_customize->add_setting(
	'banner_posts_order',
	array(
		'default'           => $theme_options_defaults['banner_posts_order'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'banner_posts_order',
	array(
		'label'           => __( 'Order', 'eximious-magazine' ),
		'section'         => 'home_banner_options',
		'type'            => 'select',
		'choices'         => array(
			'asc'  => __( 'ASC', 'eximious-magazine' ),
			'desc' => __( 'DESC', 'eximious-magazine' ),
		),
		'active_callback' => function( $control ) {
			return (
				eximious_magazine_is_home_banner_enabled( $control )
				&&
				eximious_magazine_banner_content_from_category( $control )
			);
		},
	)
);

// Banner Post IDs.
$wp_customize->add_setting(
	'banner_post_ids',
	array(
		'default'           => $theme_options_defaults['banner_post_ids'],
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'banner_post_ids',
	array(
		'label'           => __( 'Post ID\'s', 'eximious-magazine' ),
		'description'     => __( 'Comma ( , ) separated posts ids. Ex: 1, 2, 3', 'eximious-magazine' ),
		'section'         => 'home_banner_options',
		'type'            => 'text',
		'active_callback' => function( $control ) {
			return (
				eximious_magazine_is_home_banner_enabled( $control )
				&&
				eximious_magazine_banner_content_from_post_ids( $control )
			);
		},
	)
);

// Enable Banner Autoplay.
$wp_customize->add_setting(
	'enable_banner_autoplay',
	array(
		'default'           => $theme_options_defaults['enable_banner_autoplay'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'enable_banner_autoplay',
		array(
			'label'           => __( 'Enable Banner Autoplay', 'eximious-magazine' ),
			'section'         => 'home_banner_options',
			'active_callback' => 'eximious_magazine_is_home_banner_enabled',
		)
	)
);

// Enable Banner Arrows.
$wp_customize->add_setting(
	'enable_banner_arrows',
	array(
		'default'           => $theme_options_defaults['enable_banner_arrows'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'enable_banner_arrows',
		array(
			'label'           => __( 'Enable Banner Arrows', 'eximious-magazine' ),
			'section'         => 'home_banner_options',
			'active_callback' => 'eximious_magazine_is_home_banner_enabled',
		)
	)
);

// Banner Arrows background.
$wp_customize->add_setting(
	'banner_arrows_bg_color',
	array(
		'default'           => $theme_options_defaults['banner_arrows_bg_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'banner_arrows_bg_color',
		array(
			'label'           => __( 'Banner Arrows Background', 'eximious-magazine' ),
			'section'         => 'home_banner_options',
			'type'            => 'color',
			'active_callback' => function( $control ) {
				return (
					eximious_magazine_is_home_banner_enabled( $control )
					&&
					eximious_magazine_is_home_banner_arrows_enabled( $control )
				);
			},
		)
	)
);

// Enable Banner Dots.
$wp_customize->add_setting(
	'enable_banner_dots',
	array(
		'default'           => $theme_options_defaults['enable_banner_dots'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'enable_banner_dots',
		array(
			'label'           => __( 'Enable Banner Dots', 'eximious-magazine' ),
			'section'         => 'home_banner_options',
			'active_callback' => 'eximious_magazine_is_home_banner_enabled',
		)
	)
);

// Enable Banner Overlay.
$wp_customize->add_setting(
	'enable_banner_overlay',
	array(
		'default'           => $theme_options_defaults['enable_banner_overlay'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'enable_banner_overlay',
		array(
			'label'           => __( 'Show Banner Overlay', 'eximious-magazine' ),
			'section'         => 'home_banner_options',
			'active_callback' => 'eximious_magazine_is_home_banner_enabled',
		)
	)
);

// Banner overlay color.
$wp_customize->add_setting(
	'banner_overlay_color',
	array(
		'default'           => $theme_options_defaults['banner_overlay_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'banner_overlay_color',
		array(
			'label'           => __( 'Overlay Color', 'eximious-magazine' ),
			'section'         => 'home_banner_options',
			'type'            => 'color',
			'active_callback' => function( $control ) {
				return (
					eximious_magazine_is_home_banner_enabled( $control )
					&&
					eximious_magazine_is_banner_overlay_enabled( $control )
				);
			},
		)
	)
);

// Banner Overlay Opacity.
$wp_customize->add_setting(
	'banner_overlay_opacity',
	array(
		'default'           => $theme_options_defaults['banner_overlay_opacity'],
		'sanitize_callback' => 'eximious_magazine_sanitize_float',
	)
);
$wp_customize->add_control(
	'banner_overlay_opacity',
	array(
		'label'           => __( 'Overlay Opacity', 'eximious-magazine' ),
		'section'         => 'home_banner_options',
		'type'            => 'number',
		'input_attrs'     => array(
			'min'   => 0,
			'max'   => 1,
			'step'  => 0.1,
			'style' => 'width: 150px;',
		),
		'active_callback' => function( $control ) {
			return (
				eximious_magazine_is_home_banner_enabled( $control )
				&&
				eximious_magazine_is_banner_overlay_enabled( $control )
			);
		},
	)
);

// Show Banner Category.
$wp_customize->add_setting(
	'show_banner_category',
	array(
		'default'           => $theme_options_defaults['show_banner_category'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'show_banner_category',
		array(
			'label'           => __( 'Show Banner Category', 'eximious-magazine' ),
			'section'         => 'home_banner_options',
			'active_callback' => 'eximious_magazine_is_home_banner_enabled',
		)
	)
);

// Banner Category Color Display.
$wp_customize->add_setting(
	'banner_category_color_display',
	array(
		'default'           => $theme_options_defaults['banner_category_color_display'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'banner_category_color_display',
	array(
		'label'           => __( 'Banner Category Color Display', 'eximious-magazine' ),
		'section'         => 'home_banner_options',
		'type'            => 'select',
		'choices'         => eximious_magazine_get_category_color_display(),
		'active_callback' => function( $control ) {
			return (
				eximious_magazine_is_home_banner_enabled( $control )
				&&
				eximious_magazine_is_banner_category_enabled( $control )
			);
		},
	)
);

// Banner Category Style.
$wp_customize->add_setting(
	'banner_category_style',
	array(
		'default'           => $theme_options_defaults['banner_category_style'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'banner_category_style',
	array(
		'label'           => __( 'Banner Category Style', 'eximious-magazine' ),
		'section'         => 'home_banner_options',
		'type'            => 'select',
		'choices'         => eximious_magazine_get_category_styles(),
		'active_callback' => function( $control ) {
			return (
				eximious_magazine_is_home_banner_enabled( $control )
				&&
				eximious_magazine_is_banner_category_enabled( $control )
			);
		},
	)
);

// No of Banner Categories.
$wp_customize->add_setting(
	'banner_category_limit',
	array(
		'default'           => $theme_options_defaults['banner_category_limit'],
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'banner_category_limit',
	array(
		'label'           => __( 'Number of Categories To Display', 'eximious-magazine' ),
		'section'         => 'home_banner_options',
		'type'            => 'number',
		'active_callback' => function( $control ) {
			return (
				eximious_magazine_is_home_banner_enabled( $control )
				&&
				eximious_magazine_is_banner_category_enabled( $control )
			);
		},
	)
);

/* Banner Posts Meta */
$wp_customize->add_setting(
	'banner_post_meta',
	array(
		'default'           => $theme_options_defaults['banner_post_meta'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox_multiple',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Checkbox_Multiple(
		$wp_customize,
		'banner_post_meta',
		array(
			'label'           => __( 'Banner Post Meta', 'eximious-magazine' ),
			'section'         => 'home_banner_options',
			'choices'         => array(
				'author'    => __( 'Author', 'eximious-magazine' ),
				'read_time' => __( 'Post Read Time', 'eximious-magazine' ),
				'date'      => __( 'Date', 'eximious-magazine' ),
				'comment'   => __( 'Comment', 'eximious-magazine' ),
			),
			'active_callback' => 'eximious_magazine_is_home_banner_enabled',
		)
	)
);

// Banner Date Format
$wp_customize->add_setting(
	'banner_posts_date_format',
	array(
		'default'           => $theme_options_defaults['banner_posts_date_format'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'banner_posts_date_format',
	array(
		'label'           => __( 'Date Format', 'eximious-magazine' ),
		'description'     => __( 'Make sure to enable Date post meta from above for this to work.', 'eximious-magazine' ),
		'section'         => 'home_banner_options',
		'type'            => 'select',
		'choices'         => array(
			'format_1' => __( 'Times Ago', 'eximious-magazine' ),
			'format_2' => __( 'Default Format', 'eximious-magazine' ),
		),
		'active_callback' => 'eximious_magazine_is_home_banner_enabled',
	)
);

// Show Banner author image.
$wp_customize->add_setting(
	'enable_banner_author_image',
	array(
		'default'           => $theme_options_defaults['enable_banner_author_image'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'enable_banner_author_image',
		array(
			'label'           => __( 'Show Author Image', 'eximious-magazine' ),
			'description'     => __( 'Make sure to enable Author post meta from above for this to work.', 'eximious-magazine' ),
			'section'         => 'home_banner_options',
			'active_callback' => 'eximious_magazine_is_home_banner_enabled',
		)
	)
);

// Post Title Limit.
$wp_customize->add_setting(
	'banner_posts_title_limit',
	array(
		'default'           => '',
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'banner_posts_title_limit',
	array(
		'label'           => __( 'Post Title Limit', 'eximious-magazine' ),
		'section'         => 'home_banner_options',
		'type'            => 'select',
		'choices'         => eximious_magazine_get_title_limit_choices(),
		'active_callback' => 'eximious_magazine_is_home_banner_enabled',
	)
);

// Show Banner desc.
$wp_customize->add_setting(
	'enable_banner_desc',
	array(
		'default'           => $theme_options_defaults['enable_banner_desc'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'enable_banner_desc',
		array(
			'label'           => __( 'Show Banner Description', 'eximious-magazine' ),
			'section'         => 'home_banner_options',
			'active_callback' => 'eximious_magazine_is_home_banner_enabled',
		)
	)
);

// Banner desc length.
$wp_customize->add_setting(
	'banner_desc_length',
	array(
		'default'           => $theme_options_defaults['banner_desc_length'],
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'banner_desc_length',
	array(
		'label'           => __( 'Banner Description Length', 'eximious-magazine' ),
		'section'         => 'home_banner_options',
		'type'            => 'number',
		'active_callback' => 'eximious_magazine_is_home_banner_enabled',
	)
);

// Show Banner read more.
$wp_customize->add_setting(
	'enable_banner_read_more_btn',
	array(
		'default'           => $theme_options_defaults['enable_banner_read_more_btn'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'enable_banner_read_more_btn',
		array(
			'label'           => __( 'Show Banner Read More', 'eximious-magazine' ),
			'section'         => 'home_banner_options',
			'active_callback' => 'eximious_magazine_is_home_banner_enabled',
		)
	)
);

// Read More Text.
$wp_customize->add_setting(
	'banner_read_more_btn_text',
	array(
		'default'           => $theme_options_defaults['banner_read_more_btn_text'],
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'banner_read_more_btn_text',
	array(
		'label'           => __( 'Banner Title', 'eximious-magazine' ),
		'description'     => __( 'Leave empty if you want to use the default text "Read more".', 'eximious-magazine' ),
		'section'         => 'home_banner_options',
		'type'            => 'text',
		'active_callback' => 'eximious_magazine_is_home_banner_enabled',
	)
);
