<?php

$widgets_link = admin_url( 'widgets.php' );

$wp_customize->add_section(
	'footer_options',
	array(
		'title' => __( 'Footer Options', 'eximious-magazine' ),
		'panel' => 'footer_options_panel',
	)
);

// Footer Theme.
$wp_customize->add_setting(
	'footer_theme',
	array(
		'default'           => $theme_options_defaults['footer_theme'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'footer_theme',
	array(
		'label'   => __( 'Footer Theme', 'eximious-magazine' ),
		'section' => 'footer_options',
		'type'    => 'select',
		'choices' => array(
			'light' => __( 'Light', 'eximious-magazine' ),
			'dark'   => __( 'Dark', 'eximious-magazine' ),
		),
	)
);

// Light Footer Background Color.
$wp_customize->add_setting(
	'footer_bg_color',
	array(
		'default'           => $theme_options_defaults['footer_bg_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'footer_bg_color',
		array(
			'label'   => __( 'Light Theme Background', 'eximious-magazine' ),
			'section' => 'footer_options',
			'type'    => 'color',
			'active_callback' => 'eximious_magazine_is_light_footer',
		)
	)
);

// Dark Footer Background Color.
$wp_customize->add_setting(
	'dark_footer_bg_color',
	array(
		'default'           => $theme_options_defaults['dark_footer_bg_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'dark_footer_bg_color',
		array(
			'label'   => __( 'Dark Theme Background', 'eximious-magazine' ),
			'section' => 'footer_options',
			'type'    => 'color',
			'active_callback' => 'eximious_magazine_is_dark_footer',
		)
	)
);

// Option to choose footer column layout.
$wp_customize->add_setting(
	'footer_column_layout',
	array(
		'default'           => $theme_options_defaults['footer_column_layout'],
		'sanitize_callback' => 'eximious_magazine_sanitize_radio',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Radio_Image_Control(
		$wp_customize,
		'footer_column_layout',
		array(
			'label'       => __( 'Footer Column Layout', 'eximious-magazine' ),
			'description' => __('Some footer widgetareas will not be used based on the footer column layout chosen. Also make sure to insert at least one widget on the respective widgetarea for it to display.', 'eximious-magazine'),
			'section'     => 'footer_options',
			'choices'     => eximious_magazine_get_footer_layouts(),
		)
	)
);

/* Footer Widget heading style */
$wp_customize->add_setting(
	'footer_widget_heading_style',
	array(
		'default'           => $theme_options_defaults['footer_widget_heading_style'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'footer_widget_heading_style',
	array(
		'label'   => __( 'Footer Widgets Title Style', 'eximious-magazine' ),
		'section' => 'footer_options',
		'type'    => 'select',
		'choices' => eximious_magazine_get_title_styles(),
	)
);

/* Footer Widget heading Align */
$wp_customize->add_setting(
	'footer_widget_heading_align',
	array(
		'default'           => $theme_options_defaults['footer_widget_heading_align'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'footer_widget_heading_align',
	array(
		'label'   => __( 'Footer Widgets Title Alignment', 'eximious-magazine' ),
		'section' => 'footer_options',
		'type'    => 'select',
		'choices' => eximious_magazine_get_title_alignments(),
	)
);

// Enable Footer Background Image.
$wp_customize->add_setting(
	'enable_footer_bg_image',
	array(
		'default'           => $theme_options_defaults['enable_footer_bg_image'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'enable_footer_bg_image',
		array(
			'label'   => __( 'Enable Footer Background Image', 'eximious-magazine' ),
			'section' => 'footer_options',
		)
	)
);

// Footer background Image.
$wp_customize->add_setting(
	'footer_bg_image',
	array(
		'default'           => $theme_options_defaults['footer_bg_image'],
		'sanitize_callback' => 'eximious_magazine_sanitize_image',
	)
);
$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize,
		'footer_bg_image',
		array(
			'label'           => __( 'Footer Background Image', 'eximious-magazine' ),
			'section'         => 'footer_options',
			'active_callback' => 'eximious_magazine_is_footer_bg_enabled',
		)
	)
);

// Footer Background Image Overlay Color.
$wp_customize->add_setting(
	'footer_bg_image_overlay_color',
	array(
		'default'           => $theme_options_defaults['footer_bg_image_overlay_color'],
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'footer_bg_image_overlay_color',
		array(
			'label'           => __( 'Image Overlay', 'eximious-magazine' ),
			'section'         => 'footer_options',
			'type'            => 'color',
			'active_callback' => 'eximious_magazine_is_footer_bg_enabled',
		)
	)
);

// Footer background Image Opacity.
$wp_customize->add_setting(
	'footer_bg_image_opacity',
	array(
		'default'           => $theme_options_defaults['footer_bg_image_opacity'],
		'sanitize_callback' => 'eximious_magazine_sanitize_float',
	)
);
$wp_customize->add_control(
	'footer_bg_image_opacity',
	array(
		'label'           => __( 'Overlay Opacity', 'eximious-magazine' ),
		'section'         => 'footer_options',
		'type'            => 'number',
		'input_attrs'     => array(
			'min'   => 0,
			'max'   => 1,
			'step'  => 0.1,
			'style' => 'width: 150px;',
		),
		'active_callback' => 'eximious_magazine_is_footer_bg_enabled',
	)
);

// Enable Fixed Footer Background Image.
$wp_customize->add_setting(
	'footer_fixed_bg_image',
	array(
		'default'           => $theme_options_defaults['footer_fixed_bg_image'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'footer_fixed_bg_image',
		array(
			'label'           => __( 'Fixed Image Background', 'eximious-magazine' ),
			'section'         => 'footer_options',
			'active_callback' => 'eximious_magazine_is_footer_bg_enabled',
		)
	)
);

// Enable Border Top.
$wp_customize->add_setting(
	'enable_border_above_footer',
	array(
		'default'           => $theme_options_defaults['enable_border_above_footer'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'enable_border_above_footer',
		array(
			'label'   => __( 'Enable a Border Above Footer', 'eximious-magazine' ),
			'section' => 'footer_options',
		)
	)
);
