<?php

$wp_customize->add_section(
	'excerpt_options',
	array(
		'title' => __( 'Global Excerpt Options', 'eximious-magazine' ),
		'panel' => 'blog_options_panel',
	)
);

/* Excerpt Length */
$wp_customize->add_setting(
	'excerpt_length',
	array(
		'default'           => $theme_options_defaults['excerpt_length'],
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'excerpt_length',
	array(
		'label'   => __( 'Excerpt Length', 'eximious-magazine' ),
		'section' => 'excerpt_options',
		'type'    => 'number',
	)
);

/* Excerpt Read More Text */
$wp_customize->add_setting(
	'excerpt_read_more_text',
	array(
		'default'           => $theme_options_defaults['excerpt_read_more_text'],
		'sanitize_callback' => 'wp_filter_nohtml_kses',
	)
);
$wp_customize->add_control(
	'excerpt_read_more_text',
	array(
		'label'       => __( 'Read More Text', 'eximious-magazine' ),
		'description' => __( 'Leave empty if you want to use default text "Read more".', 'eximious-magazine' ),
		'section'     => 'excerpt_options',
		'type'        => 'text',
	)
);

// Read More Icon.
$wp_customize->add_setting(
	'excerpt_read_more_icon',
	array(
		'default'           => $theme_options_defaults['excerpt_read_more_icon'],
		'sanitize_callback' => 'eximious_magazine_sanitize_radio',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Radio_Image_Control(
		$wp_customize,
		'excerpt_read_more_icon',
		array(
			'label'   => __( 'Read More Icon', 'eximious-magazine' ),
			'section' => 'excerpt_options',
			'choices' => array(
				''                        => array(
					'url'   => get_template_directory_uri() . '/assets/images/circle-backslash.svg',
					'label' => esc_html__( 'None', 'eximious-magazine' ),
				),
				'arrow-bar-right'         => array(
					'url'   => get_template_directory_uri() . '/assets/images/arrow-bar-right.svg',
					'label' => esc_html__( 'Arrow Bar Right', 'eximious-magazine' ),
				),
				'arrow-right'             => array(
					'url'   => get_template_directory_uri() . '/assets/images/arrow-right.svg',
					'label' => esc_html__( 'Arrow Right', 'eximious-magazine' ),
				),
				'arrow-right-circle'      => array(
					'url'   => get_template_directory_uri() . '/assets/images/arrow-right-circle.svg',
					'label' => esc_html__( 'Arrow Right Circle', 'eximious-magazine' ),
				),
				'arrow-right-circle-fill' => array(
					'url'   => get_template_directory_uri() . '/assets/images/arrow-right-circle-fill.svg',
					'label' => esc_html__( 'Arrow Right Circle Fill', 'eximious-magazine' ),
				),
				'chevron-right'           => array(
					'url'   => get_template_directory_uri() . '/assets/images/chevron-right.svg',
					'label' => esc_html__( 'Chevron Right', 'eximious-magazine' ),
				),
				'chevron-double-right'    => array(
					'url'   => get_template_directory_uri() . '/assets/images/chevron-double-right.svg',
					'label' => esc_html__( 'Chevron Double Right', 'eximious-magazine' ),
				),
				'caret-right'             => array(
					'url'   => get_template_directory_uri() . '/assets/images/caret-right.svg',
					'label' => esc_html__( 'Caret Right', 'eximious-magazine' ),
				),
				'caret-right-fill'        => array(
					'url'   => get_template_directory_uri() . '/assets/images/caret-right-fill.svg',
					'label' => esc_html__( 'Caret Right Fill', 'eximious-magazine' ),
				),
			),
		)
	)
);
