<?php
$wp_customize->add_section(
	'archive_options',
	array(
		'title' => __( 'Archive Post Options', 'eximious-magazine' ),
		'panel' => 'blog_options_panel',
	)
);

/* Archive Style */
$wp_customize->add_setting(
	'archive_style',
	array(
		'default'           => $theme_options_defaults['archive_style'],
		'sanitize_callback' => 'eximious_magazine_sanitize_radio',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Radio_Image_Control(
		$wp_customize,
		'archive_style',
		array(
			'label'   => __( 'Archive Style', 'eximious-magazine' ),
			'section' => 'archive_options',
			'choices' => eximious_magazine_get_archive_layouts(),
		)
	)
);

/*Archive Pagination Type*/
$wp_customize->add_setting(
	'pagination_type',
	array(
		'default'           => $theme_options_defaults['pagination_type'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'pagination_type',
	array(
		'label'   => __( 'Archive Pagination Type', 'eximious-magazine' ),
		'section' => 'archive_options',
		'type'    => 'select',
		'choices' => array(
			'default'             => __( 'Default (Older / Newer Post)', 'eximious-magazine' ),
			'numeric'             => __( 'Numeric', 'eximious-magazine' ),
			'button_click_load'  => __( 'Load more post on click', 'eximious-magazine' ),
			'infinite_scroll_load' => __( 'Load more posts on scroll', 'eximious-magazine' ),
		),
	)
);

// Center pagination.
$wp_customize->add_setting(
	'center_aligned_pagination',
	array(
		'default'           => $theme_options_defaults['center_aligned_pagination'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'center_aligned_pagination',
		array(
			'label'       => __( 'Center Align Pagination', 'eximious-magazine' ),
			'section'     => 'archive_options',
		)
	)
);

/* Archive Meta */
$wp_customize->add_setting(
	'archive_post_meta',
	array(
		'default'           => $theme_options_defaults['archive_post_meta'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox_multiple',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Checkbox_Multiple(
		$wp_customize,
		'archive_post_meta',
		array(
			'label'       => __( 'Archive Post Meta', 'eximious-magazine' ),
			'description' => __(
				'Choose the post meta you want to be displayed on archive post listings.
            Some meta values may not show on front end in case of certain archive style or if post have post-formats.',
				'eximious-magazine'
			),
			'section'     => 'archive_options',
			'choices'     => array(
				'author'    => __( 'Author', 'eximious-magazine' ),
				'read_time' => __( 'Post Read Time', 'eximious-magazine' ),
				'date'      => __( 'Date', 'eximious-magazine' ),
				'comment'   => __( 'Comment', 'eximious-magazine' ),
				'category'  => __( 'Category', 'eximious-magazine' ),
				'tags'      => __( 'Tags', 'eximious-magazine' ),
			),
		)
	)
);

// Archive Post Date Format.
$wp_customize->add_setting(
	'archive_date_format',
	array(
		'default'           => $theme_options_defaults['archive_date_format'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'archive_date_format',
	array(
		'label'       => __( 'Date Format', 'eximious-magazine' ),
		'description' => __( 'Make sure to enable Date post meta from above for this to work.', 'eximious-magazine' ),
		'section'     => 'archive_options',
		'type'        => 'select',
		'choices'     => array(
			'format_1' => __( 'Times Ago', 'eximious-magazine' ),
			'format_2' => __( 'Default Format', 'eximious-magazine' ),
		),
	)
);

// Show Archive Post author image.
$wp_customize->add_setting(
	'enable_archive_author_image',
	array(
		'default'           => $theme_options_defaults['enable_archive_author_image'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'enable_archive_author_image',
		array(
			'label'       => __( 'Show Author Image', 'eximious-magazine' ),
			'description' => __( 'Make sure to enable Author post meta from above for this to work.', 'eximious-magazine' ),
			'section'     => 'archive_options',
		)
	)
);

// Show Archive Category Label.
$wp_customize->add_setting(
	'enable_archive_cat_label',
	array(
		'default'           => $theme_options_defaults['enable_archive_cat_label'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'enable_archive_cat_label',
		array(
			'label'       => __( 'Show Category Label', 'eximious-magazine' ),
			'description' => __( 'Make sure to enable Category post meta from above for this to work.', 'eximious-magazine' ),
			'section'     => 'archive_options',
		)
	)
);

// Archive Category Color Display.
$wp_customize->add_setting(
	'archive_category_color_display',
	array(
		'default'           => $theme_options_defaults['archive_category_color_display'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'archive_category_color_display',
	array(
		'label'   => __( 'Archive Category Color Display', 'eximious-magazine' ),
		'section' => 'archive_options',
		'type'    => 'select',
		'choices' => eximious_magazine_get_category_color_display(),
	)
);

/* Category Style in Archive Page*/
$wp_customize->add_setting(
	'archive_category_style',
	array(
		'default'           => $theme_options_defaults['archive_category_style'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'archive_category_style',
	array(
		'label'   => __( 'Archive Category Style', 'eximious-magazine' ),
		'section' => 'archive_options',
		'type'    => 'select',
		'choices' => eximious_magazine_get_category_styles(),
	)
);

// No of Archive Categories.
$wp_customize->add_setting(
	'archive_category_limit',
	array(
		'default'           => $theme_options_defaults['archive_category_limit'],
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'archive_category_limit',
	array(
		'label'       => __( 'Limit Categories To Display', 'eximious-magazine' ),
		'description' => __( 'Use 0 for no limit.', 'eximious-magazine' ),
		'section'     => 'archive_options',
		'type'        => 'number',
	)
);

// Archive Category Position.
$wp_customize->add_setting(
	'archive_category_position',
	array(
		'default'           => $theme_options_defaults['archive_category_position'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'archive_category_position',
	array(
		'label'   => __( 'Archive Category Position', 'eximious-magazine' ),
		'section' => 'archive_options',
		'type'    => 'select',
		'choices' => array(
			'before_title'  => __( 'Before Title', 'eximious-magazine' ),
			'after_excerpt' => __( 'After Excerpt', 'eximious-magazine' ),
		),

	)
);

// Show Archive Tag Label.
$wp_customize->add_setting(
	'enable_archive_tag_label',
	array(
		'default'           => $theme_options_defaults['enable_archive_tag_label'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'enable_archive_tag_label',
		array(
			'label'       => __( 'Show Tag Label', 'eximious-magazine' ),
			'description' => __( 'Make sure to enable Tags post meta from above for this to work.', 'eximious-magazine' ),
			'section'     => 'archive_options',
		)
	)
);

/* Tag Style in Archive Page*/
$wp_customize->add_setting(
	'archive_tag_style',
	array(
		'default'           => $theme_options_defaults['archive_tag_style'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'archive_tag_style',
	array(
		'label'   => __( 'Archive Tag Style', 'eximious-magazine' ),
		'section' => 'archive_options',
		'type'    => 'select',
		'choices' => eximious_magazine_get_tag_styles(),
	)
);

// No of Archive Tags.
$wp_customize->add_setting(
	'archive_tag_limit',
	array(
		'default'           => $theme_options_defaults['archive_tag_limit'],
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'archive_tag_limit',
	array(
		'label'       => __( 'Limit Tags To Display', 'eximious-magazine' ),
		'description' => __( 'Use 0 for no limit.', 'eximious-magazine' ),
		'section'     => 'archive_options',
		'type'        => 'number',
	)
);

// Show Post Format Icon.
$wp_customize->add_setting(
	'show_archive_post_format_icon',
	array(
		'default'           => $theme_options_defaults['show_archive_post_format_icon'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'show_archive_post_format_icon',
		array(
			'label'       => __( 'Show Post Format Icon', 'eximious-magazine' ),
			'description' => __( 'Will not display on certain archive styles.', 'eximious-magazine' ),
			'section'     => 'archive_options',
		)
	)
);

// Archive Posts Title Limit.
$wp_customize->add_setting(
	'archive_posts_title_limit',
	array(
		'default'           => '',
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'archive_posts_title_limit',
	array(
		'label'           => __( 'Post Title Limit', 'eximious-magazine' ),
		'section'         => 'archive_options',
		'type'            => 'select',
		'choices'         => eximious_magazine_get_title_limit_choices(),
	)
);

// Show Excerpt.
$wp_customize->add_setting(
	'show_archive_excerpt',
	array(
		'default'           => $theme_options_defaults['show_archive_excerpt'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'show_archive_excerpt',
		array(
			'label'       => __( 'Show Excerpt', 'eximious-magazine' ),
			'description' => __( 'Will not display on certain post formats and archive styles.', 'eximious-magazine' ),
			'section'     => 'archive_options',
		)
	)
);

// Show Read More.
$wp_customize->add_setting(
	'show_archive_read_more',
	array(
		'default'           => $theme_options_defaults['show_archive_read_more'],
		'sanitize_callback' => 'eximious_magazine_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Eximious_Magazine_Toggle_Control(
		$wp_customize,
		'show_archive_read_more',
		array(
			'label'       => __( 'Show Read More', 'eximious-magazine' ),
			'description' => __( 'Will not display on certain post formats and archive styles.', 'eximious-magazine' ),
			'section'     => 'archive_options',
		)
	)
);

// Read more stlye.
$wp_customize->add_setting(
	'archive_read_more_style',
	array(
		'default'           => $theme_options_defaults['archive_read_more_style'],
		'sanitize_callback' => 'eximious_magazine_sanitize_select',
	)
);
$wp_customize->add_control(
	'archive_read_more_style',
	array(
		'label'           => __( 'Read More Style', 'eximious-magazine' ),
		'section'         => 'archive_options',
		'type'            => 'select',
		'choices'         => eximious_magazine_get_read_more_styles(),
		'active_callback' => 'eximious_magazine_is_archive_read_more_enabled',
	)
);
