<?php
/**
 * Custom Customizer Controls.
 *
 * @package Eximious_Magazine
 */

/**
 * Customize Control for Upgrade Info.
 *
 * @since 1.0.0
 *
 * @see WP_Customize_Control
 */
class Eximious_Magazine_Upgrade_Info extends WP_Customize_Control {

	/**
	 * Control type.
	 *
	 * @access public
	 * @var string
	 */
	public $type = 'upgrade-info';

	/**
	 * Displays the control content.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function render_content() {
		?>

		<?php if ( ! empty( $this->label ) ) : ?>
			<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
		<?php endif; ?>

		<?php if ( ! empty( $this->description ) ) : ?>
			<span class="description customize-control-description"><?php echo $this->description; ?></span>
		<?php endif; ?>

		<?php if ( ! empty( $this->choices ) ) : ?>
			<ul>
				<?php foreach ( $this->choices as $choice ) : ?>
					<li><?php echo esc_html( $choice ); ?></li>
				<?php endforeach; ?>
			</ul>
		<?php endif; ?>
		
		<?php
	}
}