<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Eximious_Magazine
 */

get_header();
?>

<main id="site-content" role="main">

	<div id="primary" class="content-area">
		
		<div class="wrapper default-max-width">

			<h1 class="archive-title"><?php esc_html_e( 'Page Not Found', 'eximious-magazine' ); ?></h1>

			<div class="archive-subtitle">
				<p>
					<?php esc_html_e( 'Oops! That page can&rsquo;t be found.Maybe try search?', 'eximious-magazine' ); ?>
				</p>
			</div>

			<?php get_search_form(); ?>

			<div class="go-back">
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
					<?php eximious_magazine_the_theme_svg( 'home' ); ?>
					<?php esc_html_e( 'Return to Homepage', 'eximious-magazine' ); ?>
				</a>
			</div>

		</div>

	</div>

</main><!-- #site-content -->

<?php
get_footer();
