<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package executive
 */

get_header(); ?>

<?php if ( get_header_image() && !is_single() && !is_page() ): ?>
<div class="header-image" style="background-image: url('<?php header_image(); ?>');"></div>
<?php endif;
// End header image check.
?>

<div class="wrap">

	<div id="primary" class="content-area">
		<main id="main" class="site-main">

			<?php if ( have_posts() ): ?>
				<?php while ( have_posts() ):
				the_post(); ?>

					<?php get_template_part( "template-parts/content", get_post_format() ); ?>

					<?php
					endwhile; ?>

				<?php the_posts_navigation(); ?>

			<?php else: ?>

				<?php get_template_part( "template-parts/content", "none" ); ?>

			<?php endif; ?>

		</main><!-- #main -->
	</div><!-- #primary -->

	<?php get_sidebar(); ?>

</div><!-- .wrap -->

<?php get_footer();
