<?php

/**
 * Theme About Page
 *
 * @package Euphony_Blocks
 * @since 1.0
 */

function euphony_blocks_admin_plugin_notice()
{

	if ( ! PAnD::euphony_blocks_is_admin_notice_active( 'notice-seven-7' ) ) {
		return;
	}

	$screen = get_current_screen();

	if (! empty($screen->base) && 'appearance_page_euphony-blocks-theme' === $screen->base) {
		return false;
	}
?>
	<div data-dismissible="notice-seven-7" class="notice notice-info is-dismissible euphony-blocks-admin-notice">
		<div class="euphony-blocks-admin-notice-wrapper">
			<h2><?php esc_html_e('Euphony Blocks Pro', 'euphony-blocks'); ?></h2>
			<p><?php esc_html_e('Get your hands on the WordPress Full Site Editing features. Start building your website with advanced block patterns and custom blocks! Get 70+ block patterns, 30 Templates, and 12 Template Parts that are highly customizable and fully responsive.', 'euphony-blocks'); ?></p>

			<a target="_blank" class="button-primary button green" href="<?php echo esc_url('https://catchthemes.com/themes/euphony-blocks-pro/'); ?>"><?php esc_html_e('Get Rock Tune Pro', 'euphony-blocks'); ?></a>

			<a class="button" href="<?php echo esc_url(admin_url('themes.php?page=euphony-blocks-theme')); ?>"><?php esc_html_e('Theme Info', 'euphony-blocks'); ?></a>
		</div>
	</div>
<?php
}
add_action( 'admin_init', array( 'PAnD', 'init' ) );
add_action( 'admin_notices', 'euphony_blocks_admin_plugin_notice' );

function euphony_blocks_theme_page_admin_style($hook)
{
	// Register theme stylesheet.
	$theme_version = wp_get_theme()->get('Version');

	$version_string = is_string($theme_version) ? $theme_version : false;
	wp_enqueue_style(
		'euphony-blocks-theme-admin-style',
		get_theme_file_uri('assets/css/about-admin.css'),
		array(),
		$version_string
	);
}
add_action('admin_enqueue_scripts', 'euphony_blocks_theme_page_admin_style');

/**
 * Add theme page
 */
function euphony_blocks_menu()
{
	add_theme_page(esc_html__('Euphony Blocks', 'euphony-blocks'), esc_html__('Euphony Blocks', 'euphony-blocks'), 'edit_theme_options', 'euphony-blocks-theme', 'euphony_blocks_theme_page_display');
}
add_action('admin_menu', 'euphony_blocks_menu');

/**
 * Display About page
 */
function euphony_blocks_theme_page_display()
{
	$theme = wp_get_theme();

	if (is_child_theme()) {
		$theme = wp_get_theme()->parent();
	}
?>

	<div id="welcome-panel" class="welcome-panel">
		<div class="welcome-panel-content">
			<div class="welcome-panel-header">
				<h2><?php echo esc_html($theme->Name); ?></h2>
				<p><?php esc_html_e('Full Site Editing WordPress Theme', 'euphony-blocks'); ?></p>
			</div>

			<div class="welcome-panel-column-container">
				<div class="container-wrap">
					<div class="welcome-panel-column two-columns">
						<!-- <div class="welcome-panel-icon-pages"></div> -->
						<div class="welcome-panel-column-content">
							<h3><?php esc_html_e('Getting Started with Euphony Blocks!', 'euphony-blocks'); ?></h3>
							<p><?php esc_html_e('Awesome! Euphony Blocks has been installed and activated successfully. Now, you can start building your dream website with a wide range of highly-customizable block patterns, templates, and template parts available in this astounding theme.', 'euphony-blocks'); ?></p>
							<a target="_blank" href="https://catchthemes.com/themes/euphony-blocks/#theme-instructions"><?php esc_html_e('Theme documentation', 'euphony-blocks'); ?></a>
						</div>
					</div>

					<div class="welcome-panel-column two-columns">
						<div class="welcome-panel-column-content">
							<h3><?php esc_html_e('More Features with Euphony Blocks Pro Theme', 'euphony-blocks'); ?></h3>
							<p><?php esc_html_e('To get more beautiful block patterns and templates, we recommend you upgrade to Euphony Blocks Pro. With the pro theme installed, get more options, blocks, block patterns, templates and template parts.', 'euphony-blocks'); ?></p>
							<p><?php esc_html_e('FSE Pro plugin is bundled with the theme when pro theme is purchased. Install the zip file to get more features.', 'euphony-blocks'); ?></p><a target="_blank" class="button green button-primary button-hero green" href="https://catchthemes.com/themes/euphony-blocks-pro/"><?php esc_html_e('Buy Euphony Blocks Pro', 'euphony-blocks'); ?></a>
						</div>
					</div>
				</div>
				<div class="sidebar">
					<div class="welcome-panel-column important-links">
						<!-- <div class="welcome-panel-icon-pages"></div> -->
						<div class="welcome-panel-column-content">
							<h3><?php esc_html_e('Important Links', 'euphony-blocks'); ?></h3>
							<a target="_blank" href="<?php echo esc_url($theme->get('ThemeURI')); ?>"><?php esc_html_e('Theme Info', 'euphony-blocks'); ?></a>
							<a target="_blank" href="https://fse.catchthemes.com/euphony-blocks"><?php esc_html_e('View Demo', 'euphony-blocks'); ?></a>
							<a target="_blank" href="<?php echo esc_url($theme->get('ThemeURI') . '/#theme-instructions'); ?>"><?php esc_html_e('Theme Instructions', 'euphony-blocks'); ?></a>
							<a target="_blank" href="<?php echo esc_url($theme->get('ThemeURI') . '/#changelog'); ?>"><?php esc_html_e('Change log', 'euphony-blocks'); ?></a>
							<a target="_blank" href="<?php echo esc_url('https://catchthemes.com/support-forum/forum/full-site-editing/'); ?>"><?php esc_html_e('Support', 'euphony-blocks'); ?></a>
						</div>
					</div>

					<div class="welcome-panel-column review">
						<!-- <div class="welcome-panel-icon-pages"></div> -->
						<div class="welcome-panel-column-content">
							<h3><?php esc_html_e('Leave us a review', 'euphony-blocks'); ?></h3>
							<p><?php esc_html_e('Loved Euphony Blocks? Feel free to leave your feedback. Your opinion helps us reach more audiences!', 'euphony-blocks'); ?></p>
							<a href="https://wordpress.org/support/theme/euphony-blocks/reviews/" class="button button-primary button-hero" style="text-decoration: none;" target="_blank"><?php esc_html_e('Review', 'euphony-blocks'); ?></a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php
}
