<?php
/**
 * Home Section Features Template
 *
 * @package Estate Vista
 */

// All section-specific code goes here...

$estate_vista_section_one = get_theme_mod('estate_vista_features_enable');
if ('Disable' === $estate_vista_section_one) {
    return;
}
?>

<section id="amenities" class="amenities-posts">
    <div class="container">
        <div class="section-heading-main">
            <?php if (get_theme_mod('estate_vista_features_title', true) != '') : ?>
                <h3><?php echo esc_html(get_theme_mod('estate_vista_features_title')); ?></h3>
            <?php endif; ?>
        </div>
        <div class="row">
            <div class="col-lg-4">
                <div class="feature-box">
                    <?php if (get_theme_mod('estate_vista_featureimage1_section') != '') : ?>
                        <img src="<?php echo esc_url(get_theme_mod('estate_vista_featureimage1_section')); ?>" alt="Feature Image 1">
                    <?php endif; ?>
                    <div class="feature-content-box">
                        <?php if (get_theme_mod('estate_vista_feature1_title') != '') : ?>
                            <h3><?php echo esc_html(get_theme_mod('estate_vista_feature1_title')); ?></h3>
                        <?php endif; ?>
                        <?php if (get_theme_mod('estate_vista_feature1_text') != '') : ?>
                            <p><?php echo esc_html(get_theme_mod('estate_vista_feature1_text')); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="feature-box">
                    <?php if (get_theme_mod('estate_vista_featureimage2_section') != '') : ?>
                        <img src="<?php echo esc_url(get_theme_mod('estate_vista_featureimage2_section')); ?>" alt="Feature Image 2">
                    <?php endif; ?>
                    <div class="feature-content-box">
                        <?php if (get_theme_mod('estate_vista_feature2_title') != '') : ?>
                            <h3><?php echo esc_html(get_theme_mod('estate_vista_feature2_title')); ?></h3>
                        <?php endif; ?>
                        <?php if (get_theme_mod('estate_vista_feature2_text') != '') : ?>
                            <p><?php echo esc_html(get_theme_mod('estate_vista_feature2_text')); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="feature-box">
                    <?php if (get_theme_mod('estate_vista_featureimage3_section') != '') : ?>
                        <img src="<?php echo esc_url(get_theme_mod('estate_vista_featureimage3_section')); ?>" alt="Feature Image 3">
                    <?php endif; ?>
                    <div class="feature-content-box">
                        <?php if (get_theme_mod('estate_vista_feature3_title') != '') : ?>
                            <h3><?php echo esc_html(get_theme_mod('estate_vista_feature3_title')); ?></h3>
                        <?php endif; ?>
                        <?php if (get_theme_mod('estate_vista_feature3_text') != '') : ?>
                            <p><?php echo esc_html(get_theme_mod('estate_vista_feature3_text')); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
