<?php
/**
 * Home Section About Template
 *
 * @package Estate Vista
 */

// All section-specific code goes here...

$estate_vista_section_one = get_theme_mod('estate_vista_about_enable');
if ('Disable' === $estate_vista_section_one) {
    return;
}
?>

<section id="about" class="about-section">
    <div class="container">
        <div class="section-heading-main">
            <?php if (get_theme_mod('estate_vista_about_title', true) != '') : ?>
                <h3><?php echo esc_html(get_theme_mod('estate_vista_about_title')); ?></h3>
            <?php endif; ?>
        </div>
        <div class="row">
            <div class="col-lg-4 col-12">
                <div class="about-left">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="about-box-img">
                                <?php if (get_theme_mod('estate_vista_aboutimage1_section') != '') : ?>
                                    <img src="<?php echo esc_url(get_theme_mod('estate_vista_aboutimage1_section')); ?>" alt="About Image">
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-8 col-12">
                <div class="about-right">
                    <?php if (get_theme_mod('estate_vista_about_name', true) != '') : ?>
                        <h3><?php echo esc_html(get_theme_mod('estate_vista_about_name')); ?></h3>
                    <?php endif; ?>
                    <?php if (get_theme_mod('estate_vista_about_title_second', true) != '') : ?>
                        <p><?php echo esc_html(get_theme_mod('estate_vista_about_title_second')); ?></p>
                    <?php endif; ?>
                    <?php if (get_theme_mod('estate_vista_about_para', true) != '') : ?>
                        <p><?php echo esc_html(get_theme_mod('estate_vista_about_para')); ?></p>
                    <?php endif; ?>
                    <?php if (get_theme_mod('estate_vista_about_btn_text') != '') : ?>
                        <div class="theme-btn">
                            <a href="<?php echo esc_url(get_theme_mod('estate_vista_about_btn_text_url')); ?>">
                                <?php echo esc_html(get_theme_mod('estate_vista_about_btn_text')); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>
